/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import jclass.table3.Clip;
import jclass.table3.DrawRange;
import jclass.table3.JCCellPosition;
import jclass.table3.JCCellRange;
import jclass.table3.Table;
import jclass.util.JCVector;

class Select {
    static JCCellRange old_range = new JCCellRange();
    static JCCellRange new_range = new JCCellRange();
    static JCCellRange inter = new JCCellRange();
    static JCCellRange r = new JCCellRange();
    static JCCellRange spannedRange = new JCCellRange();

    Select() {
    }

    static void cleanup(Table table) {
        int n = table.selected_cells.size();
        if (n < 2) {
            return;
        }
        JCCellRange jCCellRange = (JCCellRange)table.selected_cells.lastElement();
        int n2 = n - 2;
        while (n2 >= 0) {
            if (jCCellRange.equals(table.selected_cells.elementAt(n2))) {
                table.selected_cells.removeElementAt(n2);
            }
            --n2;
        }
    }

    static void copy(Table table) {
        JCCellRange jCCellRange;
        int n = table.selected_cells.size();
        if (n == 0) {
            return;
        }
        int n2 = table.selection_policy;
        n = table.selected_cells.size();
        if (table.mode == 1 && n2 == 1) {
            n2 = 2;
        }
        switch (n2) {
            case 0: {
                table.selected_cells.removeAllElements();
                return;
            }
            case 1: {
                n = 1;
                jCCellRange = (JCCellRange)table.selected_cells.firstElement();
                if (!Table.isCell(jCCellRange.start_row, jCCellRange.start_column)) {
                    table.selected_cells.removeAllElements();
                    return;
                }
                jCCellRange.end_row = jCCellRange.start_row;
                jCCellRange.end_column = jCCellRange.start_column;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
        }
        JCVector jCVector = new JCVector(n);
        int n3 = 0;
        while (n3 < n) {
            jCCellRange = (JCCellRange)table.selected_cells.elementAt(n3);
            jCVector.addElement(jCCellRange);
            if (table.mode == 1) {
                ((JCCellRange)jCVector.lastElement()).start_column = 0;
                ((JCCellRange)jCVector.lastElement()).end_column = Integer.MAX_VALUE;
            }
            ++n3;
        }
        table.selected_cells = jCVector;
    }

    static void createSelectedRange(Table table, int n, int n2) {
        int n3;
        int n4;
        if (n == -998 && n2 == -998) {
            table.selected_cells.removeAllElements();
        }
        int n5 = n4 = n;
        int n6 = n3 = n2;
        if (n == -998 || n == -997 || n == -1) {
            n5 = 0;
            n4 = Integer.MAX_VALUE;
        }
        if (n2 == -998 || n2 == -997 || n2 == -1) {
            n6 = 0;
            n3 = Integer.MAX_VALUE;
        }
        JCCellRange jCCellRange = new JCCellRange(n5, n6, n4, n3);
        table.selected_cells.addElement(jCCellRange);
        DrawRange.draw(table, jCCellRange);
        table.afterCellSelected();
    }

    static void deselectAll(Table table) {
        if (table.selected_cells.size() == 0) {
            return;
        }
        JCVector jCVector = (JCVector)table.selected_cells.clone();
        table.selected_cells.removeAllElements();
        if (!table.repaint) {
            table.needs_repaint = true;
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            DrawRange.draw(table, (JCCellRange)jCVector.elementAt(n));
            ++n;
        }
    }

    private static void draw(Table table, int n, int n2, JCCellRange[] jCCellRangeArray) {
        JCCellPosition jCCellPosition;
        if (table.span.span_list.size() > 0 && table.span.find(n, n2, jCCellPosition = new JCCellPosition()) != -999) {
            n = jCCellPosition.row;
            n2 = jCCellPosition.column;
        }
        if (jCCellRangeArray != null) {
            int n3 = 0;
            while (n3 < jCCellRangeArray.length) {
                if (jCCellRangeArray[n3].inside(n, n2)) {
                    return;
                }
                ++n3;
            }
        }
        table.paint(n, n2);
    }

    static void drawList(Table table, JCVector jCVector) {
        Object[] objectArray = null;
        if (jCVector != null && jCVector.size() > 0) {
            objectArray = jCVector.getArrayCopy();
        }
        if (table.selected_cells.size() == 0) {
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    DrawRange.draw(table, (JCCellRange)objectArray[n]);
                    ++n;
                }
            }
            return;
        }
        if (!table.repaint) {
            table.needs_repaint = true;
            return;
        }
        int n = 0;
        while (n < table.selected_cells.size()) {
            Select.drawRange(table, (JCCellRange)table.selected_cells.elementAt(n), jCVector);
            ++n;
        }
        if (objectArray != null) {
            n = 0;
            while (n < objectArray.length) {
                Select.drawRange(table, (JCCellRange)objectArray[n], table.selected_cells);
                ++n;
            }
        }
    }

    private static void drawRange(Table table, JCCellRange jCCellRange, JCVector jCVector) {
        int n;
        int n2;
        Object[] objectArray;
        JCCellRange jCCellRange2 = table.getVisibleCells();
        if (jCCellRange2 == null) {
            return;
        }
        int n3 = jCCellRange2.start_row;
        int n4 = jCCellRange2.end_row;
        int n5 = jCCellRange2.start_column;
        int n6 = jCCellRange2.end_column;
        if (jCVector != null && jCVector.size() > 0) {
            objectArray = new JCCellRange[jCVector.size()];
            jCVector.copyInto(objectArray);
        } else {
            objectArray = null;
        }
        if (jCCellRange.end_column == Integer.MAX_VALUE) {
            n2 = 0;
            while (n2 < table.frozen_rows) {
                if (jCCellRange.inRowRange2(n2)) {
                    Select.draw(table, n2, -1, (JCCellRange[])objectArray);
                }
                ++n2;
            }
            n2 = n3;
            while (n2 <= n4) {
                if (jCCellRange.inRowRange2(n2)) {
                    Select.draw(table, n2, -1, (JCCellRange[])objectArray);
                }
                ++n2;
            }
        }
        if (jCCellRange.end_row == Integer.MAX_VALUE) {
            n = 0;
            while (n < table.frozen_columns) {
                if (jCCellRange.inColumnRange2(n)) {
                    Select.draw(table, -1, n, (JCCellRange[])objectArray);
                }
                ++n;
            }
            n = n5;
            while (n <= n6) {
                if (jCCellRange.inColumnRange2(n)) {
                    Select.draw(table, -1, n, (JCCellRange[])objectArray);
                }
                ++n;
            }
        }
        if (jCCellRange.start_row == -1 && jCCellRange.end_row == -1) {
            n = n5;
            while (n <= n6) {
                if (jCCellRange.inside(-1, n)) {
                    Select.draw(table, -1, n, (JCCellRange[])objectArray);
                }
                ++n;
            }
            n = 0;
            while (n < table.frozen_columns) {
                if (jCCellRange.inside(-1, n)) {
                    Select.draw(table, -1, n, (JCCellRange[])objectArray);
                }
                ++n;
            }
        }
        if (jCCellRange.start_column == -1 && jCCellRange.end_column == -1) {
            n2 = n3;
            while (n2 <= n4) {
                if (jCCellRange.inside(n2, -1)) {
                    Select.draw(table, n2, -1, (JCCellRange[])objectArray);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < table.frozen_rows) {
                if (jCCellRange.inside(n2, -1)) {
                    Select.draw(table, n2, -1, (JCCellRange[])objectArray);
                }
                ++n2;
            }
        }
        n2 = n3;
        while (n2 <= n4) {
            n = n5;
            while (n <= n6) {
                if (jCCellRange.inside(n2, n)) {
                    Select.draw(table, n2, n, (JCCellRange[])objectArray);
                }
                ++n;
            }
            n = 0;
            while (n < table.frozen_columns) {
                if (jCCellRange.inside(n2, n)) {
                    Select.draw(table, n2, n, (JCCellRange[])objectArray);
                }
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < table.frozen_rows) {
            n = n5;
            while (n <= n6) {
                if (jCCellRange.inside(n2, n)) {
                    Select.draw(table, n2, n, (JCCellRange[])objectArray);
                }
                ++n;
            }
            n = 0;
            while (n < table.frozen_columns) {
                if (jCCellRange.inside(n2, n)) {
                    Select.draw(table, n2, n, (JCCellRange[])objectArray);
                }
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < table.span.span_list.size()) {
            jCCellRange2 = (JCCellRange)table.span.span_list.elementAt(n2);
            if (jCCellRange.overlaps(jCCellRange2) && !table.isVisible(jCCellRange2.start_row, jCCellRange2.start_column)) {
                Select.draw(table, jCCellRange2.start_row, jCCellRange2.start_column, (JCCellRange[])objectArray);
            }
            ++n2;
        }
    }

    static boolean equal(JCVector jCVector, JCVector jCVector2) {
        if (jCVector == null && jCVector2 == null) {
            return true;
        }
        if (jCVector == null) {
            return false;
        }
        return jCVector.equals((Object)jCVector2);
    }

    static JCCellRange extendRange(Table table, int n, int n2) {
        if (table.selected_cells.size() == 0) {
            return null;
        }
        JCCellRange jCCellRange = (JCCellRange)table.selected_cells.lastElement();
        int n3 = jCCellRange.start_row;
        int n4 = jCCellRange.start_column;
        int n5 = jCCellRange.end_row;
        int n6 = jCCellRange.end_column;
        n = Math.max(n, 0);
        n2 = Math.max(n2, 0);
        if (n6 == Integer.MAX_VALUE) {
            n5 = n;
        }
        if (n5 == Integer.MAX_VALUE) {
            n6 = n2;
        }
        if (n6 != Integer.MAX_VALUE && n5 != Integer.MAX_VALUE) {
            n5 = n;
            n6 = n2;
        }
        return new JCCellRange(n3, n4, n5, n6);
    }

    static boolean getSelectedRange(Table table, int n, JCCellRange jCCellRange) {
        if (n > table.selected_cells.size() - 1) {
            return false;
        }
        JCCellRange jCCellRange2 = (JCCellRange)table.selected_cells.elementAt(n);
        jCCellRange.start_row = Math.min(jCCellRange2.start_row, jCCellRange2.end_row);
        jCCellRange.end_row = Math.max(jCCellRange2.start_row, jCCellRange2.end_row);
        jCCellRange.end_row = Math.min(table.rows - 1, jCCellRange.end_row);
        jCCellRange.start_column = Math.min(jCCellRange2.start_column, jCCellRange2.end_column);
        jCCellRange.end_column = Math.max(jCCellRange2.start_column, jCCellRange2.end_column);
        jCCellRange.end_column = Math.min(table.columns - 1, jCCellRange.end_column);
        return true;
    }

    static boolean isSelected(Table table, int n, int n2) {
        if (table.selected_cells.size() > 0) {
            int n3 = 0;
            while (n3 < table.selected_cells.size()) {
                r = (JCCellRange)table.selected_cells.elementAt(n3);
                spannedRange.reshape(-999, -999, -999, -999);
                table.span.find(n, n2, spannedRange, null);
                if (spannedRange.overlaps(r)) {
                    return true;
                }
                if (r.inside(n, n2)) {
                    return true;
                }
                if (Table.isRowLabel(n, n2) && Select.r.end_column == Integer.MAX_VALUE && r.inRowRange2(n)) {
                    return true;
                }
                if (Table.isColumnLabel(n, n2) && Select.r.end_row == Integer.MAX_VALUE && r.inColumnRange2(n2)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    static void redisplay(Table table) {
        JCVector jCVector = table.selected_cells;
        int n = 0;
        int n2 = jCVector.size();
        while (n < n2) {
            JCCellRange jCCellRange = (JCCellRange)jCVector.elementAt(n);
            DrawRange.draw(table, jCCellRange);
            ++n;
        }
    }

    static void selectAll(Table table) {
        Select.createSelectedRange(table, -998, -998);
        if (!table.repaint) {
            table.needs_repaint = true;
            return;
        }
        DrawRange.draw(table, new JCCellRange(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    static void setSelectedRange(Table table, int n, int n2) {
        int n3;
        int n4;
        if (table.selected_cells.size() == 0) {
            Select.createSelectedRange(table, n, n2);
            return;
        }
        JCCellRange jCCellRange = (JCCellRange)table.selected_cells.lastElement();
        int n5 = jCCellRange.start_row;
        int n6 = jCCellRange.start_column;
        int n7 = jCCellRange.end_row;
        int n8 = jCCellRange.end_column;
        old_range.reshape(Math.min(n5, n7), Math.min(n6, n8), Math.max(n5, n7), Math.max(n6, n8));
        n = Math.max(n, 0);
        n2 = Math.max(n2, 0);
        if (n8 == Integer.MAX_VALUE) {
            n7 = n;
        }
        if (n7 == Integer.MAX_VALUE) {
            n8 = n2;
        }
        if (n8 != Integer.MAX_VALUE && n7 != Integer.MAX_VALUE) {
            n7 = n;
            n8 = n2;
        }
        ((JCCellRange)table.selected_cells.lastElement()).reshape(n5, n6, n7, n8);
        JCCellRange jCCellRange2 = table.getVisibleCells();
        if (jCCellRange2 == null) {
            return;
        }
        new_range.reshape(Math.min(n5, n7), Math.min(n6, n8), Math.max(n5, n7), Math.max(n6, n8));
        int n9 = jCCellRange2.start_row;
        int n10 = jCCellRange2.end_row;
        int n11 = jCCellRange2.start_column;
        int n12 = jCCellRange2.end_column;
        n9 = Math.max(n9, Math.min(Select.old_range.start_row, Select.new_range.start_row));
        n11 = Math.max(n11, Math.min(Select.old_range.start_column, Select.new_range.start_column));
        n10 = Math.min(n10, Math.max(Select.old_range.end_row, Select.new_range.end_row));
        n12 = Math.min(n12, Math.max(Select.old_range.end_column, Select.new_range.end_column));
        if (Select.old_range.end_column == Integer.MAX_VALUE) {
            n4 = 0;
            while (n4 < table.frozen_rows) {
                if (old_range.inRowRange(n4) && !new_range.inRowRange(n4)) {
                    table.paint(n4, -1);
                }
                ++n4;
            }
            n4 = n9;
            while (n4 <= n10) {
                if (old_range.inRowRange(n4) && !new_range.inRowRange(n4)) {
                    table.paint(n4, -1);
                }
                ++n4;
            }
        }
        if (Select.old_range.end_row == Integer.MAX_VALUE) {
            n3 = 0;
            while (n3 < table.frozen_columns) {
                if (old_range.inColumnRange(n3) && !new_range.inColumnRange(n3)) {
                    table.paint(-1, n3);
                }
                ++n3;
            }
            n3 = n11;
            while (n3 <= n12) {
                if (old_range.inColumnRange(n3) && !new_range.inColumnRange(n3)) {
                    table.paint(-1, n3);
                }
                ++n3;
            }
        }
        int n13 = Integer.MAX_VALUE;
        int n14 = 0;
        int n15 = Integer.MAX_VALUE;
        int n16 = 0;
        n4 = n9;
        while (n4 <= n10) {
            if (old_range.inRowRange(n4) && !new_range.inRowRange(n4)) {
                if (n4 < n13) {
                    n13 = n4;
                }
                if (n4 > n14) {
                    n14 = n4;
                }
            }
            ++n4;
        }
        n3 = n11;
        while (n3 <= n12) {
            if (old_range.inColumnRange(n3) && !new_range.inColumnRange(n3)) {
                if (n3 < n15) {
                    n15 = n3;
                }
                if (n3 > n16) {
                    n16 = n3;
                }
            }
            ++n3;
        }
        Clip clip = Clip.find_by_type(table, 0);
        if (clip != null) {
            if (n14 >= n13 && n15 == Integer.MAX_VALUE) {
                clip.paint(n13, Select.old_range.start_column, n14, Select.old_range.end_column);
            } else if (n16 >= n15 && n13 == Integer.MAX_VALUE) {
                clip.paint(Select.old_range.start_row, n15, Select.old_range.end_row, n16);
            } else if (n14 >= n13 && n16 >= n15) {
                clip.paint(n13, n15, n14, n16);
                clip.paint(n13, Select.old_range.start_column, n14, Select.old_range.end_column);
                clip.paint(Select.old_range.start_row, n15, Select.old_range.end_row, n16);
            }
        }
        n4 = n9;
        while (n4 <= n10) {
            n3 = 0;
            while (n3 < table.frozen_columns) {
                if (old_range.inside(n4, n3) && !new_range.inside(n4, n3)) {
                    table.paint(n4, n3);
                }
                ++n3;
            }
            ++n4;
        }
        if (table.frozen_rows > 0) {
            n4 = 0;
            while (n4 < table.frozen_rows) {
                n3 = n11;
                while (n3 <= n12) {
                    if (old_range.inside(n4, n3) && !new_range.inside(n4, n3)) {
                        table.paint(n4, n3);
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 < table.frozen_columns) {
                    if (old_range.inside(n4, n3) && !new_range.inside(n4, n3)) {
                        table.paint(n4, n3);
                    }
                    ++n3;
                }
                ++n4;
            }
        }
        n9 = Math.max(n9, Select.new_range.start_row);
        n10 = Math.min(n10, Select.new_range.end_row);
        n11 = Math.max(n11, Select.new_range.start_column);
        n12 = Math.min(n12, Select.new_range.end_column);
        if (old_range.overlaps(new_range)) {
            old_range.intersection(new_range, inter);
        }
        if (Select.new_range.end_column == Integer.MAX_VALUE) {
            n4 = 0;
            while (n4 < table.frozen_rows) {
                if (new_range.inRowRange(n4) && (inter == null || !inter.inRowRange(n4))) {
                    table.paint(n4, -1);
                }
                ++n4;
            }
            n4 = n9;
            while (n4 <= n10) {
                if (inter == null || !inter.inRowRange(n4)) {
                    table.paint(n4, -1);
                }
                ++n4;
            }
        }
        if (Select.new_range.end_row == Integer.MAX_VALUE) {
            n3 = 0;
            while (n3 < table.frozen_columns) {
                if (new_range.inColumnRange(n3) && (inter == null || !inter.inColumnRange(n3))) {
                    table.paint(-1, n3);
                }
                ++n3;
            }
            n3 = n11;
            while (n3 <= n12) {
                if (inter == null || !inter.inColumnRange(n3)) {
                    table.paint(-1, n3);
                }
                ++n3;
            }
        }
        n4 = n9;
        while (n4 <= n10) {
            n3 = 0;
            while (n3 < table.frozen_columns) {
                if (new_range.inside(n4, n3) && (inter == null || !inter.inside(n4, n3))) {
                    table.paint(n4, n3);
                }
                ++n3;
            }
            ++n4;
        }
        if (table.frozen_rows > 0) {
            n4 = 0;
            while (n4 < table.frozen_rows) {
                n3 = n11;
                while (n3 <= n12) {
                    if (new_range.inside(n4, n3) && (inter == null || !inter.inside(n4, n3))) {
                        table.paint(n4, n3);
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 < table.frozen_columns) {
                    if (new_range.inside(n4, n3) && (inter == null || !inter.inside(n4, n3))) {
                        table.paint(n4, n3);
                    }
                    ++n3;
                }
                ++n4;
            }
        }
        n13 = Integer.MAX_VALUE;
        n14 = 0;
        n15 = Integer.MAX_VALUE;
        n16 = 0;
        n4 = n9;
        while (n4 <= n10) {
            if (inter == null || !inter.inRowRange(n4)) {
                if (n4 < n13) {
                    n13 = n4;
                }
                if (n4 > n14) {
                    n14 = n4;
                }
            }
            ++n4;
        }
        n3 = n11;
        while (n3 <= n12) {
            if (inter == null || !inter.inColumnRange(n3)) {
                if (n3 < n15) {
                    n15 = n3;
                }
                if (n3 > n16) {
                    n16 = n3;
                }
            }
            ++n3;
        }
        if (clip != null) {
            if (n14 >= n13 && n15 == Integer.MAX_VALUE) {
                clip.paint(n13, Select.old_range.start_column, n14, Select.old_range.end_column);
            } else if (n16 >= n15 && n13 == Integer.MAX_VALUE) {
                clip.paint(Select.old_range.start_row, n15, Select.old_range.end_row, n16);
            } else if (n14 >= n13 && n16 >= n15) {
                clip.paint(n13, n15, n14, n16);
                clip.paint(n13, Select.old_range.start_column, n14, Select.old_range.end_column);
                clip.paint(Select.old_range.start_row, n15, Select.old_range.end_row, n16);
            }
        }
    }
}

