/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jclass.table3.JCPrintPage;
import jclass.table3.JCPrintTable;

public class JCPrintPreview
extends JFrame
implements WindowListener,
ActionListener {
    JButton first_button;
    JButton prev_button;
    JButton next_button;
    JButton last_button;
    JButton print_button;
    JButton printall_button;
    JButton close_button;
    JLabel status;
    JScrollPane pane;
    JCPrintTable table;
    JCPrintPage print_page;
    int current_page = 0;
    int num_pages = 0;
    int width;
    int height;
    PrintJob job;

    public JCPrintPreview(String string, JCPrintTable jCPrintTable) {
        this(string, jCPrintTable, null);
    }

    public JCPrintPreview(String string, JCPrintTable jCPrintTable, JFrame jFrame) {
        super(string);
        Cloneable cloneable;
        this.table = jCPrintTable;
        try {
            cloneable = new Properties();
            this.job = jFrame != null ? Toolkit.getDefaultToolkit().getPrintJob(jFrame, string, (Properties)cloneable) : this.getToolkit().getPrintJob(this, string, (Properties)cloneable);
        }
        catch (Exception exception) {
            System.out.println("PrintJob error: " + exception.getMessage());
            return;
        }
        if (this.job == null) {
            return;
        }
        cloneable = this.job.getPageDimension();
        if (((Dimension)cloneable).width == 0 || ((Dimension)cloneable).height == 0) {
            ((Dimension)cloneable).width = 612;
            ((Dimension)cloneable).height = 792;
        }
        this.width = ((Dimension)cloneable).width;
        this.height = ((Dimension)cloneable).height;
        jCPrintTable.setPageDimensions(((Dimension)cloneable).width, ((Dimension)cloneable).height);
        this.num_pages = jCPrintTable.getNumPages();
        this.getContentPane().setLayout(new BorderLayout());
        ((Component)this).setBackground(Color.lightGray);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 1, 1));
        this.first_button = new JButton("First");
        jPanel.add(this.first_button);
        this.first_button.addActionListener(this);
        this.prev_button = new JButton("Previous");
        jPanel.add(this.prev_button);
        this.prev_button.addActionListener(this);
        this.next_button = new JButton("Next");
        jPanel.add(this.next_button);
        this.next_button.addActionListener(this);
        this.last_button = new JButton("Last");
        jPanel.add(this.last_button);
        this.last_button.addActionListener(this);
        this.print_button = new JButton("Print");
        jPanel.add(this.print_button);
        this.print_button.addActionListener(this);
        this.printall_button = new JButton("PrintAll");
        jPanel.add(this.printall_button);
        this.printall_button.addActionListener(this);
        this.close_button = new JButton("Close");
        jPanel.add(this.close_button);
        this.close_button.addActionListener(this);
        this.getContentPane().add((Component)jPanel, "North");
        Dimension dimension = new Dimension((int)((double)this.width * 1.05), (int)((double)this.height * 1.05));
        this.print_page = new JCPrintPage(dimension);
        this.print_page.setSize(this.print_page.getPreferredSize());
        this.pane = new JScrollPane(this.print_page);
        this.getContentPane().add((Component)this.pane, "Center");
        this.status = new JLabel("", 0);
        this.getContentPane().add((Component)this.status, "South");
        this.addWindowListener(this);
        ((Component)this).setSize(600, 500);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("First")) {
            this.showPage(0);
        } else if (actionEvent.getActionCommand().equals("Previous")) {
            if (this.current_page > 0) {
                this.showPage(this.current_page - 1);
            }
        } else if (actionEvent.getActionCommand().equals("Next")) {
            if (this.current_page + 1 < this.num_pages) {
                this.showPage(this.current_page + 1);
            }
        } else if (actionEvent.getActionCommand().equals("Last")) {
            this.showPage(this.num_pages - 1);
        } else if (actionEvent.getActionCommand().equals("Print")) {
            if (this.job != null) {
                Graphics graphics = this.job.getGraphics();
                this.table.paintPage(graphics, this.current_page);
                graphics.dispose();
            }
        } else if (actionEvent.getActionCommand().equals("PrintAll")) {
            if (this.job != null) {
                int n = 0;
                while (n < this.num_pages) {
                    Graphics graphics = this.job.getGraphics();
                    this.table.paintPage(graphics, n);
                    graphics.dispose();
                    ++n;
                }
            }
        } else if (actionEvent.getActionCommand().equals("Close")) {
            if (this.job != null) {
                this.job.end();
            }
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public void showPage(int n) {
        if (this.job == null) {
            return;
        }
        this.current_page = n;
        Image image = this.createImage(this.width, this.height);
        Graphics graphics = image.getGraphics();
        this.table.paintPage(graphics, n);
        this.print_page.setImage(image);
        graphics.dispose();
        this.status.setText("Page " + (this.current_page + 1) + " of " + this.num_pages + ".");
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

