/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StreamTokenizer;
import jclass.table3.VectorDataSource;
import jclass.util.JCVector;

public class InputStreamDataSource
extends VectorDataSource
implements Serializable {
    private StreamTokenizer tokenizer;
    private final char QUOTE = (char)39;
    static final int PARSE_ERR_DATA_STYLE = 1;
    static final int PARSE_ERR_VALUE = 2;
    static final int PARSE_ERR_COLUMN_LABEL = 3;
    static final int PARSE_ERR_ROW_LABEL = 4;
    private boolean isDebug = false;
    private boolean isLabels = false;

    protected InputStreamDataSource() {
    }

    public InputStreamDataSource(InputStream inputStream) throws IOException {
        this.ctor(inputStream);
    }

    protected void ctor(InputStream inputStream) throws IOException {
        this.tokenizer = new StreamTokenizer(inputStream);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(39);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.lowerCaseMode(false);
        this.tokenizer.parseNumbers();
        this.tokenizer.whitespaceChars(43, 43);
        this.init();
        this.tokenizer = null;
    }

    private void displayErrorMessage(int n) {
        boolean bl = true;
        String string = "Error reading data: line " + this.tokenizer.lineno() + ": ";
        switch (n) {
            case 1: {
                string = String.valueOf(string) + "Expect data type TABLE and not ";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "Expect data value and not ";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "Expect a column label and not ";
                break;
            }
            case 4: {
                string = String.valueOf(string) + "Expect a row label and not ";
                break;
            }
            default: {
                return;
            }
        }
        if (bl) {
            string = this.tokenizer.ttype == 39 ? String.valueOf(string) + "'" + this.tokenizer.sval + "'" : (this.tokenizer.ttype == -3 ? String.valueOf(string) + this.tokenizer.sval : (this.tokenizer.ttype == -2 ? String.valueOf(string) + this.tokenizer.nval : String.valueOf(string) + this.tokenizer.toString()));
        }
        System.err.println(string);
    }

    private double getNextDouble() throws IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != -2) {
            this.displayErrorMessage(2);
            throw new IOException("Error in data file format - " + this.tokenizer);
        }
        double d = this.tokenizer.nval;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype == -3 && this.tokenizer.sval != null && (this.tokenizer.sval.charAt(0) == 'e' || this.tokenizer.sval.charAt(0) == 'E')) {
            if (this.tokenizer.sval.length() == 1) {
                this.tokenizer.nextToken();
                if (this.tokenizer.ttype == -2) {
                    d *= Math.pow(10.0, this.tokenizer.nval);
                }
            } else {
                String string = this.tokenizer.sval;
                int n = Integer.valueOf(this.tokenizer.sval.substring(1));
                d *= Math.pow(10.0, n);
            }
        } else {
            this.tokenizer.pushBack();
        }
        return d;
    }

    private Object getNextToken() throws IOException {
        Object object = null;
        this.tokenizer.nextToken();
        switch (this.tokenizer.ttype) {
            case 39: {
                object = new String(this.tokenizer.sval);
                break;
            }
            case -3: {
                object = new String(this.tokenizer.sval);
                break;
            }
            case -2: {
                double d = this.tokenizer.nval;
                this.tokenizer.nextToken();
                if (this.tokenizer.ttype == -3 && this.tokenizer.sval != null && (this.tokenizer.sval.charAt(0) == 'e' || this.tokenizer.sval.charAt(0) == 'E')) {
                    if (this.tokenizer.sval.length() == 1) {
                        this.tokenizer.nextToken();
                        if (this.tokenizer.ttype == -2) {
                            d *= Math.pow(10.0, this.tokenizer.nval);
                        }
                    } else {
                        String string = this.tokenizer.sval;
                        int n = Integer.valueOf(this.tokenizer.sval.substring(1));
                        d *= Math.pow(10.0, n);
                    }
                } else {
                    this.tokenizer.pushBack();
                }
                object = new Double(d);
                break;
            }
            default: {
                this.displayErrorMessage(2);
                throw new IOException("Error in data file format - " + this.tokenizer);
            }
        }
        return object;
    }

    private synchronized void init() throws IOException {
        boolean bl = false;
        this.isDebug = false;
        this.isLabels = false;
        if (this.tokenizer.nextToken() != -3) {
            bl = true;
        } else if (this.tokenizer.sval.equalsIgnoreCase("debug")) {
            this.isDebug = true;
            if (this.tokenizer.nextToken() != -3) {
                bl = true;
            }
        }
        if (bl || !this.tokenizer.sval.equalsIgnoreCase("table")) {
            this.displayErrorMessage(1);
            throw new IOException("Data must start with TABLE");
        }
        int n = (int)this.getNextDouble();
        int n2 = (int)this.getNextDouble();
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equalsIgnoreCase("nolabel")) {
            this.isLabels = false;
        } else {
            this.isLabels = true;
            this.tokenizer.pushBack();
        }
        if (this.isDebug) {
            System.out.println("Reading in TABLE format with " + n + " rows and " + n2 + " columns with " + (this.isLabels ? "labels" : "no labels"));
        }
        this.readArrayData(n, n2);
    }

    private void readArrayData(int n, int n2) throws IOException {
        int n3;
        Object object = null;
        JCVector jCVector = null;
        if (this.isLabels) {
            n3 = 0;
            while (n3 < n2) {
                object = this.getNextToken();
                this.column_labels.addElement(object);
                if (this.isDebug) {
                    System.out.println("Column Label " + n3 + " is " + object);
                }
                ++n3;
            }
        }
        int n4 = 0;
        while (n4 < n) {
            if (this.isLabels) {
                object = this.getNextToken();
                this.row_labels.addElement(object);
                if (this.isDebug) {
                    System.out.println("Row Label " + n4 + " is " + object);
                }
            }
            jCVector = new JCVector();
            n3 = 0;
            while (n3 < n2) {
                object = this.getNextToken();
                jCVector.addElement(object);
                if (this.isDebug) {
                    System.out.println("Value at row " + n4 + " col " + n3 + " is " + object);
                }
                ++n3;
            }
            this.cells.addElement(jCVector);
            ++n4;
        }
        this.rows = n;
        this.columns = n2;
    }
}

