/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.io.Serializable;
import jclass.table3.ChainUtil;

class Chain
implements Serializable {
    private int[] values;
    private int[] positions;
    private int values_len;
    private ChainUtil chain;
    static int MAXSIZE = 1000;
    private static final int INCR = 20;

    Chain() {
        this(0);
    }

    Chain(int n) {
        if (n < MAXSIZE) {
            this.values = new int[n];
            this.positions = new int[n];
            this.values_len = this.values.length;
        } else {
            this.chain = new ChainUtil(n);
        }
    }

    void append(int n) {
        this.appendNocalc(n);
        if (this.values != null) {
            this.calcPositions(this.values_len - 2);
        }
    }

    void appendNocalc(int n) {
        if (this.values == null) {
            this.chain.append(n);
        } else {
            this.setSize(++this.values_len);
            this.values[this.values_len - 1] = n;
        }
    }

    void calcPositions(int n) {
        if (n < 0) {
            n = 0;
        }
        if (this.values_len <= 0 || this.values.length <= 0 || this.positions.length <= 0) {
            return;
        }
        int n2 = n;
        int n3 = this.positions[n];
        while (n2 < this.values_len) {
            this.positions[n2] = n3;
            n3 += this.values[n2];
            ++n2;
        }
    }

    static void changeMaxSize(int n) {
        MAXSIZE = n;
    }

    void delete(int n, int n2) {
        if (this.values == null) {
            this.chain.delete(n, n2);
        } else {
            if (n < 0 || n > this.values_len || n2 < 0 || n2 > this.values_len || n2 < n) {
                return;
            }
            int n3 = this.values.length;
            int[] nArray = this.values;
            this.values = new int[n3 - n2 + n - 1];
            System.arraycopy(nArray, 0, this.values, 0, n);
            System.arraycopy(nArray, n2 + 1, this.values, n, n3 - n2 - 1);
            n2 = Math.min(n2, this.values_len - 1);
            this.values_len -= n2 - n + 1;
            nArray = this.positions;
            this.positions = new int[n3 - n2 + n - 1];
            System.arraycopy(nArray, 0, this.positions, 0, n);
            this.calcPositions(n - 1);
        }
    }

    int getPosition(int n) {
        if (this.values == null) {
            return this.chain.getRunSum(n);
        }
        if (n >= this.positions.length) {
            return 0;
        }
        return this.positions[n];
    }

    int getValue(int n) {
        if (this.values == null) {
            return this.chain.getRunLen(n);
        }
        if (n >= this.values.length) {
            return -1;
        }
        return this.values[n];
    }

    public int getValueAtPosition(int n, int n2) {
        if (this.values == null) {
            return this.chain.getValueAtPosition(n);
        }
        if (this.values.length == 0) {
            return -999;
        }
        if (n < this.getPosition(n2)) {
            int n3 = n2 - 1;
            while (n3 > 0) {
                if (this.getPosition(n3) < n) {
                    return n3;
                }
                --n3;
            }
            return Integer.MIN_VALUE;
        }
        if (n > this.getPosition(n2)) {
            int n4 = n2 + 1;
            while (n4 < this.values_len) {
                if (this.getPosition(n4) > n) {
                    return n4 - 1;
                }
                ++n4;
            }
            if (this.getPosition(this.values_len - 1) + this.getValue(this.values_len - 1) >= n) {
                return this.values_len - 1;
            }
            return Integer.MAX_VALUE;
        }
        return n2;
    }

    void insert(Chain chain, int n) {
        if (chain == null) {
            return;
        }
        if (this.values != null && n > MAXSIZE) {
            this.chain = new ChainUtil(this.values);
            this.positions = null;
            this.values = null;
        }
        if (this.values == null) {
            if (chain == null) {
                return;
            }
            if (chain.values == null) {
                this.chain.insert(chain.chain, n);
            } else {
                this.chain.insert(new ChainUtil(chain.values), n);
            }
            return;
        }
        if (n < 0 || n > this.values_len) {
            return;
        }
        int[] nArray = chain.values != null ? chain.values : chain.chain.getArray();
        int n2 = chain.values != null ? chain.values_len : nArray.length;
        int n3 = this.values_len;
        this.values_len += n2;
        int[] nArray2 = this.positions;
        this.setSize(this.values_len);
        if (n < n3) {
            System.arraycopy(this.values, n, this.values, n + n2, n3 - n);
        }
        System.arraycopy(chain.values, 0, this.values, n, n2);
        this.calcPositions(n - 1);
    }

    void move(int n, int n2, int n3) {
        if (this.values == null) {
            this.chain.move(n, n2, n3);
        } else {
            if (n + n2 > this.values.length || n3 > this.values.length || n2 <= 0) {
                return;
            }
            int[] nArray = this.values;
            this.values = new int[nArray.length];
            try {
                if (n3 > n) {
                    System.arraycopy(nArray, 0, this.values, 0, n);
                    System.arraycopy(nArray, n + n2, this.values, n, n3 - (n + n2));
                    System.arraycopy(nArray, n, this.values, n3 - n2, n2);
                    System.arraycopy(nArray, n3, this.values, n3, nArray.length - n3);
                } else {
                    System.arraycopy(nArray, 0, this.values, 0, n3);
                    System.arraycopy(nArray, n, this.values, n3, n2);
                    System.arraycopy(nArray, n3, this.values, n3 + n2, n - n3);
                    System.arraycopy(nArray, n + n2, this.values, n + n2, nArray.length - (n + n2));
                }
            }
            catch (Throwable throwable) {
                this.values = nArray;
            }
            this.calcPositions(Math.min(n, n3));
        }
    }

    private int[] setArraySize(int[] nArray, int n) {
        int n2 = nArray.length;
        if (n > n2) {
            int[] nArray2 = nArray;
            nArray = new int[Math.max(n2 + 20, n)];
            if (n2 > 0) {
                System.arraycopy(nArray2, 0, nArray, 0, n2);
            }
        }
        return nArray;
    }

    private void setSize(int n) {
        this.values = this.setArraySize(this.values, n);
        this.positions = this.setArraySize(this.positions, n);
    }

    void setValue(int n, int n2, int n3) {
        if (this.values != null && n2 > MAXSIZE) {
            this.chain = new ChainUtil(this.values);
            this.positions = null;
            this.values = null;
        }
        if (this.values == null) {
            this.chain.setRunLen(n, Math.max(n, n2), n3);
        } else {
            if (n < 0 || n > this.values_len) {
                return;
            }
            if (n2 < 0 || n2 > this.values_len) {
                return;
            }
            int[] nArray = this.positions;
            this.setSize(n2 + 1);
            int n4 = n;
            while (n4 <= n2) {
                this.values[n4] = n3;
                ++n4;
            }
            this.values_len = Math.max(n2 + 1, this.values_len);
            System.arraycopy(nArray, 0, this.positions, 0, n);
            this.calcPositions(n - 1);
        }
    }
}

