/*
 * Decompiled with CFR 0.152.
 */
package jclass.field;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jclass.bwt.JCTextCursorEvent;
import jclass.bwt.JCTextEvent;
import jclass.bwt.JCTextInterface;
import jclass.field.JCValidInfo;
import jclass.field.JCValidateInterface;

public abstract class JCValidator
implements JCValidateInterface,
Serializable {
    private static final boolean TRACE = false;
    public static final int AS_IS = 0;
    public static final int UPPERCASE = 1;
    public static final int LOWERCASE = 2;
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int SPIN_FIELD = 0;
    public static final int SPIN_SUBFIELD = 1;
    public static final int SPIN_WRAP = 2;
    public static final int NOT_FOUND = -1;
    protected Object max;
    protected Object min;
    protected Locale locale;
    protected Object increment;
    protected boolean allow_null = false;
    protected int case_policy = 0;
    protected String invalid_chars = null;
    protected boolean match_picklist = true;
    protected String valid_chars = null;
    protected Object[] picklist = null;
    protected String[] display_list = null;
    protected int spin_policy = 0;
    protected ResourceBundle li;

    public JCValidator() {
        this.setLocale(Locale.getDefault());
    }

    protected abstract Object addIncrement(Object var1);

    public int calculateSpinability(Object object) {
        int n = 0;
        if (this.picklist != null && this.picklist.length > 0) {
            int n2 = this.getPickListIndex(object);
            if (this.spin_policy == 2) {
                n |= 2;
                n |= 1;
            } else {
                if (n2 > 0 || n2 == -1) {
                    n |= 2;
                }
                if (n2 < this.picklist.length - 1) {
                    n |= 1;
                }
            }
            return n;
        }
        if (this.increment != null) {
            Object object2 = this.subtractIncrement(object);
            if (this.spin_policy == 2) {
                n |= 2;
                n |= 1;
            } else {
                if (object2 != null && !object2.equals(object)) {
                    n |= 2;
                }
                if ((object2 = this.addIncrement(object)) != null && !object2.equals(object)) {
                    n |= 1;
                }
            }
            return n;
        }
        return 0;
    }

    public void changeText(JCTextEvent jCTextEvent) {
        String string = jCTextEvent.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append(this.convertCase(string.charAt(n)));
            ++n;
        }
        jCTextEvent.setText(stringBuffer.toString());
    }

    protected StringBuffer checkValidInvalid(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (this.isValidChar(c)) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer;
    }

    public boolean compareValues(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return object.equals(object2);
    }

    public char convertCase(char c) {
        switch (this.case_policy) {
            case 1: {
                c = Character.toUpperCase(c);
                break;
            }
            case 2: {
                c = Character.toLowerCase(c);
                break;
            }
        }
        return c;
    }

    public abstract Object convertFromSupported(Object var1, String var2);

    public abstract Object convertToSupported(Object var1);

    public abstract Object copyValue(Object var1);

    public abstract String format(Object var1);

    public abstract String formatForEdit(Object var1);

    protected JCValidInfo formatFromDisplayList(Object object) {
        int n;
        JCValidInfo jCValidInfo = new JCValidInfo();
        jCValidInfo.valid = false;
        jCValidInfo.value = null;
        if (this.display_list != null && this.display_list.length > 0 && (n = this.getPickListIndex(object)) != -1 && n < this.display_list.length) {
            jCValidInfo.value = this.display_list[n];
            jCValidInfo.valid = true;
        }
        return jCValidInfo;
    }

    public boolean getAllowNull() {
        return this.allow_null;
    }

    public int getCasePolicy() {
        return this.case_policy;
    }

    public String[] getDisplayList() {
        return this.display_list;
    }

    public abstract int getFirstValidCursorPosition();

    public String getInvalidChars() {
        return this.invalid_chars;
    }

    String getItem(int n) {
        return this.picklist[n].toString();
    }

    Object[] getList() {
        return this.picklist;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean getMatchPickList() {
        return this.match_picklist;
    }

    public Object getMax() {
        return this.max;
    }

    public Object getMin() {
        return this.min;
    }

    protected Object getNextValue(int n) {
        if (n + 1 >= 0 && n + 1 >= this.picklist.length) {
            return null;
        }
        return this.picklist[n + 1];
    }

    public Object[] getPickList() {
        return this.picklist;
    }

    public int getPickListIndex(Object object) {
        if (this.picklist == null || object == null) {
            return -1;
        }
        int n = 0;
        while (n < this.picklist.length) {
            if (object.equals(this.picklist[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected Object getPreviousValue(int n) {
        if (n - 1 < 0) {
            return null;
        }
        return this.picklist[n - 1];
    }

    public int getSpinPolicy() {
        return this.spin_policy;
    }

    public String[] getStringList() {
        if (this.picklist == null || this.picklist.length == 0) {
            return null;
        }
        if (this.display_list != null && this.display_list.length == this.picklist.length) {
            return this.display_list;
        }
        String[] stringArray = new String[this.picklist.length];
        int n = 0;
        if (this.display_list != null) {
            while (n < this.picklist.length && n < this.display_list.length) {
                stringArray[n] = this.display_list[n];
                ++n;
            }
        }
        while (n < this.picklist.length) {
            stringArray[n] = this.format(this.picklist[n]);
            ++n;
        }
        return stringArray;
    }

    public String getValidChars() {
        return this.valid_chars;
    }

    public abstract boolean hasEditFormat();

    abstract boolean inRange(Object var1);

    public void inferSubField(JCTextInterface jCTextInterface) {
    }

    public abstract boolean isSupported(Object var1);

    public boolean isValidChar(char c) {
        int n;
        if (this.invalid_chars != null) {
            n = 0;
            while (n < this.invalid_chars.length()) {
                if (c == this.invalid_chars.charAt(n)) {
                    return false;
                }
                ++n;
            }
        }
        if (this.valid_chars == null || this.valid_chars.length() == 0) {
            return true;
        }
        n = 0;
        while (n < this.valid_chars.length()) {
            if (c == this.valid_chars.charAt(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected JCValidInfo parseFromDisplayList(String string) {
        JCValidInfo jCValidInfo = new JCValidInfo();
        jCValidInfo.valid = false;
        jCValidInfo.value = null;
        if (this.display_list != null && this.display_list.length > 0) {
            int n = 0;
            while (n < this.display_list.length) {
                if (string.equalsIgnoreCase(this.display_list[n])) break;
                ++n;
            }
            if (n == this.display_list.length) {
                n = -1;
            }
            if (n != -1 && n < this.picklist.length) {
                jCValidInfo.value = this.picklist[n];
                jCValidInfo.valid = true;
            } else {
                jCValidInfo.value = new Integer(n);
            }
        }
        return jCValidInfo;
    }

    public void setAllowNull(boolean bl) {
        this.allow_null = bl;
    }

    public void setCasePolicy(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("invalid value for casePolicy");
        }
        this.case_policy = n;
    }

    public abstract void setCursor(JCTextCursorEvent var1);

    public void setDisplayList(String[] stringArray) {
        this.display_list = stringArray;
    }

    public void setInvalidChars(String string) {
        this.invalid_chars = string;
    }

    void setList(Object[] objectArray) {
        this.picklist = objectArray;
    }

    public void setLocale(Locale locale) {
        if (this.locale == locale) {
            return;
        }
        try {
            this.li = ResourceBundle.getBundle("jclass.field.resources.LocaleInfo", locale);
        }
        catch (MissingResourceException missingResourceException) {
            locale = new Locale(locale.getLanguage(), locale.getCountry());
            try {
                this.li = ResourceBundle.getBundle("jclass.field.resources.LocaleInfo", locale);
            }
            catch (MissingResourceException missingResourceException2) {
                locale = new Locale(locale.getLanguage(), "");
                try {
                    this.li = ResourceBundle.getBundle("jclass.field.resources.LocaleInfo", locale);
                }
                catch (MissingResourceException missingResourceException3) {
                    locale = null;
                    try {
                        this.li = ResourceBundle.getBundle("jclass.field.resources.LocaleInfo", locale);
                    }
                    catch (MissingResourceException missingResourceException4) {
                        throw missingResourceException;
                    }
                }
            }
        }
        this.locale = locale;
    }

    public void setMatchPickList(boolean bl) {
        this.match_picklist = bl;
    }

    public void setMax(Object object) {
        this.max = object;
    }

    public void setMin(Object object) {
        this.min = object;
    }

    public void setPickList(Object[] objectArray) {
        this.picklist = objectArray;
    }

    protected void setRange(Object object, Object object2) {
        this.min = object;
        this.max = object2;
    }

    public void setSpinPolicy(int n) {
        if (n != 1 && n != 0 && n != 2) {
            throw new IllegalArgumentException("invalid value for spinPolicy");
        }
        this.spin_policy = n;
    }

    public void setValidChars(String string) {
        this.valid_chars = string;
    }

    public Object spinDown(Object object) {
        if (this.picklist != null && this.picklist.length > 0) {
            int n = this.getPickListIndex(object);
            if (n > 0) {
                return this.picklist[n - 1];
            }
            if (n == -1) {
                return this.picklist[this.picklist.length - 1];
            }
            if (this.spin_policy == 2) {
                return this.picklist[this.picklist.length - 1];
            }
            return null;
        }
        if (this.increment != null) {
            Object object2 = this.subtractIncrement(object);
            if (object2 != null) {
                return object2;
            }
            if (this.spin_policy == 2) {
                return this.max;
            }
        }
        return null;
    }

    public Object spinUp(Object object) {
        if (this.picklist != null && this.picklist.length > 0) {
            int n = this.getPickListIndex(object);
            if (n + 1 < this.picklist.length) {
                return this.picklist[n + 1];
            }
            if (this.spin_policy == 2) {
                return this.picklist[0];
            }
            return null;
        }
        if (this.increment != null) {
            Object object2 = this.addIncrement(object);
            if (object2 != null) {
                return object2;
            }
            if (this.spin_policy == 2) {
                return this.min;
            }
        }
        return null;
    }

    protected abstract Object subtractIncrement(Object var1);

    public JCValidInfo validate(Object object) {
        JCValidInfo jCValidInfo = new JCValidInfo();
        jCValidInfo.value = object;
        jCValidInfo.valid = true;
        jCValidInfo.list_index = this.getPickListIndex(object);
        if (this.picklist != null && this.picklist.length > 0 && this.match_picklist) {
            jCValidInfo.valid = jCValidInfo.list_index != -1;
        }
        if (!this.allow_null && object == null) {
            jCValidInfo.valid = false;
        }
        return jCValidInfo;
    }

    public abstract JCValidInfo validateText(String var1);
}

