/*
 * Decompiled with CFR 0.152.
 */
package jclass.field;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import jclass.bwt.JCTextEvent;
import jclass.bwt.JCTextInterface;
import jclass.field.JCNumberValidator;
import jclass.field.JCValidInfo;

public class JCIntValidator
extends JCNumberValidator {
    private static final boolean TRACE = false;
    private static final String minstring = Integer.toString(Integer.MIN_VALUE);
    private static final String maxstring = Integer.toString(Integer.MAX_VALUE);

    public JCIntValidator() {
        super.setMax(new Integer(Integer.MAX_VALUE));
        super.setMin(new Integer(Integer.MIN_VALUE));
        this.setIncrement(1);
    }

    public JCIntValidator(Number number, Number number2, Number[] numberArray, boolean bl, String[] stringArray, Integer n, String string, boolean bl2) {
        this.setMax(number2);
        this.setMin(number);
        this.setPickList(numberArray);
        this.setMatchPickList(bl);
        this.setDisplayList(stringArray);
        this.setIncrement(n);
        if (string != null) {
            this.setDisplayPattern(string);
        }
        this.setAllowNull(bl2);
    }

    protected Object addIncrement(Object object) {
        if (object == null || this.increment == null) {
            return null;
        }
        int n = ((Number)object).intValue() + ((Number)this.increment).intValue();
        if (n > ((Number)this.getMax()).intValue()) {
            return null;
        }
        return new Integer(n);
    }

    public void changeText(JCTextEvent jCTextEvent) {
        char c;
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = new StringBuffer(50);
        super.changeText(jCTextEvent);
        String string = ((JCTextInterface)jCTextEvent.getSource()).getText();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (jCTextEvent.getStartPosition() == 0) {
            bl3 = true;
        } else if (string != null && string.length() > 1) {
            c = string.charAt(string.length() - 1);
            if (c == this.symbols.getMinusSign()) {
                bl4 = true;
            } else if (c == '+') {
                bl4 = true;
            } else if (c == ')') {
                bl4 = true;
            }
        }
        if (string.indexOf(this.symbols.getMinusSign()) != -1 && jCTextEvent.getStartPosition() > 0) {
            bl = true;
        } else if (string.indexOf(43) != -1) {
            bl = true;
        } else if (string.indexOf(40) != -1) {
            bl = true;
            bl2 = true;
        }
        String string2 = jCTextEvent.getText();
        if (string2 != null && string2.length() != 0) {
            stringBuffer = this.checkValidInvalid(string2);
            if (stringBuffer != null && stringBuffer.length() != 0) {
                int n = 0;
                while (n < stringBuffer.length()) {
                    c = stringBuffer.charAt(n);
                    if (!bl4) {
                        if (this.display_list != null) {
                            stringBuffer2.append(c);
                        } else if (Character.isDigit(c)) {
                            stringBuffer2.append(c);
                        } else if (!bl && c == this.symbols.getMinusSign()) {
                            stringBuffer2.append(c);
                        } else if ((c == '(' || c == ')') && this.edit_pattern.indexOf(40) != -1) {
                            if (c == '(' && bl3) {
                                stringBuffer2.append(c);
                            } else if (c == ')' && bl2) {
                                stringBuffer2.append(c);
                            }
                        }
                    }
                    ++n;
                }
            }
            jCTextEvent.setText(stringBuffer2.toString());
            if (stringBuffer2.length() == 0) {
                jCTextEvent.setAllowChange(false);
            }
        }
    }

    public Object convertFromSupported(Object object, String string) {
        Integer n = (Integer)object;
        if (string.equals("java.lang.Byte")) {
            return new Byte(n.byteValue());
        }
        if (string.equals("java.lang.Short")) {
            return new Short(n.shortValue());
        }
        if (string.equals("java.lang.Long")) {
            return new Long(n.longValue());
        }
        return null;
    }

    public Object convertToSupported(Object object) {
        if (object instanceof Number) {
            return new Integer(((Number)object).intValue());
        }
        return null;
    }

    protected DecimalFormat createDisplayFormat(Locale locale) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.getDefault());
        decimalFormat.setParseIntegerOnly(true);
        return decimalFormat;
    }

    protected DecimalFormat createEditFormat(Locale locale) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.getDefault());
        decimalFormat.setParseIntegerOnly(true);
        return decimalFormat;
    }

    public String format(Object object) {
        int n;
        if (object == null) {
            return "";
        }
        if (!this.isSupported(object)) {
            object = this.convertToSupported(object);
        }
        JCValidInfo jCValidInfo = this.formatFromDisplayList(object);
        if (jCValidInfo.valid) {
            return (String)jCValidInfo.value;
        }
        if (this.display_list != null && this.display_list.length > 0 && (n = ((Number)object).intValue()) >= 0 && n < this.display_list.length) {
            return this.display_list[n];
        }
        return this.displayFormat.format(object);
    }

    public String formatForEdit(Object object) {
        int n;
        if (object == null) {
            return "";
        }
        JCValidInfo jCValidInfo = this.formatFromDisplayList(object);
        if (jCValidInfo.valid) {
            return (String)jCValidInfo.value;
        }
        if (this.display_list != null && this.display_list.length > 0 && (n = ((Number)object).intValue()) >= 0 && n < this.display_list.length) {
            return this.display_list[n];
        }
        return this.editFormat.format(object);
    }

    public Integer getIncrement() {
        return (Integer)this.increment;
    }

    public boolean hasEditFormat() {
        return true;
    }

    public boolean inRange(int n) {
        return n >= ((Number)this.getMin()).intValue() && n <= ((Number)this.getMax()).intValue();
    }

    public boolean inRange(Number number) {
        return this.inRange(number.intValue());
    }

    public boolean inRange(Object object) {
        if (object instanceof Number) {
            return this.inRange(((Number)object).intValue());
        }
        return false;
    }

    public boolean isSupported(Object object) {
        return object instanceof Integer;
    }

    public void setIncrement(int n) {
        this.setIncrement(new Integer(n));
    }

    public void setIncrement(Integer n) {
        if (n <= 0) {
            throw new IllegalArgumentException("increment <= 0");
        }
        this.increment = n;
    }

    public void setMax(int n) {
        this.setMax(new Integer(n));
    }

    public void setMin(int n) {
        this.setMin(new Integer(n));
    }

    protected void setPatterns() {
        this.display_pattern = this.li.getString("DecimalPattern");
        this.edit_pattern = "0";
    }

    protected Object subtractIncrement(Object object) {
        if (object == null || this.increment == null) {
            return null;
        }
        int n = ((Number)object).intValue() - ((Number)this.increment).intValue();
        if (n < ((Number)this.getMin()).intValue()) {
            return null;
        }
        return new Integer(n);
    }

    public JCValidInfo validate(Object object) {
        JCValidInfo jCValidInfo = super.validate(object);
        if (!jCValidInfo.valid) {
            return jCValidInfo;
        }
        if (jCValidInfo.value != null && !this.inRange(object)) {
            jCValidInfo.valid = false;
            return jCValidInfo;
        }
        return jCValidInfo;
    }

    public JCValidInfo validateText(String string) {
        Serializable serializable;
        Object object;
        JCValidInfo jCValidInfo = this.parseFromDisplayList(string);
        if (jCValidInfo.valid) {
            return jCValidInfo;
        }
        if (jCValidInfo.value instanceof Integer && (Integer)jCValidInfo.value != -1) {
            jCValidInfo.valid = true;
            return jCValidInfo;
        }
        jCValidInfo.value = null;
        jCValidInfo.valid = false;
        if ((string == null || string.length() == 0) && this.getAllowNull()) {
            jCValidInfo.valid = true;
            return jCValidInfo;
        }
        if (string.length() >= Math.min(minstring.length(), maxstring.length())) {
            int n;
            object = string.indexOf(this.symbols.getMinusSign()) != -1 || string.indexOf(40) != -1 ? minstring : maxstring;
            serializable = new StringBuffer(string.length());
            int n2 = 0;
            while (n2 < string.length()) {
                n = string.charAt(n2);
                if (Character.isDigit((char)n)) {
                    ((StringBuffer)serializable).append((char)n);
                }
                ++n2;
            }
            if (((StringBuffer)serializable).length() > ((String)object).length()) {
                return jCValidInfo;
            }
            if (((StringBuffer)serializable).length() == ((String)object).length()) {
                n = 0;
                while (n < ((StringBuffer)serializable).length()) {
                    if (Integer.parseInt(String.valueOf(((StringBuffer)serializable).charAt(n))) > Integer.parseInt(String.valueOf(((String)object).charAt(n)))) {
                        return jCValidInfo;
                    }
                    ++n;
                }
            }
        }
        if ((serializable = this.editFormat.parse(string, (ParsePosition)(object = new ParsePosition(0)))) != null && (((Number)serializable).longValue() < ((Number)this.min).longValue() || ((Number)serializable).longValue() > ((Number)this.max).longValue())) {
            jCValidInfo.valid = false;
        } else if (((ParsePosition)object).getIndex() == 0) {
            jCValidInfo.valid = this.getAllowNull();
        } else {
            jCValidInfo.valid = true;
            jCValidInfo.value = new Integer(((Number)serializable).intValue());
        }
        if (!jCValidInfo.valid) {
            return jCValidInfo;
        }
        return this.validate(jCValidInfo.value);
    }
}

