/*
 * Decompiled with CFR 0.152.
 */
package jclass.field;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import jclass.bwt.JCTextInterface;
import jclass.field.DateFormat;
import jclass.field.DateMask;
import jclass.field.JCStringValidator;
import jclass.field.JCValidInfo;
import jclass.field.ReturnableInt;
import jclass.util.JCVector;

public class JCCalendarValidator
extends JCStringValidator {
    static final int NOVALUE = -1;
    static final int NOTFOUND = -1;
    static final int PARSE_ERROR = -1;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    static final int DATE_LITERAL = 1;
    static final int MERIDIEM = 2;
    static final int ABBREV_TIMEZONE = 3;
    static final int TIMEZONE = 4;
    static final int MERIDIEM_HOUR = 5;
    static final int ZERO_MERIDIEM_HOUR = 6;
    static final int MILITARY_HOUR = 7;
    static final int ZERO_MILITARY_HOUR = 8;
    static final int MINUTE = 9;
    static final int ZERO_MINUTE = 10;
    static final int SECOND = 11;
    static final int ZERO_SECOND = 12;
    static final int NUM_DAY = 13;
    static final int ZERO_NUM_DAY = 14;
    static final int ABBREV_ALPHA_DAY = 15;
    static final int ALPHA_DAY = 16;
    static final int DAY_OF_YEAR = 17;
    static final int ZERO_DAY_OF_YEAR = 18;
    static final int NUM_MONTH = 19;
    static final int ZERO_NUM_MONTH = 20;
    static final int ABBREV_ALPHA_MONTH = 21;
    static final int ALPHA_MONTH = 22;
    static final int SHORT_YEAR = 23;
    static final int LONG_YEAR = 24;
    static final int MILLISECOND = 25;
    static final int AMSET = -2;
    static final int PMSET = -3;
    static final int ZONE_ID = 0;
    static final int ZONE_STANDARD_LONG = 1;
    static final int ZONE_STANDARD_SHORT = 2;
    static final int ZONE_DAYLIGHT_LONG = 3;
    static final int ZONE_DAYLIGHT_SHORT = 4;
    static final int ZONE_CITY_NAME = 5;
    static final byte[][] daytable = new byte[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
    protected boolean mask_input = false;
    protected String date_format;
    protected DateFormat compiled_format;
    protected TimeZone tz = null;
    protected WorkingCalendar cal = null;
    protected DateFormatSymbols symbols;
    protected JCVector edit_formats = new JCVector(0);
    protected JCVector compiled_edit_formats = new JCVector(0);
    protected int increment_field = 10;
    protected int millenium_threshold = 70;
    protected int default_detail = 2;
    protected int spin_policy = 1;
    protected String original_format = null;
    private static final boolean TRACE = false;
    private static int YEARMOD = 1997;
    private static int DAYMOD = 2;

    public JCCalendarValidator() {
        if (this.tz == null) {
            this.tz = TimeZone.getDefault();
        }
        if (this.cal == null) {
            this.cal = new WorkingCalendar(Calendar.getInstance(this.tz, this.locale));
        }
        this.symbols = new DateFormatSymbols(this.locale);
        this.increment = new Integer(1);
        this.setFormat(this.getDefaultFormat());
        this.setEditFormats(this.getDefaultEditFormats());
    }

    public JCCalendarValidator(String string, String string2, String[] stringArray, boolean bl, int n, boolean bl2) {
        this();
        if (string != null && string.length() != 0) {
            try {
                this.setFormat(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setFormat(this.getDefaultFormat());
            }
        }
        this.setPlaceHolderChars(string2);
        this.setEditFormats(stringArray);
        this.setMaskInput(bl);
        this.setDefaultDetail(n);
        this.setAllowNull(bl2);
    }

    public void addEditFormat(String string) {
        this.edit_formats.addElement(string);
        this.compiled_edit_formats.addElement(this.compileFormat(string));
    }

    protected Object addIncrement(Object object) {
        if (object == null || this.increment == null) {
            return null;
        }
        int n = (Integer)this.increment;
        if (n == 0) {
            return null;
        }
        Calendar calendar = (Calendar)object;
        calendar = (Calendar)calendar.clone();
        if (this.spin_policy == 1) {
            this.spinSubField(calendar, n);
        } else {
            calendar.add(this.increment_field, n);
        }
        return calendar;
    }

    private DateFormat compileFormat(String string) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        boolean bl = false;
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < string.length()) {
            objectArray = new DateMask();
            block0 : switch (string.charAt(n2)) {
                case 'd': {
                    int n3 = 1;
                    while (n2 + n3 != n && n3 < 2 && string.charAt(n2 + n3) == 'd') {
                        ++n3;
                    }
                    objectArray.chars = string.substring(n2, n2 + n3);
                    n2 += n3;
                    objectArray.field = 5;
                    switch (n3) {
                        case 1: {
                            objectArray.symbol = 13;
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 14;
                            objectArray.absolute_replacement.field = 5;
                            objectArray.absolute_replacement.chars = "dd";
                            break block0;
                        }
                        case 2: {
                            objectArray.symbol = 14;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing day of month in \"" + string + "\"");
                }
                case 'E': {
                    int n3 = 1;
                    while (n2 + n3 != n && n3 < 4 && string.charAt(n2 + n3) == 'E') {
                        ++n3;
                    }
                    objectArray.chars = string.substring(n2, n2 + n3);
                    n2 += n3;
                    objectArray.field = 7;
                    switch (n3) {
                        case 1: 
                        case 2: {
                            objectArray.symbol = 15;
                            objectArray.strings = this.symbols.getShortWeekdays();
                            break block0;
                        }
                        case 3: 
                        case 4: {
                            objectArray.symbol = 16;
                            objectArray.strings = this.symbols.getWeekdays();
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 15;
                            objectArray.absolute_replacement.field = 7;
                            objectArray.absolute_replacement.strings = this.symbols.getShortWeekdays();
                            objectArray.absolute_replacement.chars = "EE";
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing week in \"" + string + "\"");
                }
                case 'M': {
                    int n3 = 1;
                    while (n2 + n3 != n && n3 < 4 && string.charAt(n2 + n3) == 'M') {
                        ++n3;
                    }
                    objectArray.chars = string.substring(n2, n2 + n3);
                    n2 += n3;
                    objectArray.field = 2;
                    switch (n3) {
                        case 1: {
                            objectArray.symbol = 19;
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 20;
                            objectArray.absolute_replacement.field = 2;
                            objectArray.absolute_replacement.chars = "MM";
                            break block0;
                        }
                        case 2: {
                            objectArray.symbol = 20;
                            break block0;
                        }
                        case 3: {
                            objectArray.symbol = 21;
                            objectArray.strings = this.symbols.getShortMonths();
                            break block0;
                        }
                        case 4: {
                            objectArray.symbol = 22;
                            objectArray.strings = this.symbols.getMonths();
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 21;
                            objectArray.absolute_replacement.field = 2;
                            objectArray.absolute_replacement.strings = this.symbols.getShortMonths();
                            objectArray.absolute_replacement.chars = "MMM";
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing month in \"" + string + "\"");
                }
                case 'Y': 
                case 'y': {
                    int n3 = 1;
                    while (n2 + n3 != n && n3 < 4 && n2 + n3 < string.length() && (string.charAt(n2 + n3) == 'Y' || string.charAt(n2 + n3) == 'y')) {
                        ++n3;
                    }
                    objectArray.field = 1;
                    objectArray.chars = string.substring(n2, n2 + n3);
                    n2 += n3;
                    switch (n3) {
                        case 1: {
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 23;
                            objectArray.absolute_replacement.field = 1;
                            objectArray.absolute_replacement.chars = "YY";
                        }
                        case 2: {
                            objectArray.symbol = 23;
                            break block0;
                        }
                        case 3: {
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 24;
                            objectArray.absolute_replacement.field = 1;
                            objectArray.absolute_replacement.chars = "YYYY";
                        }
                        case 4: {
                            objectArray.symbol = 24;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing year in \"" + string + "\"");
                }
                case 'h': {
                    int n3 = 1;
                    while (n2 + n3 != n && n3 < 2 && string.charAt(n2 + n3) == 'h') {
                        ++n3;
                    }
                    objectArray.field = 10;
                    objectArray.strings = this.symbols.getAmPmStrings();
                    objectArray.chars = string.substring(n2, n2 + n3);
                    n2 += n3;
                    switch (n3) {
                        case 1: {
                            objectArray.symbol = 5;
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 6;
                            objectArray.absolute_replacement.field = 10;
                            objectArray.absolute_replacement.chars = "hh";
                            break block0;
                        }
                        case 2: {
                            objectArray.symbol = 6;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing hour in \"" + string + "\"");
                }
                case 'H': {
                    int n3 = 1;
                    while (n2 + n3 != n && n3 < 2 && string.charAt(n2 + n3) == 'H') {
                        ++n3;
                    }
                    objectArray.field = 11;
                    objectArray.chars = string.substring(n2, n2 + n3);
                    n2 += n3;
                    switch (n3) {
                        case 1: {
                            objectArray.symbol = 7;
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 8;
                            objectArray.absolute_replacement.field = 11;
                            objectArray.absolute_replacement.chars = "HH";
                            break block0;
                        }
                        case 2: {
                            objectArray.symbol = 8;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing hour in \"" + string + "\"");
                }
                case 'm': {
                    int n3 = 1;
                    while (n2 + n3 != n && n3 < 2 && string.charAt(n2 + n3) == 'm') {
                        ++n3;
                    }
                    objectArray.field = 12;
                    objectArray.chars = string.substring(n2, n2 + n3);
                    n2 += n3;
                    switch (n3) {
                        case 1: {
                            objectArray.symbol = 9;
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 10;
                            objectArray.absolute_replacement.field = 12;
                            objectArray.absolute_replacement.chars = "mm";
                            break block0;
                        }
                        case 2: {
                            objectArray.symbol = 10;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing minute in \"" + string + "\"");
                }
                case 's': {
                    int n3 = 1;
                    while (n2 + n3 != n && n3 < 2 && n2 + n3 < string.length() && string.charAt(n2 + n3) == 's') {
                        ++n3;
                    }
                    objectArray.field = 13;
                    objectArray.chars = string.substring(n2, n2 + n3);
                    n2 += n3;
                    switch (n3) {
                        case 1: {
                            objectArray.symbol = 11;
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 12;
                            objectArray.absolute_replacement.field = 13;
                            objectArray.absolute_replacement.chars = "ss";
                            break block0;
                        }
                        case 2: {
                            objectArray.symbol = 12;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing second in \"" + string + "\"");
                }
                case 'a': 
                case 'p': {
                    objectArray.symbol = 2;
                    objectArray.field = 9;
                    objectArray.strings = this.symbols.getAmPmStrings();
                    objectArray.chars = String.valueOf(string.charAt(n2));
                    ++n2;
                    break;
                }
                case 'z': {
                    int n3 = 1;
                    while (n2 + n3 != n && n3 < 4 && n2 + n3 < string.length() && string.charAt(n2 + n3) == 'z') {
                        ++n3;
                    }
                    objectArray.symbol = 4;
                    objectArray.field = -1;
                    objectArray.chars = string.substring(n2, n2 + n3);
                    n2 += n3;
                    switch (n3) {
                        case 1: 
                        case 2: {
                            objectArray.symbol = 3;
                            objectArray.strings = this.getShortZoneStrings();
                            break block0;
                        }
                        case 4: {
                            objectArray.symbol = 4;
                            objectArray.strings = this.getLongZoneStrings();
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 3;
                            objectArray.absolute_replacement.field = -1;
                            objectArray.absolute_replacement.strings = this.getShortZoneStrings();
                            objectArray.absolute_replacement.chars = "zz";
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing timezone in \"" + string + "\"");
                }
                case 'D': {
                    int n3 = 1;
                    while (n2 + n3 != n && n3 < 3 && string.charAt(n2 + n3) == 'D') {
                        ++n3;
                    }
                    objectArray.field = 6;
                    objectArray.chars = string.substring(n2, n2 + n3);
                    n2 += n3;
                    switch (n3) {
                        case 1: {
                            objectArray.symbol = 17;
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 18;
                            objectArray.absolute_replacement.field = 6;
                            objectArray.absolute_replacement.chars = "DDD";
                            break block0;
                        }
                        case 3: {
                            objectArray.symbol = 18;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing day of year in \"" + string + "\"");
                }
                case '\\': {
                    int n3 = 1;
                    if (string.charAt(++n2) == '\u0000') break;
                    objectArray.symbol = 1;
                    objectArray.chars = String.valueOf(string.charAt(n2));
                    ++n2;
                    break;
                }
                default: {
                    objectArray.symbol = 1;
                    objectArray.chars = String.valueOf(string.charAt(n2));
                    ++n2;
                }
            }
            vector.addElement(objectArray);
        }
        objectArray = new DateMask[vector.size()];
        vector.copyInto(objectArray);
        DateFormat dateFormat = new DateFormat();
        dateFormat.elements = objectArray;
        dateFormat.size_ambiguous = bl;
        return dateFormat;
    }

    private String convertDateFormatToStringMask() {
        StringBuffer stringBuffer = new StringBuffer(this.date_format.length());
        boolean bl = false;
        if (this.compiled_format.size_ambiguous) {
            StringBuffer stringBuffer2 = new StringBuffer(this.date_format.length() + 10);
            int n = 0;
            while (n < this.compiled_format.elements.length) {
                if (this.compiled_format.elements[n].absolute_replacement == null) {
                    stringBuffer2.append(this.compiled_format.getChars(n));
                } else {
                    this.compiled_format.elements[n] = this.compiled_format.elements[n].absolute_replacement;
                    stringBuffer2.append(this.compiled_format.getChars(n));
                }
                ++n;
            }
            this.date_format = stringBuffer2.toString();
        }
        int n = 0;
        while (n < this.compiled_format.elements.length) {
            if (this.compiled_format.getSymbol(n) != 1) {
                int n2;
                String[] stringArray = this.compiled_format.getStrings(n);
                if (stringArray == null || this.compiled_format.getSymbol(n) == 5 || this.compiled_format.getSymbol(n) == 6) {
                    n2 = 0;
                    while (n2 < this.compiled_format.getChars(n).length()) {
                        stringBuffer.append("@");
                        ++n2;
                    }
                    this.compiled_format.setLength(n, this.compiled_format.getChars(n).length());
                } else {
                    int n3;
                    n2 = stringArray[0].length();
                    if (n2 == 0) {
                        n3 = 1;
                        while (n3 < stringArray.length) {
                            n2 = Math.max(n2, stringArray[n3].length());
                            ++n3;
                        }
                    }
                    n3 = 0;
                    while (n3 < n2) {
                        stringBuffer.append("A");
                        ++n3;
                    }
                    this.compiled_format.setLength(n, stringArray[0].length());
                }
            } else {
                stringBuffer.append(this.compiled_format.getChars(n));
                this.compiled_format.setLength(n, this.compiled_format.getChars(n).length());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public Object convertFromSupported(Object object, String string) {
        long l = ((Calendar)object).getTime().getTime();
        if (string.equals("java.util.Date")) {
            return new java.util.Date(l);
        }
        if (string.equals("java.sql.Time")) {
            return new Time(l);
        }
        if (string.equals("java.sql.Timestamp")) {
            return new Timestamp(l);
        }
        if (string.equals("java.sql.Date")) {
            return new Date(l);
        }
        return null;
    }

    public Object convertToSupported(Object object) {
        if (object instanceof java.util.Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((java.util.Date)object);
            return calendar;
        }
        return null;
    }

    public Object copyValue(Object object) {
        if (object == null) {
            return null;
        }
        Calendar calendar = (Calendar)object;
        return calendar.clone();
    }

    private void copy_fields(WorkingCalendar workingCalendar, WorkingCalendar workingCalendar2) {
        int n = 0;
        while (n < 17) {
            workingCalendar.set(n, workingCalendar2.get(n));
            ++n;
        }
    }

    public static int dayOfMonthOfYear(int n, int n2) {
        int n3 = JCCalendarValidator.isLeap(n) ? 1 : 0;
        int n4 = 0;
        while (n2 > daytable[n3][n4]) {
            n2 -= daytable[n3][n4];
            ++n4;
        }
        return n2;
    }

    public static int dayOfWeek(int n, int n2, int n3) {
        long l = 0L;
        if (n > YEARMOD) {
            l = JCCalendarValidator.dayOfYear(n, n2, n3);
            int n4 = YEARMOD;
            while (n4 < n) {
                l += (long)JCCalendarValidator.daysInYear(n4);
                ++n4;
            }
        } else if (n == YEARMOD) {
            l = JCCalendarValidator.dayOfYear(n, n2, n3);
        } else {
            if (n < 0) {
                return -1;
            }
            l = JCCalendarValidator.daysInYear(n) - JCCalendarValidator.dayOfYear(n, n2, n3);
            int n5 = n + 1;
            while (n5 < YEARMOD) {
                l += (long)JCCalendarValidator.daysInYear(n5);
                ++n5;
            }
            int n6 = DAYMOD - (int)(l % 7L);
            if (n6 < 0) {
                n6 += 7;
            }
            return n6 + 1;
        }
        return (int)((l + (long)DAYMOD) % 7L) + 1;
    }

    public static int dayOfYear(int n, int n2, int n3) {
        int n4 = JCCalendarValidator.isLeap(n) ? 1 : 0;
        int n5 = 0;
        while (n5 < n2) {
            n3 += daytable[n4][n5];
            ++n5;
        }
        return n3;
    }

    public static int daysInMonth(int n, int n2) {
        int n3 = JCCalendarValidator.isLeap(n2) ? 1 : 0;
        return daytable[n3][n];
    }

    public static int daysInYear(int n) {
        if (JCCalendarValidator.isLeap(n)) {
            return 366;
        }
        return 365;
    }

    private static boolean domain_check(int n, int n2) {
        switch (n2) {
            case 5: 
            case 6: {
                return n >= 0 && n <= 12;
            }
            case 7: 
            case 8: {
                return n >= 0 && n <= 23;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return n >= 0 && n <= 59;
            }
            case 13: 
            case 14: {
                return n >= 1 && n <= 31;
            }
            case 19: 
            case 20: {
                return n >= 1 && n <= 12;
            }
            case 23: 
            case 24: {
                return n >= 0 && n <= 9999;
            }
            case 17: 
            case 18: {
                return n >= 0 && n <= 365;
            }
            case 25: {
                return n >= 0 && n <= 999;
            }
        }
        return false;
    }

    public String format(Object object) {
        int n;
        if (object == null) {
            return super.format(object);
        }
        if (!this.isSupported(object)) {
            object = this.convertToSupported(object);
        }
        Calendar calendar = (Calendar)object;
        StringBuffer stringBuffer = new StringBuffer(30);
        int n2 = 0;
        while (n2 < this.compiled_format.elements.length) {
            switch (this.compiled_format.getSymbol(n2)) {
                case 5: {
                    int n3 = calendar.get(this.compiled_format.getField(n2));
                    if (n3 == 0) {
                        n3 = 12;
                    }
                    stringBuffer.append(Integer.toString(n3));
                    break;
                }
                case 7: 
                case 9: 
                case 11: 
                case 13: {
                    int n3 = calendar.get(this.compiled_format.getField(n2));
                    stringBuffer.append(Integer.toString(n3));
                    break;
                }
                case 19: {
                    int n3 = calendar.get(this.compiled_format.getField(n2)) + 1;
                    stringBuffer.append(Integer.toString(n3));
                    break;
                }
                case 17: {
                    int n3 = calendar.get(this.compiled_format.getField(n2)) + 1;
                    stringBuffer.append(Integer.toString(n3));
                    break;
                }
                case 24: {
                    int n3 = calendar.get(this.compiled_format.getField(n2));
                    stringBuffer.append(Integer.toString(n3));
                    break;
                }
                case 6: {
                    int n3 = calendar.get(this.compiled_format.getField(n2));
                    if (n3 == 0) {
                        n3 = 12;
                    }
                    stringBuffer.append(this.formatDigits(n3, 2));
                    break;
                }
                case 8: 
                case 10: 
                case 12: 
                case 14: {
                    int n3 = calendar.get(this.compiled_format.getField(n2));
                    stringBuffer.append(this.formatDigits(n3, 2));
                    break;
                }
                case 20: {
                    int n3 = calendar.get(this.compiled_format.getField(n2)) + 1;
                    stringBuffer.append(this.formatDigits(n3, 2));
                    break;
                }
                case 23: {
                    int n3 = calendar.get(this.compiled_format.getField(n2));
                    stringBuffer.append(this.formatDigits(n3 %= 100, 2));
                    break;
                }
                case 18: {
                    int n3 = calendar.get(this.compiled_format.getField(n2)) + 1;
                    stringBuffer.append(this.formatDigits(n3, 3));
                    break;
                }
                case 2: 
                case 15: 
                case 16: 
                case 21: 
                case 22: {
                    int n3 = calendar.get(this.compiled_format.getField(n2));
                    stringBuffer.append(this.compiled_format.getString(n2, n3));
                    break;
                }
                case 3: 
                case 4: {
                    n = this.getZoneIndex();
                    stringBuffer.append(this.compiled_format.getString(n2, n));
                    break;
                }
                case 1: {
                    stringBuffer.append(this.compiled_format.getChars(n2));
                    break;
                }
            }
            ++n2;
        }
        if (this.case_policy != 0) {
            n = 0;
            while (n < stringBuffer.length()) {
                stringBuffer.setCharAt(n, this.convertCase(stringBuffer.charAt(n)));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private String formatDigits(int n, int n2) {
        String string = Integer.toString(n);
        if (string.length() >= n2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2 - string.length()) {
            stringBuffer.append("0");
            ++n3;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public int getDefaultDetail() {
        return this.default_detail;
    }

    public String[] getDefaultEditFormats() {
        return this.getDefaultEditFormats(this.locale);
    }

    public String[] getDefaultEditFormats(Locale locale) {
        JCVector jCVector = new JCVector(0);
        ResourceBundle resourceBundle = this.locale == locale ? this.li : ResourceBundle.getBundle("jclass.field.resources.LocaleInfo", locale);
        String string = resourceBundle.getString("FullTime");
        String string2 = resourceBundle.getString("LongTime");
        String string3 = resourceBundle.getString("MediumTime");
        String string4 = resourceBundle.getString("ShortTime");
        String string5 = resourceBundle.getString("FullDate");
        String string6 = resourceBundle.getString("LongDate");
        String string7 = resourceBundle.getString("MediumDate");
        String string8 = resourceBundle.getString("ShortDate");
        MessageFormat messageFormat = new MessageFormat(resourceBundle.getString("DateTime"));
        String[] stringArray = new String[]{string5, string6, string7, string8};
        String[] stringArray2 = new String[]{string, string2, string3, string4};
        String[] stringArray3 = new String[2];
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < 4) {
                stringArray3[0] = stringArray[n];
                stringArray3[1] = stringArray2[n2];
                jCVector.addElement(messageFormat.format(stringArray3));
                ++n2;
            }
            ++n;
        }
        return JCCalendarValidator.getStringArrayCopy(jCVector);
    }

    public String getDefaultFormat() {
        return this.getDefaultFormat(this.locale);
    }

    public String getDefaultFormat(Locale locale) {
        MessageFormat messageFormat = new MessageFormat(this.li.getString("DateTime"));
        String[] stringArray = new String[2];
        switch (this.default_detail) {
            case 0: {
                stringArray[0] = this.li.getString("FullDate");
                stringArray[1] = this.li.getString("FullTime");
                break;
            }
            case 1: {
                stringArray[0] = this.li.getString("LongDate");
                stringArray[1] = this.li.getString("LongTime");
                break;
            }
            case 2: {
                stringArray[0] = this.li.getString("MediumDate");
                stringArray[1] = this.li.getString("MediumTime");
                break;
            }
            case 3: {
                stringArray[0] = this.li.getString("ShortDate");
                stringArray[1] = this.li.getString("ShortTime");
                break;
            }
        }
        return messageFormat.format(stringArray);
    }

    public String[] getEditFormats() {
        return JCCalendarValidator.getStringArrayCopy(this.edit_formats);
    }

    public String getFormat() {
        return this.original_format;
    }

    public int getIncrement() {
        if (this.increment == null) {
            return 0;
        }
        return (Integer)this.increment;
    }

    public int getIncrementField() {
        return this.increment_field;
    }

    private int getIncrementField(int n, ReturnableInt returnableInt) {
        int n2 = -1;
        if (returnableInt != null) {
            returnableInt.value = 1;
        }
        switch (n) {
            case 13: 
            case 14: {
                n2 = 5;
                break;
            }
            case 15: 
            case 16: {
                n2 = 7;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
            case 23: 
            case 24: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 9;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 10;
                break;
            }
            case 9: 
            case 10: {
                n2 = 12;
                break;
            }
            case 11: 
            case 12: {
                n2 = 13;
                break;
            }
        }
        return n2;
    }

    private String[] getLongZoneStrings() {
        Calendar calendar = this.cal.toCalendar();
        if (this.tz.inDaylightTime(calendar.getTime())) {
            return this.getZoneStrings(3);
        }
        return this.getZoneStrings(1);
    }

    public boolean getMaskInput() {
        return this.mask_input;
    }

    public int getMilleniumThreshold() {
        return this.millenium_threshold;
    }

    private String[] getShortZoneStrings() {
        Calendar calendar = this.cal.toCalendar();
        if (this.tz.inDaylightTime(calendar.getTime())) {
            return this.getZoneStrings(4);
        }
        return this.getZoneStrings(2);
    }

    private static String[] getStringArrayCopy(JCVector jCVector) {
        String[] stringArray = new String[jCVector.size()];
        int n = 0;
        while (n < jCVector.size()) {
            stringArray[n] = (String)jCVector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    private int getSymbol(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.compiled_format.elements.length) {
            if (n < (n2 += this.compiled_format.getLength(n3))) {
                return this.compiled_format.getSymbol(n3);
            }
            ++n3;
        }
        return -1;
    }

    public TimeZone getTimeZone() {
        return this.tz;
    }

    private String[] getZoneCities() {
        return this.getZoneStrings(5);
    }

    private int getZoneIndex() {
        String[][] stringArray = this.symbols.getZoneStrings();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n][0].equals(this.tz.getID())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private String[] getZoneStrings(int n) {
        String[][] stringArray = this.symbols.getZoneStrings();
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray2[n2] = stringArray[n2][n];
            ++n2;
        }
        return stringArray2;
    }

    public boolean inRange(Object object) {
        return true;
    }

    public void inferSubField(JCTextInterface jCTextInterface) {
        if (!this.mask_input || this.date_format == null) {
            return;
        }
        int n = jCTextInterface.getSelectionStart();
        int n2 = n >= this.date_format.length() ? this.date_format.length() - 1 : n;
        ReturnableInt returnableInt = new ReturnableInt();
        returnableInt.value = 1;
        int n3 = -1;
        while (n3 == -1 && n2 >= 0) {
            n3 = this.getIncrementField(this.getSymbol(n2), returnableInt);
            --n2;
        }
        n2 = n;
        while (n2 < this.date_format.length() && n3 == -1) {
            n3 = this.getIncrementField(this.getSymbol(n2), returnableInt);
            ++n2;
        }
        if (n3 != -1) {
            this.setIncrementField(n3);
            this.setIncrement(returnableInt.value);
        }
    }

    protected JCValidInfo internal_validate(WorkingCalendar workingCalendar) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        JCValidInfo jCValidInfo = new JCValidInfo();
        jCValidInfo.value = workingCalendar;
        jCValidInfo.valid = false;
        if (workingCalendar == null) {
            if (this.allow_null) {
                jCValidInfo.valid = true;
                return jCValidInfo;
            }
            return jCValidInfo;
        }
        Calendar calendar = Calendar.getInstance(this.tz, this.locale);
        calendar.setTime(new java.util.Date());
        WorkingCalendar workingCalendar2 = new WorkingCalendar(calendar);
        if (workingCalendar.isSet(1)) {
            n5 = workingCalendar.get(1);
        } else {
            n5 = workingCalendar2.get(1);
            workingCalendar.set(1, n5);
        }
        int n6 = JCCalendarValidator.dayOfWeek(n5, 0, 1);
        if (workingCalendar.isSet(3) && workingCalendar.isSet(7)) {
            n4 = workingCalendar.get(2);
            n3 = workingCalendar.get(1);
            n2 = 0;
            n = 0;
            while (n < n4) {
                n2 += JCCalendarValidator.daysInMonth(n, n3);
                ++n;
            }
            n2 += workingCalendar.get(5);
            if (workingCalendar.isSet(6)) {
                if (n2 != workingCalendar.get(6)) {
                    return jCValidInfo;
                }
            } else {
                workingCalendar.set(6, n2);
            }
        }
        if (workingCalendar.isSet(6)) {
            n4 = JCCalendarValidator.monthOfYear(n5, workingCalendar.get(6));
            if (workingCalendar.isSet(2)) {
                if (n4 != workingCalendar.get(2)) {
                    return jCValidInfo;
                }
            } else {
                workingCalendar.set(2, n4);
            }
            n3 = JCCalendarValidator.dayOfMonthOfYear(n5, workingCalendar.get(6));
            if (workingCalendar.isSet(5)) {
                if (n3 != workingCalendar.get(5)) {
                    return jCValidInfo;
                }
            } else {
                workingCalendar.set(5, n3);
            }
            if (!this.setDayOfWeek(workingCalendar, workingCalendar.get(1), workingCalendar.get(2), workingCalendar.get(5))) {
                return jCValidInfo;
            }
            if (!workingCalendar.isSet(3)) {
                workingCalendar.set(3, JCCalendarValidator.weekOfYear(n5, workingCalendar.get(6)));
            }
            if (!workingCalendar.isSet(4)) {
                workingCalendar.set(4, JCCalendarValidator.weekOfMonth(n5, workingCalendar.get(2), workingCalendar.get(5)));
            }
        } else if (workingCalendar.isSet(2)) {
            n4 = workingCalendar.get(2);
            if (workingCalendar.isSet(5)) {
                n3 = workingCalendar.get(5);
                workingCalendar.set(6, JCCalendarValidator.dayOfYear(n5, n4, n3));
                if (!this.setDayOfWeek(workingCalendar, n5, n4, n3)) {
                    return jCValidInfo;
                }
                workingCalendar.set(3, JCCalendarValidator.weekOfYear(n5, workingCalendar.get(6)));
                workingCalendar.set(4, JCCalendarValidator.weekOfMonth(n5, n4, n3));
            } else if (workingCalendar.isSet(4) && workingCalendar.isSet(7)) {
                throw new IllegalStateException("Validation from only WeekOfMonth and DayOfWeek not currently supported");
            }
        }
        if (workingCalendar.isSet(10) && workingCalendar.isSet(11) && workingCalendar.isSet(9)) {
            if (workingCalendar.get(10) + 12 * workingCalendar.get(9) != workingCalendar.get(11)) {
                return jCValidInfo;
            }
        } else if (workingCalendar.isSet(10) && !workingCalendar.isSet(11)) {
            if (!workingCalendar.isSet(9)) {
                if (workingCalendar.get(10) == 12) {
                    workingCalendar.set(9, 1);
                } else {
                    workingCalendar.set(9, 0);
                }
            }
            this.setHourOfDayFromHour(workingCalendar);
        } else if (workingCalendar.isSet(11)) {
            this.setHourFromHourOfDay(workingCalendar);
        }
        if (workingCalendar.isSet(11) || workingCalendar.isSet(12) || workingCalendar.isSet(13) || workingCalendar.isSet(14)) {
            if (!workingCalendar.isSet(11)) {
                workingCalendar.set(11, 0);
                this.setHourFromHourOfDay(workingCalendar);
            }
            if (!workingCalendar.isSet(12)) {
                workingCalendar.set(12, 0);
            }
            if (!workingCalendar.isSet(13)) {
                workingCalendar.set(13, 0);
            }
            if (!workingCalendar.isSet(14)) {
                workingCalendar.set(14, 0);
            }
        } else {
            workingCalendar.set(11, workingCalendar2.get(11));
            this.setHourFromHourOfDay(workingCalendar);
            workingCalendar.set(12, workingCalendar2.get(12));
            workingCalendar.set(13, workingCalendar2.get(13));
            workingCalendar.set(14, workingCalendar2.get(14));
        }
        n4 = 0;
        while (n4 < 17) {
            if (!workingCalendar.isSet(n4)) {
                workingCalendar.set(n4, workingCalendar2.get(n4));
            }
            ++n4;
        }
        n3 = workingCalendar.get(2);
        if (!JCCalendarValidator.domain_check(n3 + 1, 19)) {
            return jCValidInfo;
        }
        n2 = workingCalendar.get(6);
        if (n2 < 1 || n2 > JCCalendarValidator.daysInYear(n5)) {
            return jCValidInfo;
        }
        n = workingCalendar.get(5);
        if (n < 1 || n > JCCalendarValidator.daysInMonth(n3, n5)) {
            return jCValidInfo;
        }
        if (!JCCalendarValidator.domain_check(workingCalendar.get(11), 7)) {
            return jCValidInfo;
        }
        if (!JCCalendarValidator.domain_check(workingCalendar.get(12), 9)) {
            return jCValidInfo;
        }
        if (!JCCalendarValidator.domain_check(workingCalendar.get(13), 11)) {
            return jCValidInfo;
        }
        if (!JCCalendarValidator.domain_check(workingCalendar.get(14), 25)) {
            return jCValidInfo;
        }
        jCValidInfo.valid = true;
        jCValidInfo.value = ((WorkingCalendar)jCValidInfo.value).toCalendar();
        return jCValidInfo;
    }

    public static boolean isLeap(int n) {
        if (n >= 0) {
            return n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
        }
        return false;
    }

    public boolean isSupported(Object object) {
        return object instanceof Calendar;
    }

    public static int monthOfYear(int n, int n2) {
        int n3 = JCCalendarValidator.isLeap(n) ? 1 : 0;
        int n4 = 0;
        while (n2 > daytable[n3][n4]) {
            n2 -= daytable[n3][n4];
            ++n4;
        }
        return n4;
    }

    private int parseDigitField(WorkingCalendar workingCalendar, String string, int n, int n2, int n3, int n4) {
        if (!Character.isDigit(string.charAt(n)) || n >= string.length()) {
            return -1;
        }
        int n5 = n;
        while (n5 < string.length() && Character.isDigit(string.charAt(n5)) && n5 - n < n4) {
            ++n5;
        }
        int n6 = Integer.parseInt(string.substring(n, n5));
        if (!JCCalendarValidator.domain_check(n6, n2)) {
            return -1;
        }
        if (workingCalendar.isSet(n3) && workingCalendar.get(n3) != n6) {
            return -1;
        }
        workingCalendar.set(n3, n6);
        return n5;
    }

    private int parseEnum(WorkingCalendar workingCalendar, String string, int n, int n2, int n3, String[] stringArray) {
        if (n >= string.length()) {
            return -1;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < stringArray.length) {
            n4 = Math.max(n4, stringArray[n5].length());
            ++n5;
        }
        int n6 = -1;
        int n7 = 0;
        int n8 = n + 1;
        while (n8 - n <= n4) {
            int n9 = Math.min(n8, string.length());
            n5 = this.patternSearch(string.substring(n, n9), stringArray);
            if (n5 != -1) {
                n6 = n5;
                n7 = n9;
            }
            ++n8;
        }
        if (n6 == -1) {
            return -1;
        }
        if (workingCalendar.isSet(n3) && workingCalendar.get(n3) != n5) {
            return -1;
        }
        workingCalendar.set(n3, n6);
        return n7;
    }

    private int parseLiteral(WorkingCalendar workingCalendar, String string, int n, char c) {
        if (c == string.charAt(n)) {
            ++n;
        } else if (c != ' ') {
            return -1;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private boolean parseString(String var1_1, DateMask[] var2_2, WorkingCalendar var3_3) {
        if (var1_1 == null || var1_1.length() == 0 || var2_2 == null || var2_2.length == 0 && var3_3 != null) {
            return false;
        }
        var3_3.clear();
        var4_4 = 0;
        var5_5 = 0;
        ** GOTO lbl50
        {
            ++var5_5;
            do {
                if (var5_5 < var1_1.length() && Character.isSpaceChar(var1_1.charAt(var5_5))) continue block10;
                switch (var2_2[var4_4].symbol) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        var5_5 = this.parseDigitField(var3_3, var1_1, var5_5, var2_2[var4_4].symbol, var2_2[var4_4].field, 2);
                        break;
                    }
                    case 19: 
                    case 20: {
                        var5_5 = this.parseDigitField(var3_3, var1_1, var5_5, var2_2[var4_4].symbol, var2_2[var4_4].field, 2);
                        if (var5_5 == 0) {
                            var5_5 = -1;
                        }
                        if (var5_5 == -1) break;
                        var6_6 = var3_3.get(var2_2[var4_4].field);
                        if (var6_6 == 0) {
                            var5_5 = -1;
                            break;
                        }
                        var3_3.set(var2_2[var4_4].field, --var6_6);
                        break;
                    }
                    case 23: {
                        var5_5 = this.parseDigitField(var3_3, var1_1, var5_5, var2_2[var4_4].symbol, var2_2[var4_4].field, 2);
                        if (var5_5 == -1) break;
                        var6_6 = var3_3.get(var2_2[var4_4].field);
                        var6_6 = var6_6 < this.millenium_threshold ? (var6_6 += 2000) : (var6_6 += 1900);
                        var3_3.set(var2_2[var4_4].field, var6_6);
                        break;
                    }
                    case 24: {
                        var5_5 = this.parseDigitField(var3_3, var1_1, var5_5, var2_2[var4_4].symbol, var2_2[var4_4].field, 4);
                        break;
                    }
                    case 17: 
                    case 18: {
                        var5_5 = this.parseDigitField(var3_3, var1_1, var5_5, var2_2[var4_4].symbol, var2_2[var4_4].field, 3);
                        break;
                    }
                    case 2: 
                    case 15: 
                    case 16: 
                    case 21: 
                    case 22: {
                        var5_5 = this.parseEnum(var3_3, var1_1, var5_5, var2_2[var4_4].symbol, var2_2[var4_4].field, var2_2[var4_4].strings);
                        break;
                    }
                    case 3: 
                    case 4: {
                        var5_5 = this.parseTimeZone(var3_3, var1_1, var5_5);
                        break;
                    }
                    case 1: {
                        var5_5 = this.parseLiteral(var3_3, var1_1, var5_5, var2_2[var4_4].chars.charAt(0));
                        break;
                    }
                }
                if (var5_5 == -1) {
                    return false;
                }
                ++var4_4;
lbl50:
                // 2 sources

            } while (var4_4 < var2_2.length && var5_5 < var1_1.length());
        }
        while (var5_5 < var1_1.length() && Character.isSpaceChar(var1_1.charAt(var5_5))) {
            ++var5_5;
        }
        return var5_5 >= var1_1.length();
    }

    private int parseTimeZone(WorkingCalendar workingCalendar, String string, int n) {
        String[][] stringArray = this.symbols.getZoneStrings();
        String string2 = "";
        String string3 = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            string2 = stringArray[n2][2];
            int n3 = Math.min(string.length(), n + string2.length());
            if (string.substring(n, n3).equalsIgnoreCase(string2)) {
                string3 = stringArray[n2][0];
                break;
            }
            string2 = stringArray[n2][3];
            n3 = Math.min(string.length(), n + string2.length());
            if (string.substring(n, n3).equalsIgnoreCase(string2)) {
                string3 = stringArray[n2][0];
                break;
            }
            string2 = stringArray[n2][4];
            n3 = Math.min(string.length(), n + string2.length());
            if (string.substring(n, n3).equalsIgnoreCase(string2)) {
                string3 = stringArray[n2][0];
                break;
            }
            ++n2;
        }
        if (string3 == null) {
            String[] stringArray2 = TimeZone.getAvailableIDs();
            int n4 = 0;
            while (n4 < stringArray2.length) {
                string2 = stringArray2[n4];
                int n5 = Math.min(string.length(), n + string2.length());
                if (string.substring(n, n5).equalsIgnoreCase(string2)) {
                    string3 = stringArray2[n4];
                    break;
                }
                ++n4;
            }
        }
        if (string3 == null) {
            return -1;
        }
        workingCalendar.setTimeZone(TimeZone.getTimeZone(string3));
        return n + string2.length();
    }

    private int patternSearch(String string, String[] stringArray) {
        int n = -1;
        boolean bl = false;
        if (string == null || string.length() == 0) {
            return -1;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            StringBuffer stringBuffer = new StringBuffer(stringArray[n2]);
            int n3 = string.length();
            if (n3 < stringBuffer.length()) {
                stringBuffer.setLength(n3);
            }
            if (stringBuffer.toString().equalsIgnoreCase(string)) {
                if (bl) {
                    return -1;
                }
                bl = true;
                n = n2;
                break;
            }
            ++n2;
        }
        return bl ? n : -1;
    }

    private boolean setDayOfWeek(WorkingCalendar workingCalendar, int n, int n2, int n3) {
        int n4 = JCCalendarValidator.dayOfWeek(n, n2, n3);
        if (workingCalendar.isSet(7)) {
            if (n4 != workingCalendar.get(7)) {
                return false;
            }
        } else {
            workingCalendar.set(7, n4);
        }
        return true;
    }

    public void setDefaultDetail(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("invalid value for defaultDetail");
        }
        if (this.getFormat().equals(this.getDefaultFormat())) {
            this.default_detail = n;
            this.setFormat(this.getDefaultFormat());
        } else {
            this.default_detail = n;
        }
    }

    public void setEditFormats(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.edit_formats = new JCVector(0);
        this.edit_formats.copyFrom(stringArray);
        this.compiled_edit_formats.setSize(0);
        int n = 0;
        while (n < stringArray.length) {
            this.compiled_edit_formats.addElement(this.compileFormat(stringArray[n]));
            ++n;
        }
    }

    public void setFormat(String string) {
        this.compiled_format = this.compileFormat(string);
        this.date_format = string;
        this.original_format = string;
        if (string != null) {
            if (this.mask_input) {
                this.setMask(this.convertDateFormatToStringMask());
            } else {
                this.setMask("");
            }
        } else {
            this.setMask("");
        }
    }

    private void setHourFromHourOfDay(WorkingCalendar workingCalendar) {
        int n = workingCalendar.get(11);
        workingCalendar.set(9, n / 12);
        if ((n %= 12) == 0) {
            n = 12;
        }
        workingCalendar.set(10, n);
    }

    private void setHourOfDayFromHour(WorkingCalendar workingCalendar) {
        int n = workingCalendar.get(10) + 12 * workingCalendar.get(9);
        if (n == 12) {
            n = 0;
        } else if (n == 24) {
            n = 12;
        }
        workingCalendar.set(11, n);
    }

    public void setIncrement(int n) {
        this.increment = new Integer(n);
    }

    public void setIncrementField(int n) {
        if (n < 0 && n >= 17) {
            throw new IllegalArgumentException("invalid value for incrementField");
        }
        this.increment_field = n;
    }

    public void setLocale(Locale locale) {
        if (this.locale == locale) {
            return;
        }
        super.setLocale(locale);
        if (this.tz == null) {
            this.tz = TimeZone.getDefault();
        }
        this.cal = new WorkingCalendar(Calendar.getInstance(this.tz, locale));
        this.copy_fields(this.cal, this.cal);
        this.cal = this.cal;
        this.symbols = new DateFormatSymbols(locale);
    }

    public void setMaskInput(boolean bl) {
        this.mask_input = bl;
        if (bl) {
            this.setMask(this.convertDateFormatToStringMask());
        } else {
            this.setMask("");
        }
    }

    public void setMilleniumThreshold(int n) {
        if (n < 0 && n >= 100) {
            throw new IllegalArgumentException("invalid value for milleniumThreshold");
        }
        this.millenium_threshold = n;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.tz = timeZone;
        this.cal = new WorkingCalendar(Calendar.getInstance(this.tz, this.locale));
        this.copy_fields(this.cal, this.cal);
        this.cal = this.cal;
    }

    private void spinSubField(Calendar calendar, int n) {
        int n2 = this.increment_field;
        switch (n2) {
            case 0: 
            case 3: 
            case 4: 
            case 8: 
            case 15: 
            case 16: {
                throw new IllegalArgumentException();
            }
            case 9: {
                if (calendar.get(n2) == 0) {
                    calendar.set(n2, 1);
                    calendar.set(11, calendar.get(11) + 12);
                    break;
                }
                calendar.set(n2, 0);
                calendar.set(11, calendar.get(11) - 12);
                break;
            }
            case 6: {
                int n3 = (calendar.get(n2) + n) % JCCalendarValidator.daysInYear(calendar.get(1));
                if (n3 == 0) {
                    n3 = JCCalendarValidator.daysInYear(calendar.get(1));
                }
                calendar.set(n2, n3);
                break;
            }
            case 7: {
                int n4 = (calendar.get(n2) + n) % 7;
                if (n4 == 0) {
                    n4 = 7;
                }
                calendar.set(n2, n4);
                break;
            }
            case 10: {
                calendar.roll(11, n > 0);
                int n5 = calendar.get(11);
                break;
            }
            default: {
                calendar.roll(n2, n > 0);
            }
        }
    }

    protected Object subtractIncrement(Object object) {
        if (object == null || this.increment == null) {
            return null;
        }
        int n = (Integer)this.increment;
        if (n == 0) {
            return null;
        }
        Calendar calendar = (Calendar)object;
        calendar = (Calendar)calendar.clone();
        if (this.spin_policy == 1) {
            this.spinSubField(calendar, -n);
        } else {
            calendar.add(this.increment_field, -n);
        }
        return calendar;
    }

    public JCValidInfo validate(Object object) {
        Calendar calendar = (Calendar)object;
        if (object == null) {
            return this.internal_validate(null);
        }
        return this.internal_validate(new WorkingCalendar(calendar));
    }

    public JCValidInfo validateText(String string) {
        WorkingCalendar workingCalendar;
        boolean bl = false;
        JCValidInfo jCValidInfo = new JCValidInfo();
        if (this.mask_input) {
            jCValidInfo = super.validateText(string);
            if (!jCValidInfo.valid) {
                return jCValidInfo;
            }
            if (jCValidInfo.value == null && this.getAllowNull()) {
                return jCValidInfo;
            }
        }
        if (string.equalsIgnoreCase("now") || string.equalsIgnoreCase("today")) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new java.util.Date());
            workingCalendar = new WorkingCalendar(calendar);
            bl = true;
        } else if (this.mask_input) {
            workingCalendar = new WorkingCalendar();
            bl = this.parseString(string, this.compiled_format.elements, workingCalendar);
        } else {
            workingCalendar = new WorkingCalendar();
            int n = 0;
            while (n < this.compiled_edit_formats.size()) {
                bl = this.parseString(string, ((DateFormat)this.compiled_edit_formats.elementAt((int)n)).elements, workingCalendar);
                if (bl) break;
                ++n;
            }
        }
        if (bl) {
            return this.internal_validate(workingCalendar);
        }
        jCValidInfo.valid = false;
        jCValidInfo.value = null;
        return jCValidInfo;
    }

    public static int weekOfMonth(int n, int n2, int n3) {
        int n4 = JCCalendarValidator.dayOfWeek(n, n2, 0);
        return (n3 + (6 - n4)) / 7 + 1;
    }

    public static int weekOfYear(int n, int n2) {
        int n3 = JCCalendarValidator.dayOfWeek(n, 0, 0);
        return (n2 + (6 - n3)) / 7 + 1;
    }

    class WorkingCalendar
    implements Cloneable,
    Serializable {
        private int[] fields = new int[17];

        public WorkingCalendar() {
            Calendar calendar = Calendar.getInstance(JCCalendarValidator.this.tz, JCCalendarValidator.this.locale);
            this.create(calendar);
        }

        public WorkingCalendar(Calendar calendar) {
            this.create(calendar);
        }

        public void clear() {
            int n = 0;
            while (n < this.fields.length) {
                this.fields[n] = -1;
                ++n;
            }
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        private void create(Calendar calendar) {
            int n = 0;
            while (n < this.fields.length) {
                this.fields[n] = calendar.isSet(n) ? calendar.get(n) : -1;
                ++n;
            }
        }

        public int get(int n) {
            return this.fields[n];
        }

        public TimeZone getTimeZone() {
            return JCCalendarValidator.this.tz;
        }

        public boolean isSet(int n) {
            return this.fields[n] != -1;
        }

        public void set(int n, int n2) {
            this.fields[n] = n2;
        }

        public void setTimeZone(TimeZone timeZone) {
            JCCalendarValidator.this.tz = timeZone;
        }

        public Calendar toCalendar() {
            Calendar calendar = Calendar.getInstance(JCCalendarValidator.this.tz, JCCalendarValidator.this.locale);
            calendar.set(this.get(1), this.get(2), this.get(5), this.get(11), this.get(12), this.get(13));
            return calendar;
        }
    }
}

