/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.db;

import java.io.Serializable;
import java.util.Vector;
import jclass.chart.VectorDataSource;
import jclass.chart.db.DBUpdateEvent;
import jclass.chart.db.DBUpdateListener;
import jclass.chart.db.DataBindableObject;

public class DataBoundSource
extends VectorDataSource
implements DBUpdateListener {
    public static final int START_POINT = 0;
    public static final int END_POINT = 100;
    private Vector seriesColumns = null;
    private String pointLabelsColumn = null;
    private int startPoint = 0;
    private int endPoint = 100;
    private String table = null;
    private DataBindableObject db = null;
    private boolean allRows = false;

    public DataBoundSource(DataBindableObject dataBindableObject) {
        this.db = dataBindableObject;
        this.seriesColumns = new Vector();
    }

    public boolean getAllRows() {
        return this.allRows;
    }

    public DataBindableObject getDataBindableObject() {
        return this.db;
    }

    public int getEndPoint() {
        return this.endPoint;
    }

    public int getNumSeriesColumns() {
        return this.seriesColumns.size();
    }

    public String getPointLabelsColumn() {
        return this.pointLabelsColumn;
    }

    public String[] getSeriesColumns() {
        if (this.seriesColumns == null || this.seriesColumns.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.seriesColumns.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)this.seriesColumns.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public String getSeriesColumns(int n) {
        if (n < 0 || n >= this.seriesColumns.size()) {
            throw new IllegalArgumentException();
        }
        return (String)this.seriesColumns.elementAt(n);
    }

    public int getStartPoint() {
        return this.startPoint;
    }

    public String getTable() {
        return this.table;
    }

    private void init() {
        this.seriesColumns = null;
        this.pointLabelsColumn = null;
        this.startPoint = 0;
        this.endPoint = 100;
        this.allRows = false;
        this.table = null;
        this.seriesColumns = new Vector();
    }

    public void refreshChart(DBUpdateEvent dBUpdateEvent) {
        this.db = dBUpdateEvent.getDataBindableObject();
        this.setData(null);
        this.refreshSeries();
        this.setLabelsForSeries();
        this.refreshPointLabels();
    }

    private void refreshPointLabels() {
        if (this.pointLabelsColumn != null && this.pointLabelsColumn.compareTo("") != 0) {
            Vector vector = this.db.getData("select " + this.pointLabelsColumn + " from " + this.table, this.startPoint, this.endPoint, this.allRows);
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            this.setPointLabels((String[])objectArray);
        }
    }

    private void refreshSeries() {
        int n = this.seriesColumns.size();
        double[][] dArray = new double[n + 1][];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string = (String)this.seriesColumns.elementAt(n3);
            String string2 = "select " + string + " from " + this.table;
            Vector vector = this.db.getData(string2, this.startPoint, this.endPoint, this.allRows);
            int n4 = vector.size();
            if (n2 <= n4) {
                n2 = n4;
            }
            dArray[n3 + 1] = new double[n4];
            int n5 = 0;
            while (n5 < n4) {
                if (vector.elementAt(n5) != null) {
                    try {
                        dArray[n3 + 1][n5] = Double.valueOf(vector.elementAt(n5).toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println(vector.elementAt(n5).toString());
                    }
                }
                ++n5;
            }
            ++n3;
        }
        dArray[0] = new double[n2];
        int n6 = 0;
        while (n6 < n2) {
            dArray[0][n6] = n6;
            ++n6;
        }
        this.setData(dArray);
    }

    public void setAllRows(boolean bl) {
        if (this.allRows == bl) {
            return;
        }
        this.allRows = bl;
        this.refreshSeries();
        this.refreshPointLabels();
    }

    public void setDataBindableObject(DataBindableObject dataBindableObject) {
        this.db = dataBindableObject;
        this.init();
    }

    public synchronized void setEndPoint(int n) {
        if (this.endPoint == n) {
            return;
        }
        this.endPoint = n;
        this.refreshSeries();
        this.refreshPointLabels();
    }

    private void setLabelsForSeries() {
        Object[] objectArray = new String[this.seriesColumns.size()];
        this.seriesColumns.copyInto(objectArray);
        this.setSeriesLabels((String[])objectArray);
    }

    public void setPointLabelsColumn(String string) {
        if (string == null) {
            return;
        }
        if (this.pointLabelsColumn != null && this.pointLabelsColumn.compareTo(string) == 0) {
            return;
        }
        boolean bl = false;
        Serializable serializable = this;
        synchronized (serializable) {
            if (DataBindableObject.isCharacter(this.db.getColumnType(this.table, string)) || DataBindableObject.isTimeDate(this.db.getColumnType(this.table, string))) {
                this.pointLabelsColumn = string;
                bl = true;
            }
        }
        if (bl) {
            serializable = this.db.getData("select " + this.pointLabelsColumn + " from " + this.table, this.startPoint, this.endPoint, this.allRows);
            Object[] objectArray = new String[((Vector)serializable).size()];
            ((Vector)serializable).copyInto(objectArray);
            this.setPointLabels((String[])objectArray);
        } else if (string.compareTo("") == 0) {
            this.pointLabelsColumn = string;
            this.pointLabels.removeAllElements();
            this.updateChart(17, 0, 0);
        }
    }

    public void setSeriesColumns(int n, String string) {
        DataBoundSource dataBoundSource = this;
        synchronized (dataBoundSource) {
            if (n < 0 || n >= this.seriesColumns.size()) {
                throw new IllegalArgumentException();
            }
            if (DataBindableObject.isNumeric(this.db.getColumnType(this.table, string))) {
                this.seriesColumns.setElementAt(string, n);
            }
        }
        this.refreshSeries();
        this.setLabelsForSeries();
    }

    public void setSeriesColumns(String[] stringArray) {
        DataBoundSource dataBoundSource = this;
        synchronized (dataBoundSource) {
            this.seriesColumns.removeAllElements();
            int n = 0;
            while (n < stringArray.length) {
                if (DataBindableObject.isNumeric(this.db.getColumnType(this.table, stringArray[n]))) {
                    this.seriesColumns.addElement(stringArray[n]);
                }
                ++n;
            }
            this.refreshSeries();
            this.setLabelsForSeries();
        }
    }

    public synchronized void setStartPoint(int n) {
        if (this.startPoint == n) {
            return;
        }
        this.startPoint = n;
        this.refreshSeries();
        this.refreshPointLabels();
    }

    public void setTable(String string) {
        if (string == null) {
            return;
        }
        if (this.table != null && this.table.compareTo(string) == 0) {
            return;
        }
        this.table = string;
        this.setName(this.table);
    }
}

