/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.db;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jclass.chart.JCChartBundle;
import jclass.chart.db.DataBindingMetaData;

public class DataBindingMetaDataComponent
extends JPanel
implements Customizer,
Serializable {
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public DataBindingMetaData dbMetaData = null;
    private JTextField startPoint = null;
    private JTextField endPoint = null;
    private JCheckBox allRows = null;
    private JList seriesColumns = null;
    private JList pointLabelsColumns = null;

    public DataBindingMetaDataComponent(DataBindingMetaData dataBindingMetaData) {
        this.dbMetaData = dataBindingMetaData;
        if (this.dbMetaData != null) {
            this.init();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    private String buildEmptyString(int n) {
        String string = new String();
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + " ";
            ++n2;
        }
        return string;
    }

    private void fireEndPoint() {
        String string = this.endPoint.getText();
        try {
            this.dbMetaData.setEndPoint(new Integer(string));
            this.listeners.firePropertyChange("End Point", null, this.dbMetaData);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void fireStartPoint() {
        String string = this.startPoint.getText();
        try {
            this.dbMetaData.setStartPoint(new Integer(string));
            this.listeners.firePropertyChange("Start Point", null, this.dbMetaData);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(JCChartBundle.string("jclass.chart.Key180")));
        jPanel.setLayout(gridBagLayout);
        jPanel.add(new JLabel(String.valueOf(JCChartBundle.string("jclass.chart.Key176")) + ":"));
        this.startPoint = new JTextField(Integer.toString(this.dbMetaData.getStartPoint()), 5);
        this.startPoint.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                String string = DataBindingMetaDataComponent.this.startPoint.getText();
                try {
                    DataBindingMetaDataComponent.this.dbMetaData.setStartPoint(new Integer(string));
                    DataBindingMetaDataComponent.this.listeners.firePropertyChange("Start Point", null, DataBindingMetaDataComponent.this.dbMetaData);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        gridBagLayout.setConstraints(this.startPoint, gridBagConstraints);
        jPanel.add(this.startPoint);
        jPanel.add(new JLabel(String.valueOf(JCChartBundle.string("jclass.chart.Key177")) + ":"));
        this.endPoint = new JTextField(Integer.toString(this.dbMetaData.getEndPoint()), 5);
        this.endPoint.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                String string = DataBindingMetaDataComponent.this.endPoint.getText();
                try {
                    DataBindingMetaDataComponent.this.dbMetaData.setEndPoint(new Integer(string));
                    DataBindingMetaDataComponent.this.listeners.firePropertyChange("End Point", null, DataBindingMetaDataComponent.this.dbMetaData);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        this.allRows = new JCheckBox(JCChartBundle.string("jclass.chart.Key298"), this.dbMetaData.getAllRows());
        this.startPoint.setEnabled(this.allRows.isSelected() ^ true);
        this.endPoint.setEnabled(this.allRows.isSelected() ^ true);
        this.allRows.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getSource() == null) {
                    return;
                }
                DataBindingMetaDataComponent.this.startPoint.setEnabled(itemEvent.getStateChange() != 1);
                DataBindingMetaDataComponent.this.endPoint.setEnabled(itemEvent.getStateChange() != 1);
                DataBindingMetaDataComponent.this.dbMetaData.setAllRows(itemEvent.getStateChange() == 1);
                DataBindingMetaDataComponent.this.listeners.firePropertyChange("All Rows", null, DataBindingMetaDataComponent.this.dbMetaData);
            }
        });
        gridBagLayout.setConstraints(this.endPoint, gridBagConstraints);
        jPanel.add(this.endPoint);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        gridBagLayout.setConstraints(this.allRows, gridBagConstraints);
        jPanel.add(this.allRows);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 4, 4));
        this.seriesColumns = new JList();
        this.seriesColumns.setModel(new DefaultListModel());
        this.seriesColumns.getSelectionModel().setSelectionMode(2);
        if (this.dbMetaData.getPotentialSeriesColumns() != null) {
            this.seriesColumns.setListData(this.dbMetaData.getPotentialSeriesColumns());
            if (this.dbMetaData.getSeriesColumns() != null) {
                this.selectStrings(this.seriesColumns, this.dbMetaData.getSeriesColumns());
            }
        }
        this.seriesColumns.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getSource() == null) {
                    return;
                }
                if (listSelectionEvent.getSource() instanceof DefaultListSelectionModel) {
                    int n = DataBindingMetaDataComponent.this.seriesColumns.getSelectedValues().length;
                    String[] stringArray = new String[n];
                    int n2 = 0;
                    while (n2 < n) {
                        stringArray[n2] = (String)DataBindingMetaDataComponent.this.seriesColumns.getSelectedValues()[n2];
                        ++n2;
                    }
                    DataBindingMetaDataComponent.this.dbMetaData.setSeriesColumns(stringArray);
                    DataBindingMetaDataComponent.this.listeners.firePropertyChange("Series Columns", null, DataBindingMetaDataComponent.this.dbMetaData);
                }
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(JCChartBundle.string("jclass.chart.Key181")));
        jPanel3.add((Component)new JScrollPane(this.seriesColumns), "Center");
        jPanel3.add((Component)new JLabel(this.buildEmptyString(JCChartBundle.string("jclass.chart.Key181").length() + 30)), "South");
        jPanel2.add(jPanel3);
        this.pointLabelsColumns = new JList();
        this.pointLabelsColumns.setModel(new DefaultListModel());
        if (this.dbMetaData.getPotentialPointLabelsColumns() != null) {
            this.pointLabelsColumns.setListData(this.dbMetaData.getPotentialPointLabelsColumns());
            if (this.dbMetaData.getPointLabelsColumn() != null) {
                this.selectStrings(this.pointLabelsColumns, new String[]{this.dbMetaData.getPointLabelsColumn()});
            }
        }
        this.pointLabelsColumns.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getSource() == null) {
                    return;
                }
                if (listSelectionEvent.getSource() instanceof DefaultListSelectionModel) {
                    String string = (String)DataBindingMetaDataComponent.this.pointLabelsColumns.getSelectedValue();
                    DataBindingMetaDataComponent.this.dbMetaData.setPointLabelsColumn(string);
                    DataBindingMetaDataComponent.this.listeners.firePropertyChange("Point Columns", null, DataBindingMetaDataComponent.this.dbMetaData);
                }
            }
        });
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(JCChartBundle.string("jclass.chart.Key182")));
        jPanel3.add((Component)new JScrollPane(this.pointLabelsColumns), "Center");
        jPanel3.add((Component)new JLabel(this.buildEmptyString(JCChartBundle.string("jclass.chart.Key182").length() + 30)), "South");
        jPanel2.add(jPanel3);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    private void selectStrings(JList jList, String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = jList.getModel().getSize();
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = 0;
            while (n3 < n) {
                if (((String)jList.getModel().getElementAt(n3)).compareTo(stringArray[n2]) == 0) {
                    vector.addElement(new Integer(n3));
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        int[] nArray = new int[vector.size()];
        int n4 = 0;
        while (n4 < nArray.length) {
            nArray[n4] = (Integer)vector.elementAt(n4);
            ++n4;
        }
        jList.setSelectedIndices(nArray);
    }

    public void setObject(Object object) {
        if (object == null) {
            ((DefaultListModel)this.seriesColumns.getModel()).removeAllElements();
            ((DefaultListModel)this.pointLabelsColumns.getModel()).removeAllElements();
            return;
        }
        this.dbMetaData = (DataBindingMetaData)object;
        this.startPoint.setText(String.valueOf(this.dbMetaData.getStartPoint()));
        this.endPoint.setText(String.valueOf(this.dbMetaData.getEndPoint()));
        ((DefaultListModel)this.seriesColumns.getModel()).removeAllElements();
        this.seriesColumns.setListData(this.dbMetaData.getPotentialSeriesColumns());
        this.selectStrings(this.seriesColumns, this.dbMetaData.getSeriesColumns());
        ((DefaultListModel)this.pointLabelsColumns.getModel()).removeAllElements();
        this.pointLabelsColumns.setListData(this.dbMetaData.getPotentialPointLabelsColumns());
        if (this.dbMetaData.getPointLabelsColumn() != null) {
            this.selectStrings(this.pointLabelsColumns, new String[]{this.dbMetaData.getPointLabelsColumn()});
        }
    }
}

