/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.db;

import java.io.Serializable;
import java.util.Vector;
import jclass.chart.db.DataBindableObject;

public class DataBindingMetaData
implements Serializable {
    private Vector columnNames = null;
    private String pointLabelsColumn = null;
    private String[] seriesColumns = null;
    private int startPoint = 0;
    private int endPoint = 100;
    private DataBindableObject dbObject = null;
    private Vector numericCols = null;
    private Vector string_dateCols = null;
    private boolean allRows = false;

    public DataBindingMetaData() {
    }

    public DataBindingMetaData(String string, String[] stringArray, int n, int n2, boolean bl) {
        this.pointLabelsColumn = string;
        this.seriesColumns = stringArray;
        this.startPoint = n;
        this.endPoint = n2;
        this.allRows = bl;
    }

    public DataBindingMetaData(DataBindableObject dataBindableObject) {
        this.dbObject = dataBindableObject;
        this.fillObject();
    }

    public DataBindingMetaData(DataBindingMetaData dataBindingMetaData) {
        this.columnNames = dataBindingMetaData.columnNames;
        this.pointLabelsColumn = dataBindingMetaData.pointLabelsColumn;
        this.seriesColumns = dataBindingMetaData.seriesColumns;
        this.startPoint = dataBindingMetaData.startPoint;
        this.endPoint = dataBindingMetaData.endPoint;
        this.dbObject = dataBindingMetaData.dbObject;
        this.numericCols = dataBindingMetaData.numericCols;
        this.string_dateCols = dataBindingMetaData.string_dateCols;
        this.allRows = dataBindingMetaData.allRows;
    }

    private void fillColumnsVectors() {
        if (this.columnNames == null) {
            return;
        }
        int n = this.columnNames.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.columnNames.elementAt(n2);
            int n3 = this.dbObject.getColumnType("", string);
            if (DataBindableObject.isNumeric(n3)) {
                this.numericCols.addElement(string);
            } else if (DataBindableObject.isCharacter(n3) || DataBindableObject.isTimeDate(n3)) {
                this.string_dateCols.addElement(string);
            }
            ++n2;
        }
    }

    private void fillObject() {
        if (this.dbObject != null) {
            this.columnNames = this.dbObject.getColumnsNames("");
            this.numericCols = new Vector();
            this.string_dateCols = new Vector();
            this.fillColumnsVectors();
        }
    }

    public boolean getAllRows() {
        return this.allRows;
    }

    public Vector getColumnNames() {
        return this.columnNames;
    }

    public DataBindableObject getDBObject() {
        return this.dbObject;
    }

    public int getEndPoint() {
        return this.endPoint;
    }

    public String getPointLabelsColumn() {
        return this.pointLabelsColumn;
    }

    public String[] getPotentialPointLabelsColumns() {
        if (this.string_dateCols == null || this.string_dateCols.size() <= 0) {
            return null;
        }
        int n = this.string_dateCols.size();
        Object[] objectArray = new String[n];
        this.string_dateCols.copyInto(objectArray);
        return objectArray;
    }

    public String[] getPotentialSeriesColumns() {
        if (this.numericCols == null || this.numericCols.size() <= 0) {
            return null;
        }
        int n = this.numericCols.size();
        Object[] objectArray = new String[n];
        this.numericCols.copyInto(objectArray);
        return objectArray;
    }

    public String[] getSeriesColumns() {
        return this.seriesColumns;
    }

    public int getStartPoint() {
        return this.startPoint;
    }

    public void setAllRows(boolean bl) {
        this.allRows = bl;
    }

    public synchronized void setColumnNames(Vector vector) {
        this.columnNames = vector;
    }

    public synchronized void setDBObject(DataBindableObject dataBindableObject) {
        this.dbObject = dataBindableObject;
        this.fillObject();
    }

    public synchronized void setEndPoint(int n) {
        this.endPoint = n;
    }

    public synchronized void setPointLabelsColumn(String string) {
        this.pointLabelsColumn = string;
    }

    public synchronized void setSeriesColumns(String[] stringArray) {
        this.seriesColumns = stringArray;
    }

    public synchronized void setStartPoint(int n) {
        this.startPoint = n;
    }
}

