/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JPropertyPage;
import jclass.chart.customizer.swing.JSpinBox;

public class JIntegerEditor
extends JPropertyPage
implements AdjustmentListener,
ActionListener,
PropertyEditor {
    protected JSpinBox box = null;
    protected PropertyChangeSupport listeners = null;

    public JIntegerEditor() {
        this(0);
    }

    public JIntegerEditor(int n) {
        this.setToolTipText(JIntegerEditor.getPageTitle());
        this.setLayout(new GridLayout(1, 1));
        this.box = new JSpinBox(n);
        this.box.getScrollBar().addAdjustmentListener(this);
        this.box.getTextField().addActionListener(this);
        this.add(this.box);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null && actionEvent.getSource() == this.box.getTextField()) {
            this.box.setTextValue(actionEvent.getActionCommand());
            if (this.listeners != null) {
                this.listeners.firePropertyChange("", null, new Integer(this.box.getIntValue()));
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent != null && adjustmentEvent.getSource() == this.box.getScrollBar()) {
            this.box.setIntValue(adjustmentEvent.getValue());
            if (this.listeners != null) {
                this.listeners.firePropertyChange("", null, new Integer(adjustmentEvent.getValue()));
            }
        }
    }

    public String getAsText() {
        return this.box.getTextValue();
    }

    public Component getCustomEditor() {
        return null;
    }

    public String getJavaInitializationString() {
        return this.getAsText();
    }

    public static String getPageName() {
        return "JIntegerEditor";
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key131");
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return new Integer(this.box.getIntValue());
    }

    public boolean isPaintable() {
        return false;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(JIntegerEditor.getPageTitle());
        serializable = new JIntegerEditor();
        ((JIntegerEditor)serializable).setBackground(Color.lightGray);
        ((JPropertyPage)serializable).init();
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.box.setTextValue(string);
    }

    public void setBackground(Color color) {
        if (this.box != null) {
            this.box.setBackground(color);
        }
    }

    public void setMaximum(int n) {
        this.box.setMaximum(n);
    }

    public void setMinimum(int n) {
        this.box.setMinimum(n);
    }

    public void setValue(Object object) {
        int n;
        int n2;
        if (object instanceof Integer && (n2 = ((Integer)object).intValue()) != (n = this.box.getIntValue())) {
            this.box.setIntValue(n2);
        }
    }

    public boolean supportsCustomEditor() {
        return false;
    }
}

