/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import jclass.chart.ChartRegion;
import jclass.chart.JCChart;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JEnumEditor;
import jclass.chart.customizer.swing.JIntegerEditor;
import jclass.chart.customizer.swing.JPropertyPage;

public class ChartBorderPage
extends JPropertyPage {
    private JEnumEditor borderTypeEditor;
    private JIntegerEditor borderWidthEditor;
    private ChartRegion region = null;
    private JCChart chart = null;

    public Object getObject() {
        if (this.region != null) {
            return this.region;
        }
        return this.chart;
    }

    public static String getPageName() {
        return "ChartBorderPage";
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key165");
    }

    public void init() {
        super.init();
        this.setToolTipText(ChartBorderPage.getPageTitle());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        gridBagConstraints.weightx = 1.0;
        this.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key164")) + ":"));
        this.borderTypeEditor = new JEnumEditor(ChartRegion.border_strings, ChartRegion.border_values);
        this.borderTypeEditor.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.borderTypeEditor, gridBagConstraints);
        this.add(this.borderTypeEditor);
        this.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key116")) + ":"));
        this.borderWidthEditor = new JIntegerEditor();
        this.borderWidthEditor.addPropertyChangeListener(this);
        this.borderWidthEditor.setMinimum(0);
        gridBagLayout.setConstraints(this.borderWidthEditor, gridBagConstraints);
        this.add(this.borderWidthEditor);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(ChartBorderPage.getPageTitle());
        serializable = new ChartBorderPage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((ChartBorderPage)serializable).init();
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public void propertyChanged(Object object, Object object2) {
        if (object2 == null) {
            return;
        }
        if (this.region != null) {
            if (object == this.borderTypeEditor) {
                this.region.setBorderType((Integer)object2);
            } else if (object == this.borderWidthEditor) {
                this.region.setBorderWidth((Integer)object2);
            }
        } else if (this.chart != null) {
            if (object == this.borderTypeEditor) {
                this.chart.setBorderType((Integer)object2);
            } else if (object == this.borderWidthEditor) {
                this.chart.setBorderWidth((Integer)object2);
            }
        }
    }

    public void setObject(Object object) {
        if (object instanceof JCChart) {
            this.chart = (JCChart)object;
            this.borderTypeEditor.setValue(new Integer(this.chart.getBorderType()));
            this.borderWidthEditor.setValue(new Integer(this.chart.getBorderWidth()));
        } else if (object instanceof ChartRegion) {
            this.region = (ChartRegion)object;
            this.borderTypeEditor.setValue(new Integer(this.region.getBorderType()));
            this.borderWidthEditor.setValue(new Integer(this.region.getBorderWidth()));
        }
    }
}

