/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.customizer.swing.JBooleanEditor;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JDoubleEditor;
import jclass.chart.customizer.swing.JPropertyPage;
import jclass.chart.customizer.swing.LineStylePage;

public class AxisGridPage
extends JPropertyPage {
    private JBooleanEditor showGridCheck = null;
    private JDoubleEditor gridField = null;
    private JBooleanEditor gridDefault = null;
    private LineStylePage stylePage = null;
    private JCAxis target;

    public static String getPageName() {
        return "AxisGridPage";
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key201");
    }

    public void init() {
        super.init();
        this.setToolTipText(AxisGridPage.getPageTitle());
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        this.setLayout(gridBagLayout);
        jPanel.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key198")) + ":"));
        this.showGridCheck = new JBooleanEditor("");
        this.showGridCheck.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.showGridCheck, gridBagConstraints);
        jPanel.add(this.showGridCheck);
        jPanel.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key199")) + ":"));
        this.gridField = new JDoubleEditor(9);
        this.gridField.addPropertyChangeListener(this);
        jPanel.add(this.gridField);
        this.gridDefault = new JBooleanEditor(JCustomizerBundle.string("jclass.chart.customizer.swing.Key124"));
        this.gridDefault.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.gridDefault, gridBagConstraints);
        jPanel.add(this.gridDefault);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder(JCustomizerBundle.string("jclass.chart.customizer.swing.Key200")));
        jPanel2.setLayout(new GridLayout(1, 1));
        this.stylePage = new LineStylePage();
        this.stylePage.init();
        jPanel2.add(this.stylePage);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(AxisGridPage.getPageTitle());
        serializable = new AxisGridPage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((AxisGridPage)serializable).init();
        ((AxisGridPage)serializable).setObject(new JCChart());
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public void propertyChanged(Object object, Object object2) {
        JComponent jComponent;
        if (this.target == null || object == null) {
            return;
        }
        if (object instanceof JBooleanEditor) {
            jComponent = (JBooleanEditor)object;
            boolean bl = (Boolean)object2;
            if (jComponent == this.showGridCheck) {
                this.target.setGridIsShowing(bl);
            }
            if (jComponent == this.gridDefault) {
                this.target.setGridSpacingIsDefault(bl);
            }
        }
        if (object instanceof JDoubleEditor) {
            jComponent = (JDoubleEditor)object;
            double d = (Double)object2;
            if (jComponent == this.gridField) {
                this.target.setGridSpacing(d);
                this.setObject(this.target);
            }
        }
    }

    public void setObject(Object object) {
        if (object instanceof JCAxis) {
            this.target = (JCAxis)object;
            boolean bl = this.target.getGridIsShowing();
            this.showGridCheck.setSelected(bl);
            Double d = new Double(this.target.getGridSpacing());
            this.gridField.setValue(d.toString());
            boolean bl2 = this.target.getGridSpacingIsDefault();
            this.gridDefault.setSelected(bl2);
            this.gridDefault.setEnabled(bl2 ^ true);
            this.stylePage.setObject(this.target.getGridStyle());
        }
    }
}

