/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.Vector;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAdjustmentEvent;
import jclass.bwt.JCAdjustmentListener;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCButton;
import jclass.bwt.JCContainer;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.bwt.JCList;
import jclass.bwt.JCSlider;
import jclass.bwt.JCTextField;
import jclass.chart.JCChartUtil;
import jclass.chart.customizer.JCPropertyChangeEvent;
import jclass.chart.customizer.JCPropertyPage;
import jclass.util.JCUtilConverter;

public class JCDeluxColorEditor
extends JCPropertyPage
implements JCActionListener,
JCAdjustmentListener,
JCItemListener,
PropertyEditor {
    static String[] color_names = new String[]{"Black", "Blue", "Cyan", "DarkGray", "Gray", "Green", "LightGray", "LightBlue", "Magenta", "Orange", "Pink", "Red", "White", "Yellow"};
    Color theColor;
    public static String INHERIT_STRING = "inherit";
    private JCLabel swatch;
    private JCButton darker;
    private JCButton brighter;
    private JCTextField field;
    private JCList colorList;
    private JCSlider red;
    private JCSlider green;
    private JCSlider blue;
    private JCSlider hue;
    private JCSlider sat;
    private JCSlider bright;
    private JCLabel redVal;
    private JCLabel greenVal;
    private JCLabel blueVal;
    private JCLabel hueVal;
    private JCLabel satVal;
    private JCLabel brightVal;
    private JCButton applyButton;
    private JCButton cancelButton;
    private Vector listeners;

    public JCDeluxColorEditor() {
        this.setLayout(new BorderLayout());
        JCContainer jCContainer = new JCContainer();
        jCContainer.setLayout(new BorderLayout());
        JCContainer jCContainer2 = new JCContainer();
        jCContainer2.setLayout(new BorderLayout());
        jCContainer2.setInsets(new Insets(2, 2, 0, 2));
        this.swatch = new JCLabel(" Sample ");
        this.swatch.setShadowType(3);
        this.swatch.setShadowThickness(1);
        jCContainer2.add("Center", this.swatch);
        JCContainer jCContainer3 = new JCContainer();
        jCContainer3.setLayout(new GridLayout(1, 2));
        jCContainer3.setInsets(new Insets(2, 0, 0, 0));
        this.brighter = new JCButton("Lighter");
        this.brighter.addActionListener(this);
        jCContainer3.add(this.brighter);
        this.darker = new JCButton("Darker");
        this.darker.addActionListener(this);
        jCContainer3.add(this.darker);
        jCContainer2.add("South", jCContainer3);
        jCContainer.add("West", jCContainer2);
        JCContainer jCContainer4 = new JCContainer();
        jCContainer4.setLayout(new BorderLayout());
        this.field = new JCTextField("", 11);
        this.field.addActionListener(this);
        jCContainer4.add("North", this.field);
        this.colorList = new JCList(color_names, "colorList");
        this.colorList.addItemListener(this);
        jCContainer4.add("Center", this.colorList);
        jCContainer.add("Center", jCContainer4);
        JCContainer jCContainer5 = new JCContainer();
        jCContainer5.setLayout(new JCAlignerLayout(3, 1, 1));
        JCLabel jCLabel = new JCLabel("Red:");
        jCContainer5.add(jCLabel);
        this.red = new JCSlider(0, 128, 0, 255);
        this.red.addAdjustmentListener(this);
        this.red.setAutoTick(false);
        this.red.setPreferredSize(100, -999);
        jCContainer5.add(this.red);
        this.redVal = new JCLabel("128");
        jCContainer5.add(this.redVal);
        JCLabel jCLabel2 = new JCLabel("Green:");
        jCContainer5.add(jCLabel2);
        this.green = new JCSlider(0, 128, 0, 255);
        this.green.addAdjustmentListener(this);
        this.green.setAutoTick(false);
        this.green.setPreferredSize(100, -999);
        jCContainer5.add(this.green);
        this.greenVal = new JCLabel("128");
        jCContainer5.add(this.greenVal);
        JCLabel jCLabel3 = new JCLabel("Blue:");
        jCContainer5.add(jCLabel3);
        this.blue = new JCSlider(0, 128, 0, 255);
        this.blue.addAdjustmentListener(this);
        this.blue.setAutoTick(false);
        this.blue.setPreferredSize(100, -999);
        jCContainer5.add(this.blue);
        this.blueVal = new JCLabel("128");
        jCContainer5.add(this.blueVal);
        JCLabel jCLabel4 = new JCLabel("Hue:");
        jCContainer5.add(jCLabel4);
        this.hue = new JCSlider(0, 128, 0, 255);
        this.hue.addAdjustmentListener(this);
        this.hue.setAutoTick(false);
        this.hue.setPreferredSize(100, -999);
        jCContainer5.add(this.hue);
        this.hueVal = new JCLabel("0.9999");
        jCContainer5.add(this.hueVal);
        JCLabel jCLabel5 = new JCLabel("Sat:");
        jCContainer5.add(jCLabel5);
        this.sat = new JCSlider(0, 128, 0, 255);
        this.sat.addAdjustmentListener(this);
        this.sat.setAutoTick(false);
        this.sat.setPreferredSize(100, -999);
        jCContainer5.add(this.sat);
        this.satVal = new JCLabel("0.9999");
        jCContainer5.add(this.satVal);
        JCLabel jCLabel6 = new JCLabel("Bright:");
        jCContainer5.add(jCLabel6);
        this.bright = new JCSlider(0, 128, 0, 255);
        this.bright.addAdjustmentListener(this);
        this.bright.setAutoTick(false);
        this.bright.setPreferredSize(100, -999);
        jCContainer5.add(this.bright);
        this.brightVal = new JCLabel("0.9999");
        jCContainer5.add(this.brightVal);
        jCContainer.add("East", jCContainer5);
        this.add("Center", jCContainer);
        JCContainer jCContainer6 = new JCContainer();
        jCContainer6.setLayout(new FlowLayout(1, 10, 2));
        this.applyButton = new JCButton("Apply");
        this.applyButton.addActionListener(this);
        jCContainer6.add(this.applyButton);
        this.cancelButton = new JCButton("Cancel");
        this.cancelButton.addActionListener(this);
        jCContainer6.add(this.cancelButton);
        this.add("South", jCContainer6);
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.brighter) {
            if (!this.theColor.equals(Color.white)) {
                this.setValue(BWTUtil.brighter(this.theColor));
            }
        } else if (jCActionEvent.getSource() == this.darker) {
            if (!this.theColor.equals(Color.black)) {
                this.setValue(BWTUtil.darker(this.theColor));
            }
        } else if (jCActionEvent.getSource() == this.field) {
            String string = this.field.getText().replace(',', '-');
            if (string.equals("") || string.equalsIgnoreCase("null") || string.indexOf(INHERIT_STRING) >= 0) {
                this.theColor = null;
                this.field.setText(INHERIT_STRING);
            } else {
                Color color = JCUtilConverter.toColor(string);
                if (color != null) {
                    this.setValue(color);
                } else {
                    this.field.beep();
                }
            }
        } else if (jCActionEvent.getSource() == this.applyButton) {
            this.firePropertyChange("", null, this.getValue());
            this.setToList(this.colorList, this.field.getText());
        } else if (jCActionEvent.getSource() == this.cancelButton) {
            ((Component)JCPropertyPage.getFrame(this)).hide();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public void adjustmentValueChanged(JCAdjustmentEvent jCAdjustmentEvent) {
        int[] nArray = new int[3];
        if (jCAdjustmentEvent.getSource() == this.red || jCAdjustmentEvent.getSource() == this.green || jCAdjustmentEvent.getSource() == this.blue) {
            nArray[0] = this.red.getValue();
            nArray[1] = this.green.getValue();
            nArray[2] = this.blue.getValue();
            Color color = new Color(nArray[0], nArray[1], nArray[2]);
            this.setValue(color);
        } else if (jCAdjustmentEvent.getSource() == this.hue || jCAdjustmentEvent.getSource() == this.sat || jCAdjustmentEvent.getSource() == this.bright) {
            nArray[0] = this.hue.getValue();
            nArray[1] = this.sat.getValue();
            nArray[2] = this.bright.getValue();
            Color color = Color.getHSBColor((float)((double)nArray[0] / 255.0), (float)((double)nArray[1] / 255.0), (float)((double)nArray[2] / 255.0));
            this.setValue(color);
        }
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        Vector vector;
        if (object != null && object.equals(object2)) {
            return;
        }
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners == null) {
                Object var6_5 = null;
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        serializable = new JCPropertyChangeEvent(this, string, object, object2);
        int n = 0;
        while (n < vector.size()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(n);
            propertyChangeListener.propertyChange((PropertyChangeEvent)serializable);
            ++n;
        }
    }

    public String getAsText() {
        return this.getJavaInitializationString();
    }

    private String getColorName(Color color) {
        if (color == null) {
            return INHERIT_STRING;
        }
        if (color.equals(Color.black)) {
            return "Black";
        }
        if (color.equals(Color.blue)) {
            return "Blue";
        }
        if (color.equals(Color.cyan)) {
            return "Cyan";
        }
        if (color.equals(Color.darkGray)) {
            return "darkGray";
        }
        if (color.equals(Color.gray)) {
            return "Gray";
        }
        if (color.equals(Color.green)) {
            return "Green";
        }
        if (color.equals(Color.lightGray)) {
            return "lightGray";
        }
        if (color.equals(Color.magenta)) {
            return "Magenta";
        }
        if (color.equals(Color.orange)) {
            return "Orange";
        }
        if (color.equals(Color.pink)) {
            return "Pink";
        }
        if (color.equals(Color.red)) {
            return "Red";
        }
        if (color.equals(Color.white)) {
            return "White";
        }
        if (color.equals(Color.yellow)) {
            return "Yellow";
        }
        return color.getRed() + "-" + color.getGreen() + "-" + color.getBlue();
    }

    public Component getCustomEditor() {
        return null;
    }

    public String getJavaInitializationString() {
        Color color = (Color)this.getValue();
        return "new Color(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.theColor;
    }

    public boolean isPaintable() {
        return true;
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getStateChange() == 2) {
            return;
        }
        JCList jCList = (JCList)jCItemEvent.getSource();
        this.setValue(JCUtilConverter.toColor((String)jCItemEvent.getItem()));
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        graphics.setColor((Color)this.getValue());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        if (propertyChangeListener == null) {
            int n = this.listeners.size() - 1;
            while (n >= 0) {
                this.listeners.removeElementAt(n);
                --n;
            }
            this.listeners = null;
        } else {
            this.listeners.removeElement(propertyChangeListener);
        }
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public void setBackground(Color color) {
        if (this.field != null) {
            this.field.setBackground(color);
        }
    }

    private void setToList(JCList jCList, String string) {
        boolean bl = false;
        if (string == null) {
            return;
        }
        String[] stringArray = jCList.getItemsStrings();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string)) {
                if (jCList.getSelectedIndex() != n) {
                    jCList.select(n);
                }
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            jCList.addItem(string, 0);
            jCList.select(string);
        }
    }

    public void setValue(Object object) {
        if (object == null) {
            this.theColor = (Color)object;
            this.field.setText(INHERIT_STRING);
        } else if (object instanceof String) {
            String string = (String)object;
            Color color = JCUtilConverter.toColor(string);
            this.setValue(color);
        } else if (object instanceof Color) {
            if (this.theColor != null && this.theColor.equals((Color)object)) {
                return;
            }
            this.theColor = (Color)object;
            String string = this.getColorName(this.theColor);
            if (!this.field.getText().equals(string)) {
                this.field.setText(string);
            }
            if (this.colorList.getSelectedItem() != string) {
                this.colorList.select(string);
            }
            if (!this.theColor.equals(this.swatch.getBackground())) {
                this.swatch.setBackground(this.theColor);
            }
            int[] nArray = new int[]{this.theColor.getRed(), this.theColor.getGreen(), this.theColor.getBlue()};
            this.red.setValue(nArray[0]);
            this.redVal.setText(Integer.toString(nArray[0]));
            this.green.setValue(nArray[1]);
            this.greenVal.setText(Integer.toString(nArray[1]));
            this.blue.setValue(nArray[2]);
            this.blueVal.setText(Integer.toString(nArray[2]));
            float[] fArray = Color.RGBtoHSB(nArray[0], nArray[1], nArray[2], null);
            this.hue.setValue((int)(fArray[0] * 255.0f));
            this.hueVal.setText(JCChartUtil.format(fArray[0], 3));
            this.sat.setValue((int)(fArray[1] * 255.0f));
            this.satVal.setText(JCChartUtil.format(fArray[1], 3));
            this.bright.setValue((int)(fArray[2] * 255.0f));
            this.brightVal.setText(JCChartUtil.format(fArray[2], 3));
        }
    }

    public boolean supportsCustomEditor() {
        return false;
    }
}

