/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.Serializable;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButton;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCContainer;
import jclass.bwt.JCGridLayout;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.chart.AxesOrientationImages;
import jclass.chart.ChartDataView;
import jclass.chart.JCCustomizerPage;
import jclass.chart.customizer.JCAddRemoveDialog;
import jclass.chart.customizer.JCBooleanEditor;
import jclass.chart.customizer.JCPropertyPage;
import jclass.chart.customizer.TestChart;
import jclass.util.JCString;

public class AxisOrientPage
extends JCPropertyPage
implements JCActionListener,
JCItemListener {
    JCBooleanEditor isInvertedCheck;
    JCCheckboxGroup orientBox;
    JCButton xAxisButton;
    JCButton yAxisButton;
    JCAddRemoveDialog dialog;
    ChartDataView target;

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (this.target == null) {
            return;
        }
        if (jCActionEvent.getSource() instanceof JCButton) {
            JCButton jCButton = (JCButton)jCActionEvent.getSource();
            if (this.dialog == null) {
                try {
                    this.dialog = (JCAddRemoveDialog)this.getFramedPage("JCAxisDialog");
                }
                catch (Throwable throwable) {
                    this.dialog = null;
                }
                if (this.dialog == null) {
                    JCCustomizerPage.showError("JCAxisDialog not implemented.");
                    jCButton.disable();
                } else {
                    this.dialog.addButton.setText("Attach");
                    this.dialog.addPropertyChangeListener(this);
                }
            }
            if (this.dialog != null) {
                Frame frame = JCPropertyPage.getFrame(this.dialog);
                if (jCButton == this.xAxisButton) {
                    this.dialog.setObject(this.target.getXAxis());
                    frame.setTitle("Edit View X Axis");
                } else if (jCButton == this.yAxisButton) {
                    this.dialog.setObject(this.target.getYAxis());
                    frame.setTitle("Edit View Y Axis");
                }
                frame.show();
                frame.toFront();
            }
        }
    }

    static Image getEnabledOrientationImage(Component component, int n) {
        return AxesOrientationImages.getOrientationImage(component, n, AxesOrientationImages.ENABLED);
    }

    static Image getEnabledOrientationImage(Component component, ChartDataView chartDataView) {
        return AxesOrientationImages.getOrientationImage(component, chartDataView, AxesOrientationImages.ENABLED);
    }

    public Object getObject() {
        return this.target;
    }

    public static String getPageName() {
        return "AxisOrientPage";
    }

    public static String getPageTitle() {
        return "Chart Axis Orientation Property Pages";
    }

    public void init() {
        Serializable serializable;
        super.init();
        JCContainer jCContainer = new JCContainer();
        jCContainer.setLayout(new JCGridLayout(1, 2));
        JCContainer jCContainer2 = new JCContainer();
        jCContainer2.setLayout(new JCGridLayout(2, 1));
        JCContainer jCContainer3 = new JCContainer();
        jCContainer3.setLayout(new GridLayout(1, 2));
        jCContainer3.add(new JCLabel(""));
        this.isInvertedCheck = new JCBooleanEditor("Inverted");
        this.isInvertedCheck.addPropertyChangeListener(this);
        jCContainer3.add(this.isInvertedCheck);
        jCContainer2.add(jCContainer3);
        int n = AxesOrientationImages.getOrientationImageLength();
        Object[] objectArray = new Object[n];
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            serializable = new JCString("");
            ((JCString)serializable).add(AxesOrientationImages.getOrientationImage((Component)this, n2, AxesOrientationImages.ENABLED));
            objectArray[n2] = serializable;
            nArray[n2] = n2;
            ++n2;
        }
        this.orientBox = JCCheckbox.makeGroup(objectArray, nArray, true);
        this.orientBox.setTitle("Axis Direction");
        this.orientBox.setLayout(new GridLayout(4, 2));
        this.orientBox.addItemListener(this);
        jCContainer2.add(this.orientBox);
        jCContainer.add(jCContainer2);
        serializable = new JCContainer();
        ((JCContainer)serializable).setInsets(new Insets(30, 5, 5, 2));
        ((Container)serializable).setLayout(new JCGridLayout(2, 1));
        this.xAxisButton = new JCButton("Edit X Axis...");
        this.xAxisButton.addActionListener(this);
        ((JCContainer)serializable).add(this.xAxisButton);
        this.yAxisButton = new JCButton("Edit Y Axis...");
        this.yAxisButton.addActionListener(this);
        ((JCContainer)serializable).add(this.yAxisButton);
        jCContainer.add((Component)serializable);
        this.add(jCContainer);
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getSource() instanceof JCCheckbox) {
            boolean bl;
            JCCheckbox jCCheckbox = (JCCheckbox)jCItemEvent.getSource();
            if (jCCheckbox == null || this.target == null) {
                return;
            }
            boolean bl2 = bl = jCCheckbox.getState() != 0;
            if (!bl) {
                return;
            }
            if (jCCheckbox.getCheckboxGroup() == this.orientBox) {
                int n = jCCheckbox.getUserDataInt();
                boolean bl3 = (n & 1) == 1;
                boolean bl4 = (n & 4) == 4;
                boolean bl5 = (n & 2) == 2;
                ChartDataView chartDataView = this.target;
                chartDataView.setIsBatched(true);
                if (bl3) {
                    chartDataView.getXAxis().setIsReversed(bl4);
                    chartDataView.getYAxis().setIsReversed(bl5);
                } else {
                    chartDataView.getYAxis().setIsReversed(bl4);
                    chartDataView.getXAxis().setIsReversed(bl5);
                }
                chartDataView.setIsBatched(false);
                this.setObject();
            } else {
                System.out.println("Unknown Checkbox: " + jCCheckbox.getText() + ": " + bl);
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = AxisOrientPage.getPageName();
        JCPropertyPage jCPropertyPage = JCPropertyPage.getPage(string);
        jCPropertyPage.init();
        jCPropertyPage.launch();
        Frame frame = JCPropertyPage.getFrame(jCPropertyPage);
        frame.setTitle(AxisOrientPage.getPageTitle());
        jCPropertyPage.setObject(new TestChart());
    }

    public void propertyChanged(Object object, Object object2) {
        if (this.target == null || object2 == null) {
            return;
        }
        if (object == this.isInvertedCheck) {
            boolean bl = (Boolean)object2;
            this.target.setIsInverted(bl);
            this.setObject();
        } else if (object == this.dialog) {
            ((Component)JCPropertyPage.getFrame(this.dialog)).hide();
        }
    }

    public void setObject(Object object) {
        if (object instanceof ChartDataView) {
            this.target = (ChartDataView)object;
            boolean bl = this.target.getIsInverted();
            this.isInvertedCheck.setValue(new Boolean(bl));
            this.setViewOrient(this.target);
        }
    }

    void setViewOrient(ChartDataView chartDataView) {
        this.orientBox.setValue(AxesOrientationImages.viewToValue(chartDataView));
        int n = chartDataView.getIsInverted() ? 1 : 0;
        int n2 = 0;
        while (n2 < this.orientBox.numCheckboxes()) {
            int n3 = 0;
            while (n3 < 2) {
                JCCheckbox jCCheckbox = this.orientBox.getCheckbox(n2 + n3);
                if (n == n3) {
                    jCCheckbox.setLabel(AxesOrientationImages.getOrientationImage((Component)this, n2 + n3, AxesOrientationImages.ENABLED));
                    jCCheckbox.enable();
                } else {
                    jCCheckbox.setLabel(AxesOrientationImages.getOrientationImage((Component)this, n2 + n3, AxesOrientationImages.DISABLED));
                    jCCheckbox.disable();
                }
                ++n3;
            }
            ++n2;
            ++n2;
        }
    }
}

