/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.Serializable;
import javax.swing.JComponent;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCContainer;
import jclass.bwt.JCGridLayout;
import jclass.bwt.JCGroupBox;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.bwt.JCTextField;
import jclass.chart.JCAxis;
import jclass.chart.customizer.JCPropertyPage;
import jclass.chart.customizer.LineStylePage;

public class AxisGridPage
extends JCPropertyPage
implements JCActionListener,
JCItemListener {
    JCCheckbox showGridCheck = null;
    JCTextField gridField = null;
    JCCheckbox gridDefault = null;
    LineStylePage stylePage = null;
    JCAxis target;

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (this.target == null) {
            return;
        }
        if (jCActionEvent.getSource() instanceof JCTextField) {
            JCTextField jCTextField = (JCTextField)jCActionEvent.getSource();
            if (jCTextField == this.gridField) {
                Double d = new Double(jCTextField.getText());
                this.target.setGridSpacing(d);
            } else {
                System.out.println("Unknown Field: " + jCTextField);
            }
        }
    }

    public void init() {
        super.init();
        this.setLayout(new JCGridLayout(2, 1));
        JCContainer jCContainer = new JCContainer();
        jCContainer.setLayout(new JCAlignerLayout(3, 1, 1));
        jCContainer.add(new JCLabel("Show Grid:"));
        this.showGridCheck = new JCCheckbox("");
        this.showGridCheck.addItemListener(this);
        jCContainer.add(this.showGridCheck);
        jCContainer.add(new JCLabel(""));
        jCContainer.add(new JCLabel("Grid Spacing:"));
        this.gridField = new JCTextField("", 9);
        this.gridField.addActionListener(this);
        this.gridField.setBackground(JCPropertyPage.textBG);
        jCContainer.add(this.gridField);
        this.gridDefault = new JCCheckbox("isDefault");
        this.gridDefault.addItemListener(this);
        jCContainer.add(this.gridDefault);
        this.add(jCContainer);
        JCContainer jCContainer2 = new JCContainer();
        JCGroupBox jCGroupBox = new JCGroupBox("Grid Style");
        jCGroupBox.setLayout(new JCGridLayout(1, 1));
        this.stylePage = new LineStylePage();
        this.stylePage.init();
        jCGroupBox.add(this.stylePage);
        jCContainer2.add(jCGroupBox);
        this.add(jCContainer2);
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (this.target == null) {
            return;
        }
        if (jCItemEvent.getSource() instanceof JCCheckbox) {
            boolean bl;
            JCCheckbox jCCheckbox = (JCCheckbox)jCItemEvent.getSource();
            if (jCCheckbox == null) {
                return;
            }
            boolean bl2 = bl = jCCheckbox.getState() != 0;
            if (jCCheckbox == this.showGridCheck) {
                this.target.setGridIsShowing(bl);
            } else if (jCCheckbox == this.gridDefault) {
                this.target.setGridSpacingIsDefault(bl);
            } else {
                System.out.println("Unknown Checkbox: " + jCCheckbox.getText() + ": " + bl);
            }
            this.setObject(this.target);
        }
    }

    public static void main(String[] stringArray) {
        Frame frame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.demos.DemoFrame");
            frame = (Frame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            frame = new Frame();
        }
        frame.setTitle("Chart Axis Property Page");
        serializable = new AxisGridPage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((AxisGridPage)serializable).init();
        frame.add((Component)serializable);
        frame.pack();
        Dimension dimension = ((Container)serializable).preferredSize();
        frame.resize(dimension.width + 10, dimension.height + 30);
        frame.show();
    }

    public void setObject(Object object) {
        if (object instanceof JCAxis) {
            this.target = (JCAxis)object;
            boolean bl = this.target.getGridIsShowing();
            this.showGridCheck.setState(bl ? 1 : 0);
            Double d = new Double(this.target.getGridSpacing());
            this.gridField.setText(d.toString());
            bl = this.target.getGridSpacingIsDefault();
            this.gridDefault.setState(bl ? 1 : 0);
            if (bl) {
                this.gridField.disable();
            } else {
                this.gridField.enable();
            }
            this.stylePage.setObject(this.target.getGridStyle());
        }
    }
}

