/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCContainer;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.chart.ChartDataView;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.JCCustomizerPage;
import jclass.chart.customizer.AxisPlacementPage;
import jclass.chart.customizer.AxisRelationPage;
import jclass.chart.customizer.JCPropertyPage;
import jclass.chart.customizer.TestChart;
import jclass.chart.customizer.ViewAxisPage;

public class AxisAttachPage
extends JCPropertyPage
implements JCItemListener {
    private JCCheckboxGroup attachGroup;
    private JCContainer attachCards;
    private JCCheckbox attachViewToggle = null;
    private JCCheckbox attachAxisToggle = null;
    private JCCheckbox attachValueToggle = null;
    private ViewAxisPage viewGroup;
    private AxisRelationPage relationGroup;
    private AxisPlacementPage placementGroup;
    private CardLayout card_layout;
    JCChart chart;
    JCAxis target;

    public JCAxis attachAxis() {
        JCAxis jCAxis = (JCAxis)this.getObject();
        if (jCAxis == null) {
            return null;
        }
        if (this.attachViewToggle.getState() > 0) {
            ChartDataView chartDataView = (ChartDataView)this.viewGroup.viewCombo.getValue();
            if (chartDataView != null) {
                if (this.viewGroup.xCheck.getState() > 0) {
                    jCAxis.setIsVertical(chartDataView.getXAxis().getIsVertical());
                    chartDataView.setXAxis(jCAxis);
                    return jCAxis;
                }
                if (this.viewGroup.yCheck.getState() > 0) {
                    jCAxis.setIsVertical(chartDataView.getYAxis().getIsVertical());
                    chartDataView.setYAxis(jCAxis);
                    return jCAxis;
                }
            } else {
                JCCustomizerPage.showError("No DataView to attach axis to.");
            }
        } else if (this.attachAxisToggle.getState() > 0) {
            JCAxis jCAxis2 = (JCAxis)this.relationGroup.axisRelCombo.getValue();
            Double d = (Double)this.relationGroup.multiplierField.getValue();
            Double d2 = (Double)this.relationGroup.constantField.getValue();
            if (jCAxis2 != null && d != null && d2 != null) {
                jCAxis.setIsVertical(jCAxis2.getIsVertical());
                jCAxis.getFormula().setOriginator(jCAxis2);
                jCAxis.getFormula().setMultiplier(d);
                jCAxis.getFormula().setConstant(d2);
                return jCAxis;
            }
            JCCustomizerPage.showError("Axis relationship not specifed.");
        } else if (this.attachValueToggle.getState() > 0) {
            Object object = this.placementGroup.placementField.getValue();
            Object object2 = this.placementGroup.axisValCombo.getValue();
            if (object2 instanceof JCAxis && object instanceof Double) {
                jCAxis.setIsVertical(((JCAxis)object2).getIsVertical() ^ true);
                jCAxis.setPlacement((JCAxis)object2, (Double)object);
                return jCAxis;
            }
            JCCustomizerPage.showError("Axis Placement and value not specifed.");
        }
        return null;
    }

    public Object getObject() {
        return this.target;
    }

    public static String getPageName() {
        return "AxisAttachPage";
    }

    public static String getPageTitle() {
        return "Chart Axis Attachment Property Page";
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.attachGroup = new JCCheckboxGroup("Attach Axis to");
        this.attachGroup.setLayout(new GridLayout(1, 3));
        this.attachViewToggle = new JCCheckbox("View");
        this.attachViewToggle.addItemListener(this);
        this.attachGroup.add(this.attachViewToggle);
        this.attachAxisToggle = new JCCheckbox("Axis Relationship");
        this.attachAxisToggle.addItemListener(this);
        this.attachGroup.add(this.attachAxisToggle);
        this.attachValueToggle = new JCCheckbox("Axis Placement");
        this.attachValueToggle.addItemListener(this);
        this.attachGroup.add(this.attachValueToggle);
        this.add("North", this.attachGroup);
        this.attachCards = new JCContainer();
        this.add(this.attachCards);
        this.card_layout = new CardLayout();
        this.attachCards.setLayout(this.card_layout);
        this.viewGroup = new ViewAxisPage();
        this.viewGroup.init();
        this.relationGroup = new AxisRelationPage();
        this.relationGroup.init();
        this.placementGroup = new AxisPlacementPage();
        this.placementGroup.init();
        this.attachCards.add("View", this.viewGroup);
        this.attachCards.add("Relation", this.relationGroup);
        this.attachCards.add("Placement", this.placementGroup);
        this.add("Center", this.attachCards);
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getSource() instanceof JCCheckbox) {
            boolean bl;
            JCCheckbox jCCheckbox = (JCCheckbox)jCItemEvent.getSource();
            if (jCCheckbox == null) {
                return;
            }
            boolean bl2 = bl = jCCheckbox.getState() != 0;
            if (!bl) {
                return;
            }
            if (jCCheckbox == this.attachValueToggle) {
                this.card_layout.show(this.attachCards, "Placement");
                this.placementGroup.setObject(this.target);
                this.placementGroup.setObject(this.chart);
            } else if (jCCheckbox == this.attachAxisToggle) {
                this.card_layout.show(this.attachCards, "Relation");
                this.relationGroup.setObject(this.target);
                this.relationGroup.setObject(this.chart);
            } else {
                this.card_layout.show(this.attachCards, "View");
                this.viewGroup.setObject(this.target);
                this.viewGroup.setObject(this.chart);
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = AxisAttachPage.getPageName();
        JCPropertyPage jCPropertyPage = JCPropertyPage.getPage(string);
        jCPropertyPage.init();
        jCPropertyPage.launch();
        Frame frame = JCPropertyPage.getFrame(jCPropertyPage);
        frame.setTitle(AxisAttachPage.getPageTitle());
        jCPropertyPage.setObject(new TestChart());
    }

    public void setModel(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof JCChart) {
            this.chart = (JCChart)object;
        }
    }

    public void setObject(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof JCAxis) {
            this.target = (JCAxis)object;
            if (this.target.getFormula().getOriginator() != null) {
                this.attachAxisToggle.setState(1, true);
            } else if (this.target.getPlacementAxis() != null) {
                this.attachValueToggle.setState(1, true);
            } else {
                this.attachViewToggle.setState(1, true);
            }
        }
    }
}

