/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.bean;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import jclass.beans.LiteComponent;
import jclass.chart.JCChartBundle;
import jclass.chart.JCVersion;

public abstract class BaseEditor
extends Panel
implements PropertyEditor {
    private LiteComponent lite;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    Object valueObj = null;

    public BaseEditor() {
        this.init();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public String getAsText() {
        return "Click to edit...";
    }

    public Component getCustomEditor() {
        return this;
    }

    public String getJavaInitializationString() {
        return "\"" + this.valueObj + "\"";
    }

    protected String getLiteMessage() {
        return JCChartBundle.string("jclass.chart.Key253");
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.valueObj;
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        Panel panel = this.makePropertyPanel();
        if (panel != null) {
            this.add("Center", panel);
        }
        String string = this.getLiteMessage();
        this.lite = new LiteComponent(String.valueOf(JCVersion.getVersionString()) + (string != null ? " : " : ""), string, true);
        this.add("South", this.lite);
    }

    public boolean isPaintable() {
        return true;
    }

    protected abstract Panel makePropertyPanel();

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = JCChartBundle.string("jclass.chart.Key163");
        if (string == null) {
            string = new String("");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n);
    }

    public Dimension preferredSize() {
        Dimension dimension = new Dimension(200, 0);
        dimension.width = 350;
        dimension.height = 100;
        return dimension;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    public void setValue(Object object) {
        this.valueObj = object;
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

