/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Vector;
import jclass.chart.CachedSeriesProps;
import jclass.chart.CachedViewProps;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartRegion;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCCandleChartFormat;
import jclass.chart.JCChart;
import jclass.chart.JCChartBundle;
import jclass.chart.JCChartStyle;
import jclass.chart.JCDataIndex;
import jclass.chart.JCGridLegend;
import jclass.chart.JCLegendItem;
import jclass.chart.PieChartInfo;
import jclass.chart.PieData;
import jclass.util.JCString;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;

public abstract class JCLegend
extends ChartRegion
implements HTMLHandler {
    int anchor = 1;
    int orientation = 1;
    public static final int NORTH = 16;
    public static final int SOUTH = 32;
    public static final int EAST = 1;
    public static final int WEST = 2;
    public static final int NORTHEAST = 17;
    public static final int NORTHWEST = 18;
    public static final int SOUTHEAST = 33;
    public static final int SOUTHWEST = 34;
    public static final int NORTHSOUTH_MASK = 240;
    public static final int EASTWEST_MASK = 15;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final String[] anchor_strings = new String[]{"Northeast", "North", "Northwest", "East", "West", "Southeast", "South", "Southwest"};
    public static final int[] anchor_values = new int[]{17, 16, 18, 1, 2, 33, 32, 34};
    public static final String[] orientation_strings = new String[]{"Horizontal", "Vertical"};
    public static final int[] orientation_values;
    public static final String[] border_strings;
    public static final int[] border_values;
    JCVector legendItems = null;
    Dimension ps = new Dimension();
    int symbolSize = 8;
    int ascent = 0;
    int descent = 0;
    boolean cachedVertical = false;
    transient Font cachedFont;
    transient CachedViewProps[] cachedView = null;

    static {
        int[] nArray = new int[2];
        nArray[1] = 1;
        orientation_values = nArray;
        border_strings = new String[]{"None", "Etched_In", "Etched_Out", "In", "Out", "Plain", "Frame_In", "Frame_Out", "Control_In", "Control_Out"};
        int[] nArray2 = new int[10];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        nArray2[6] = 6;
        nArray2[7] = 7;
        nArray2[8] = 8;
        nArray2[9] = 9;
        border_values = nArray2;
    }

    public JCLegend() {
        this.transparent = false;
        this.isShowing = false;
    }

    void cacheViewProperties(CachedViewProps cachedViewProps, ChartDataView chartDataView, ChartDataViewSeries[] chartDataViewSeriesArray) {
        cachedViewProps.view = chartDataView;
        cachedViewProps.isShowing = chartDataView.getIsShowing();
        cachedViewProps.isShowingInLegend = chartDataView.getIsShowingInLegend();
        cachedViewProps.chartType = chartDataView.getChartType();
        cachedViewProps.seriesPerData = chartDataView.getNumSeriesPerData();
        cachedViewProps.inverted = chartDataView.xaxis.isVertical;
        if (chartDataViewSeriesArray == null) {
            cachedViewProps.seriesList = null;
            cachedViewProps.seriesProps = null;
            return;
        }
        cachedViewProps.seriesList = chartDataViewSeriesArray;
        cachedViewProps.seriesProps = new CachedSeriesProps[chartDataViewSeriesArray.length];
        int n = 0;
        while (n < chartDataViewSeriesArray.length) {
            cachedViewProps.seriesProps[n] = new CachedSeriesProps();
            cachedViewProps.seriesProps[n].series = chartDataViewSeriesArray[n];
            cachedViewProps.seriesProps[n].isShowing = chartDataViewSeriesArray[n].getIsShowing();
            cachedViewProps.seriesProps[n].isShowingInLegend = chartDataViewSeriesArray[n].getIsShowingInLegend();
            ++n;
        }
    }

    public void draw(Graphics graphics) {
        if (!this.isShowing) {
            return;
        }
        if (graphics == null) {
            return;
        }
        JCChart jCChart = this.getParent();
        if (jCChart == null || this.cachedView == null) {
            return;
        }
        Object object = this.getRegionLock();
        synchronized (object) {
            boolean bl = false;
            Rectangle rectangle = this.getDrawingArea();
            if (!bl) {
                bl = true;
                graphics = graphics.create();
                super.draw(graphics);
                graphics.translate(rectangle.x, rectangle.y);
                graphics.clipRect(0, 0, rectangle.width + 1, rectangle.height + 1);
            }
            boolean bl2 = this.cachedVertical;
            int n = 0;
            while (n < this.legendItems.size()) {
                JCVector jCVector = (JCVector)this.legendItems.elementAt(n);
                int n2 = 0;
                while (n2 < jCVector.size()) {
                    JCLegendItem jCLegendItem = (JCLegendItem)jCVector.elementAt(n2);
                    this.drawLegendItem(graphics, jCChart, this.cachedFont, jCLegendItem);
                    ++n2;
                }
                ++n;
            }
            if (bl) {
                graphics.dispose();
            }
        }
        this.setChanged(false, 0);
    }

    public void drawLegendItem(Graphics graphics, JCChart jCChart, Font font, JCLegendItem jCLegendItem) {
        block44: {
            block46: {
                int n;
                int n2;
                int n3;
                block45: {
                    boolean bl;
                    boolean bl2;
                    boolean bl3;
                    boolean bl4;
                    boolean bl5;
                    CachedViewProps cachedViewProps;
                    block43: {
                        cachedViewProps = null;
                        bl5 = false;
                        n3 = 0;
                        bl4 = true;
                        bl3 = true;
                        bl2 = false;
                        bl = false;
                        if (jCLegendItem.view != null) {
                            int n4 = 0;
                            while (n4 < this.cachedView.length) {
                                if (this.cachedView[n4].view == jCLegendItem.view) {
                                    cachedViewProps = this.cachedView[n4];
                                    bl5 = cachedViewProps.inverted;
                                    n3 = cachedViewProps.chartType;
                                    bl4 = true;
                                    bl3 = true;
                                    bl2 = false;
                                    if (n3 == 6) {
                                        bl4 = jCLegendItem.view.getHLOCChartFormat().getIsShowingOpen();
                                        bl3 = jCLegendItem.view.getHLOCChartFormat().getIsShowingClose();
                                        bl2 = jCLegendItem.view.getHLOCChartFormat().getIsOpenCloseFullWidth();
                                    }
                                    if (n3 != 7) break;
                                    bl = jCLegendItem.view.getCandleChartFormat().getIsComplex();
                                    break;
                                }
                                ++n4;
                            }
                        }
                        if (graphics.getColor() != this.getForeground()) {
                            graphics.setColor(this.getForeground());
                        }
                        if (graphics.getFont() != this.cachedFont) {
                            graphics.setFont(this.cachedFont);
                        }
                        if (!this.isTitleItem(jCLegendItem)) break block43;
                        if (jCLegendItem.contents instanceof String) {
                            graphics.drawString((String)jCLegendItem.contents, jCLegendItem.pos.x + jCLegendItem.textPos.x, jCLegendItem.pos.y + jCLegendItem.textPos.y + this.ascent);
                        } else if (jCLegendItem.contents instanceof JCString) {
                            JCString jCString = (JCString)jCLegendItem.contents;
                            jCString.draw(jCChart, graphics, new Rectangle(jCLegendItem.pos.x + jCLegendItem.textPos.x, jCLegendItem.pos.y + jCLegendItem.textPos.y, jCLegendItem.textDim.width, jCLegendItem.textDim.height), 0);
                        }
                        break block44;
                    }
                    Object var12_14 = null;
                    Object var13_15 = null;
                    n2 = jCLegendItem.pos.x + jCLegendItem.symbolPos.x;
                    n = jCLegendItem.pos.y + jCLegendItem.symbolPos.y;
                    int n5 = Math.min(jCLegendItem.symbolDim.width, jCLegendItem.symbolDim.height);
                    if (jCLegendItem.series == null) break block45;
                    JCChartStyle jCChartStyle = jCLegendItem.series.getStyle();
                    switch (jCLegendItem.view.getChartType()) {
                        case 0: {
                            jCChartStyle.getLineStyle().draw(graphics, n2, n + jCLegendItem.symbolDim.height / 2, n2 + jCLegendItem.symbolDim.width - 1, n + jCLegendItem.symbolDim.height / 2);
                        }
                        case 1: {
                            jCChartStyle.getSymbolStyle().draw(graphics, n2 + jCLegendItem.symbolDim.width / 2, n + jCLegendItem.symbolDim.height / 2, jCLegendItem.symbolDim.width);
                            break;
                        }
                        case 9: 
                        case 10: {
                            if (jCLegendItem.symbol != null && jCLegendItem.symbol instanceof Image) {
                                graphics.drawImage((Image)jCLegendItem.symbol, n2, n, null);
                                break;
                            }
                        }
                        case 8: 
                        case 11: 
                        case 12: {
                            jCChartStyle.getFillStyle().fillOutlineRect(graphics, n2, n, jCLegendItem.symbolDim.width - 1, jCLegendItem.symbolDim.height - 1, jCChart.chartArea.getForeground());
                            break;
                        }
                        case 5: 
                        case 6: {
                            int n6;
                            int n7;
                            int n8;
                            int n9;
                            if (bl5) {
                                n9 = n2;
                                n8 = n2 + (jCLegendItem.symbolDim.width - 1);
                                n6 = n7 = n + n5 / 2;
                            } else {
                                n9 = n8 = n2 + jCLegendItem.symbolDim.width / 2;
                                n6 = n;
                                n7 = n + n5;
                            }
                            jCChartStyle.getLineStyle().draw(graphics, n9, n6, n8, n7);
                            if (n3 != 5) {
                                if (bl4) {
                                    if (bl5) {
                                        n9 = n8 = n2 + 2;
                                        n6 = n + 1;
                                        n7 = bl2 ? n + n5 - 2 : n + n5 / 2;
                                    } else {
                                        n9 = n2 + 2;
                                        n8 = bl2 ? n2 - 3 + jCLegendItem.symbolDim.width : n2 + jCLegendItem.symbolDim.width / 2;
                                        n6 = n7 = n + (int)Math.round(2.0 * (double)n5 / 3.0);
                                    }
                                    jCChartStyle.getLineStyle().draw(graphics, n9, n6, n8, n7);
                                }
                                if (bl3) {
                                    if (bl5) {
                                        n9 = n8 = n2 - 3 + jCLegendItem.symbolDim.width;
                                        n6 = bl2 ? n + 1 : n + n5 / 2;
                                        n7 = n + n5 - 2;
                                    } else {
                                        n9 = bl2 ? n2 + 2 : n2 + jCLegendItem.symbolDim.width / 2;
                                        n8 = n2 - 3 + jCLegendItem.symbolDim.width;
                                        n6 = n7 = n + n5 / 3;
                                    }
                                    jCChartStyle.getLineStyle().draw(graphics, n9, n6, n8, n7);
                                    break;
                                }
                            }
                            break block46;
                        }
                        case 7: {
                            int n10;
                            int n11;
                            int n12;
                            int n13;
                            int n14;
                            int n15 = n14 = jCLegendItem.symbolDim.width % 2 == 0 ? jCLegendItem.symbolDim.width : jCLegendItem.symbolDim.width - 1;
                            if (bl5) {
                                n13 = n2;
                                n12 = n2 + 2;
                                n10 = n11 = n + n5 / 2;
                            } else {
                                n13 = n12 = n2 + n14 / 2;
                                n10 = n;
                                n11 = n + n5 / 3;
                            }
                            jCChartStyle.getLineStyle().draw(graphics, n13, n10, n12, n11);
                            if (bl5) {
                                n13 = n2 - 3 + n14;
                                n12 = n2 + (n14 - 1);
                                n10 = n11 = n + n5 / 2;
                            } else {
                                n13 = n12 = n2 + n14 / 2;
                                n10 = n + n5 * 2 / 3;
                                n11 = n + n5;
                            }
                            jCChartStyle.getLineStyle().draw(graphics, n13, n10, n12, n11);
                            if (bl5) {
                                n13 = n2 + 3;
                                n10 = n + 3;
                                n12 = n14 - 7;
                                n11 = n5 - 7;
                            } else {
                                n13 = n2 + 3;
                                n10 = n + n5 / 3;
                                n12 = n14 - 6;
                                n11 = (int)Math.round((double)n5 / 3.0);
                            }
                            JCChartStyle jCChartStyle2 = jCChartStyle;
                            JCChartStyle jCChartStyle3 = jCChartStyle;
                            if (bl) {
                                JCCandleChartFormat jCCandleChartFormat = jCLegendItem.view.getCandleChartFormat();
                                jCChartStyle2 = jCCandleChartFormat.getRisingCandleStyle(jCLegendItem.seriesIndex / cachedViewProps.seriesPerData);
                                jCChartStyle3 = jCCandleChartFormat.getCandleOutlineStyle(jCLegendItem.seriesIndex / cachedViewProps.seriesPerData);
                                jCChartStyle2.getFillStyle().fillRect(graphics, n13, n10, n12, n11);
                            }
                            jCChartStyle3.getLineStyle().drawRect(graphics, n13, n10, n12, n11);
                            break;
                        }
                        default: {
                            jCChartStyle.getLineStyle().draw(graphics, n2, n - jCLegendItem.symbolDim.height / 2, n2 + jCLegendItem.symbolDim.width, n - jCLegendItem.symbolDim.height / 2);
                            break;
                        }
                    }
                    break block46;
                }
                if (jCLegendItem.view != null) {
                    switch (n3) {
                        case 11: {
                            jCLegendItem.view.getPieChartFormat().getOtherStyle().getFillStyle().fillOutlineRect(graphics, n2, n, jCLegendItem.symbolDim.width - 1, jCLegendItem.symbolDim.height - 1, jCChart.chartArea.getForeground());
                            break;
                        }
                    }
                }
            }
            if (graphics.getColor() != this.getForeground()) {
                graphics.setColor(this.getForeground());
            }
            if (graphics.getFont() != this.cachedFont) {
                graphics.setFont(this.cachedFont);
            }
            if (jCLegendItem.contents instanceof JCString) {
                ((JCString)jCLegendItem.contents).draw(jCChart, graphics, new Rectangle(jCLegendItem.pos.x + jCLegendItem.textPos.x, jCLegendItem.pos.y + jCLegendItem.textPos.y, jCLegendItem.textDim.width, jCLegendItem.textDim.height), 0);
            } else if (jCLegendItem.contents instanceof String) {
                graphics.drawString((String)jCLegendItem.contents, jCLegendItem.pos.x + jCLegendItem.textPos.x, jCLegendItem.pos.y + jCLegendItem.textPos.y + this.ascent);
            }
        }
    }

    public int getAnchor() {
        return this.anchor;
    }

    public boolean getChanged() {
        JCChart jCChart = this.getParent();
        if (jCChart == null) {
            return super.getChanged();
        }
        int n = 0;
        while (n < jCChart.data.size()) {
            ChartDataView chartDataView = (ChartDataView)jCChart.data.elementAt(n);
            ++n;
        }
        return super.getChanged();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getSymbolSize() {
        return this.symbolSize;
    }

    public boolean isTitleItem(JCLegendItem jCLegendItem) {
        return jCLegendItem.series == null && jCLegendItem.symbolDim == null;
    }

    public abstract Dimension layoutLegend(JCVector var1, boolean var2, Font var3);

    public void loadParams(String string, JCChart jCChart) {
        this.setAnchor(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".anchor"), "legend anchor", anchor_strings, anchor_values, this.getAnchor()));
        this.setOrientation(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".orientation"), "legend orientation", orientation_strings, orientation_values, this.getOrientation()));
        super.loadParams(string, jCChart);
    }

    JCDataIndex pick(Point point, ChartDataView chartDataView) {
        Serializable serializable;
        Rectangle rectangle = this.getDrawingArea();
        point.x -= rectangle.x;
        point.y -= rectangle.y;
        JCDataIndex jCDataIndex = null;
        boolean bl = this.orientation == 1;
        JCLegendItem jCLegendItem = null;
        int n = 0;
        while (n < this.legendItems.size()) {
            serializable = (JCVector)this.legendItems.elementAt(n);
            int n2 = 0;
            while (n2 < ((Vector)serializable).size()) {
                JCLegendItem jCLegendItem2 = (JCLegendItem)((Vector)serializable).elementAt(n2);
                Rectangle rectangle2 = jCLegendItem2.pickRectangle;
                if (rectangle2 == null && jCLegendItem2.pos != null && jCLegendItem2.dim != null) {
                    rectangle2 = new Rectangle(jCLegendItem2.pos, jCLegendItem2.dim);
                }
                if (rectangle2 != null && rectangle2.inside(point.x, point.y)) {
                    jCLegendItem = jCLegendItem2;
                    break;
                }
                ++n2;
            }
            ++n;
        }
        jCDataIndex = new JCDataIndex(-1, null, -1);
        jCDataIndex.obj = this;
        serializable = this.getParent();
        if (serializable == null || jCLegendItem == null) {
            return jCDataIndex;
        }
        ChartDataView chartDataView2 = jCLegendItem.view;
        if (chartDataView != null && chartDataView2 != chartDataView) {
            return jCDataIndex;
        }
        jCDataIndex.dataView = chartDataView2;
        jCDataIndex.series = jCLegendItem.series;
        jCDataIndex.seriesIndex = jCLegendItem.seriesIndex;
        return jCDataIndex;
    }

    public Dimension preferredSize() {
        this.recalc();
        return new Dimension(this.ps);
    }

    public void recalc() {
        if (!this.isChanged(2)) {
            return;
        }
        this.ps = super.preferredSize();
        if (!this.isShowing) {
            this.setChanged(false, 0);
            return;
        }
        JCChart jCChart = this.getParent();
        if (jCChart == null) {
            return;
        }
        if (jCChart.getPeer() == null) {
            return;
        }
        Object object = this.getRegionLock();
        synchronized (object) {
            Cloneable cloneable;
            boolean bl;
            this.cachedVertical = bl = this.orientation == 1;
            this.legendItems = new JCVector();
            int n = 0;
            while (n < jCChart.data.size()) {
                this.legendItems.addElement(new JCVector());
                ++n;
            }
            this.cachedFont = this.getFont();
            if (this.cachedFont == null) {
                this.cachedFont = new Font("helvetica", 0, 12);
            }
            FontMetrics fontMetrics = null;
            try {
                fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.cachedFont);
            }
            catch (Exception exception) {}
            if (fontMetrics == null) {
                Object var3_6 = null;
                return;
            }
            this.descent = fontMetrics.getDescent();
            this.symbolSize = this.ascent = fontMetrics.getAscent();
            int n2 = jCChart.data.size();
            this.cachedView = new CachedViewProps[n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5;
                cloneable = (JCVector)this.legendItems.elementAt(n3);
                ChartDataView chartDataView = (ChartDataView)jCChart.data.elementAt(n3);
                ChartDataViewSeries[] chartDataViewSeriesArray = chartDataView.getSeries();
                this.cachedView[n3] = new CachedViewProps();
                this.cacheViewProperties(this.cachedView[n3], chartDataView, chartDataViewSeriesArray);
                chartDataView.calcTransientData();
                if (chartDataViewSeriesArray != null && (n5 = chartDataViewSeriesArray.length / (n4 = chartDataView.getNumSeriesPerData())) != 0) {
                    int n6 = chartDataView.getChartType();
                    if (chartDataView.getIsShowingInLegend()) {
                        Object object2;
                        int n7;
                        Object object3 = chartDataView.getRealName();
                        JCLegendItem[] jCLegendItemArray = chartDataView.getName();
                        JCLegendItem jCLegendItem = new JCLegendItem();
                        if (object3 == null) {
                            if (jCLegendItemArray != null && jCLegendItemArray.length() > 0) {
                                jCLegendItem.textDim = new Dimension(fontMetrics.stringWidth((String)jCLegendItemArray), fontMetrics.getHeight());
                                jCLegendItem.contents = jCLegendItemArray;
                            } else {
                                jCLegendItem.textDim = new Dimension(0, 0);
                                jCLegendItem.contents = null;
                            }
                        } else {
                            jCLegendItem.textDim = new Dimension(((JCString)object3).getWidth(jCChart, this.cachedFont), ((JCString)object3).getHeight(jCChart, this.cachedFont));
                            jCLegendItem.contents = object3;
                        }
                        jCLegendItem.view = chartDataView;
                        ((Vector)cloneable).addElement(jCLegendItem);
                        if (n6 == 11) {
                            object3 = (PieChartInfo)chartDataView.getTransientData();
                            if (object3 != null) {
                                jCLegendItemArray = new JCLegendItem[chartDataViewSeriesArray.length + 1];
                                int n8 = 0;
                                while (n8 < ((PieChartInfo)object3).num_pies) {
                                    PieData pieData = ((PieChartInfo)object3).data[n8];
                                    int n9 = 0;
                                    while (n9 < pieData.num_slices_pie) {
                                        Serializable serializable;
                                        if (n9 == pieData.other_slice) {
                                            if (jCLegendItemArray[chartDataViewSeriesArray.length] == null) {
                                                JCLegendItem jCLegendItem2 = new JCLegendItem();
                                                jCLegendItem2.seriesIndex = -10;
                                                jCLegendItem2.series = null;
                                                jCLegendItem2.view = chartDataView;
                                                serializable = chartDataView.getPieChartFormat().getRealOtherLabel();
                                                int n10 = 0;
                                                n7 = 0;
                                                if (serializable == null) {
                                                    String string = chartDataView.getPieChartFormat().getOtherLabel();
                                                    n7 = fontMetrics.stringWidth(string);
                                                    jCLegendItem2.contents = string;
                                                } else {
                                                    n7 = ((JCString)serializable).getWidth(jCChart, this.cachedFont);
                                                    n10 = ((JCString)serializable).getHeight(jCChart, this.cachedFont);
                                                    jCLegendItem2.contents = serializable;
                                                }
                                                if (n10 == 0) {
                                                    n10 = fontMetrics.getHeight();
                                                }
                                                jCLegendItem2.symbolDim = new Dimension(this.getSymbolSize(), this.getSymbolSize());
                                                jCLegendItem2.textDim = new Dimension(n7, n10);
                                                jCLegendItemArray[chartDataViewSeriesArray.length] = jCLegendItem2;
                                            }
                                        } else {
                                            int n11 = pieData.percents[n9].index;
                                            if (n11 >= 0 && jCLegendItemArray[n11] == null && chartDataViewSeriesArray[n11].isShowing && chartDataViewSeriesArray[n11].isShowingInLegend) {
                                                serializable = new JCLegendItem();
                                                ((JCLegendItem)serializable).seriesIndex = n11;
                                                ((JCLegendItem)serializable).series = chartDataViewSeriesArray[n11];
                                                ((JCLegendItem)serializable).view = chartDataView;
                                                JCString jCString = chartDataViewSeriesArray[n11].getRealLabel();
                                                n7 = 0;
                                                int n12 = 0;
                                                if (jCString == null) {
                                                    object2 = chartDataViewSeriesArray[n11].getLabel();
                                                    n12 = fontMetrics.stringWidth((String)object2);
                                                    ((JCLegendItem)serializable).contents = object2;
                                                } else {
                                                    n12 = jCString.getWidth(jCChart, this.cachedFont);
                                                    n7 = jCString.getHeight(jCChart, this.cachedFont);
                                                    ((JCLegendItem)serializable).contents = jCString;
                                                }
                                                if (n7 == 0) {
                                                    n7 = fontMetrics.getHeight();
                                                }
                                                ((JCLegendItem)serializable).symbolDim = new Dimension(this.getSymbolSize(), this.getSymbolSize());
                                                ((JCLegendItem)serializable).textDim = new Dimension(n12, n7);
                                                jCLegendItemArray[n11] = serializable;
                                            }
                                        }
                                        ++n9;
                                    }
                                    ++n8;
                                }
                                int n13 = 0;
                                while (n13 < jCLegendItemArray.length) {
                                    if (jCLegendItemArray[n13] != null) {
                                        ((Vector)cloneable).addElement(jCLegendItemArray[n13]);
                                    }
                                    ++n13;
                                }
                            }
                        } else {
                            int n14 = 0;
                            while (n14 < n5) {
                                int n15 = n14 * n4;
                                jCLegendItem = new JCLegendItem();
                                jCLegendItem.seriesIndex = n15;
                                jCLegendItem.series = chartDataViewSeriesArray[n15];
                                jCLegendItem.view = chartDataView;
                                JCString jCString = chartDataViewSeriesArray[n15].getRealLabel();
                                String string = null;
                                int n16 = 0;
                                int n17 = 0;
                                if (jCString == null) {
                                    string = chartDataViewSeriesArray[n15].getLabel();
                                    n17 = fontMetrics.stringWidth(string);
                                    jCLegendItem.contents = string;
                                } else {
                                    n17 = jCString.getWidth(jCChart, this.cachedFont);
                                    n16 = jCString.getHeight(jCChart, this.cachedFont);
                                    jCLegendItem.contents = jCString;
                                }
                                if (n16 == 0) {
                                    n16 = fontMetrics.getHeight();
                                }
                                boolean bl2 = true;
                                n7 = n15;
                                int n18 = 0;
                                while (n18 < n4) {
                                    if (!chartDataViewSeriesArray[n7].isShowing) {
                                        bl2 = false;
                                        break;
                                    }
                                    ++n18;
                                    ++n7;
                                }
                                if (bl2 && chartDataViewSeriesArray[n15].isShowingInLegend) {
                                    jCLegendItem.textDim = new Dimension(n17, n16);
                                    object2 = null;
                                    if ((n6 == 9 || n6 == 10) && (object2 = chartDataViewSeriesArray[n15].getStyle().getFillStyle().getImage()) != null) {
                                        jCLegendItem.symbolDim = new Dimension(((Image)object2).getWidth(null), ((Image)object2).getHeight(null));
                                        jCLegendItem.symbol = object2;
                                    } else {
                                        jCLegendItem.symbolDim = new Dimension(this.getSymbolSize(), this.getSymbolSize());
                                    }
                                    ((Vector)cloneable).addElement(jCLegendItem);
                                }
                                ++n14;
                            }
                        }
                    }
                }
                ++n3;
            }
            cloneable = this.layoutLegend(this.legendItems, bl, this.cachedFont);
            if (this.width.isDefault) {
                this.ps.width += ((Dimension)cloneable).width;
            }
            if (this.height.isDefault) {
                this.ps.height += ((Dimension)cloneable).height;
            }
            this.needsRepaint = true;
        }
        this.setChanged(false, 0);
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        super.saveParams(string, hTMLSaveDriver);
        JCGridLegend jCGridLegend = new JCGridLegend();
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isShowing", jCGridLegend.isShowing, this.isShowing);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".anchor", JCUtilConverter.fromEnum(jCGridLegend.anchor, anchor_strings, anchor_values), JCUtilConverter.fromEnum(this.anchor, anchor_strings, anchor_values));
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".orientation", JCUtilConverter.fromEnum(jCGridLegend.orientation, orientation_strings, orientation_values), JCUtilConverter.fromEnum(this.orientation, orientation_strings, orientation_values));
    }

    public void setAnchor(int n) {
        JCLegend jCLegend = this;
        synchronized (jCLegend) {
            if (n == this.anchor) {
                Object var3_3 = null;
                return;
            }
            switch (n) {
                case 1: 
                case 2: 
                case 16: 
                case 17: 
                case 18: 
                case 32: 
                case 33: 
                case 34: {
                    this.anchor = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key49"));
                }
            }
        }
        this.setChanged(true, 9);
    }

    public void setOrientation(int n) {
        JCLegend jCLegend = this;
        synchronized (jCLegend) {
            if (n == this.orientation) {
                Object var3_3 = null;
                return;
            }
            switch (n) {
                case 0: 
                case 1: {
                    this.orientation = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key72"));
                }
            }
        }
        this.setChanged(true, 2);
    }
}

