/*
 * Decompiled with CFR 0.152.
 */
package jclass.cell.renderers;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import jclass.cell.CellInfo;
import jclass.cell.CellRenderer;

public class EllipsisCellRenderer
implements CellRenderer {
    public void draw(Graphics graphics, CellInfo cellInfo, Object object, boolean bl) {
        if (object == null) {
            return;
        }
        String string = object.toString();
        if (string == null || string.length() == 0) {
            return;
        }
        FontMetrics fontMetrics = cellInfo.getFontMetrics();
        Rectangle rectangle = cellInfo.getDrawingArea();
        graphics.setFont(cellInfo.getFont());
        graphics.setColor(bl ? cellInfo.getSelectedForeground() : cellInfo.getForeground());
        int n = fontMetrics.stringWidth(string);
        int n2 = 0;
        int n3 = fontMetrics.getHeight() - 4;
        int n4 = cellInfo.getHorizontalAlignment();
        if (n4 == 2) {
            n2 += rectangle.width - fontMetrics.stringWidth(string);
        } else if (n4 == 1) {
            n2 += (rectangle.width - fontMetrics.stringWidth(string)) / 2;
        }
        n4 = cellInfo.getVerticalAlignment();
        if (n4 == 1) {
            n3 += (rectangle.height - fontMetrics.getHeight()) / 2;
        } else if (n4 == 2) {
            n3 += rectangle.height - fontMetrics.getHeight();
        }
        if (n < rectangle.width) {
            graphics.drawString(string, n2, n3);
        } else {
            String string2 = " ..";
            int n5 = string.length();
            while (fontMetrics.stringWidth(String.valueOf(string.substring(0, n5)) + string2) > rectangle.width && n5 > 0) {
                --n5;
            }
            graphics.drawString(String.valueOf(string.substring(0, n5)) + string2, n2, n3);
        }
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString();
        if (string == null || string.length() == 0) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = cellInfo.getFontMetrics();
        int n = cellInfo.getDrawingArea().width;
        return new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
    }
}

