/*
 * Decompiled with CFR 0.152.
 */
package jclass.cell.editors;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import jclass.cell.CellEditor;
import jclass.cell.CellEditorEvent;
import jclass.cell.CellEditorListener;
import jclass.cell.CellEditorSupport;
import jclass.cell.CellInfo;
import jclass.cell.InitialEvent;
import jclass.cell.KeyModifier;
import jclass.cell.Utilities;
import jclass.util.JCImageCreator;

public class ImageCellEditor
extends Canvas
implements CellEditor,
KeyListener,
MouseListener,
FocusListener {
    protected transient Image data;
    protected transient Image originalData;
    protected CellInfo cellInfo;
    protected CellEditorSupport support = new CellEditorSupport();
    protected boolean isFullSize = true;
    protected boolean modified = false;
    protected boolean inDialog = false;
    protected boolean initialEntry = false;
    protected boolean contextPending = false;
    protected transient byte[] dataBytes = null;
    transient MediaTracker tracker = null;
    protected static final int BORDER_SIZE = 2;
    protected KeyModifier[] keys = null;

    public ImageCellEditor() {
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.tracker = new MediaTracker(this);
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.addCellEditorListener(cellEditorListener);
    }

    public void addNotify() {
        super.addNotify();
        this.getParent().addMouseListener(this);
    }

    public void cancelCellEditing() {
        this.data = this.originalData;
        this.toggleSize(true);
        this.repaint();
        this.modified = false;
    }

    void changeSize() {
        Rectangle rectangle = Utilities.getWholeCell(this.cellInfo, this.cellInfo.getDrawingArea());
        Rectangle rectangle2 = this.getBounds();
        this.setBounds(rectangle2.x, rectangle2.y, rectangle.width, rectangle.height);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!this.inDialog) {
            this.initialEntry = this.isFullSize;
            if (!this.isFullSize) {
                this.toggleSize(true);
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.inDialog) {
            this.toggleSize(false);
        }
    }

    public Object getCellEditorValue() {
        if (this.isModified()) {
            return this.dataBytes;
        }
        return this.data;
    }

    public Component getComponent() {
        return this;
    }

    static Frame getFrame(Component component) {
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            return (Frame)component;
        }
        return null;
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        if (this.data == null || !this.isFullSize) {
            Rectangle rectangle = cellInfo.getDrawingArea();
            return new Dimension(rectangle.width, rectangle.height);
        }
        this.waitForImage(this.data);
        return new Dimension(this.data.getWidth(null), this.data.getHeight(null));
    }

    public KeyModifier[] getReservedKeys() {
        return this.keys;
    }

    void handleMouseContext(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            if (this.contextPending || mouseEvent.isPopupTrigger()) {
                this.loadNewImage();
                this.contextPending = false;
            } else if (this.initialEntry) {
                this.initialEntry = false;
            } else {
                this.toggleSize();
            }
        }
    }

    public void initialize(InitialEvent initialEvent, CellInfo cellInfo, Object object) {
        this.modified = false;
        this.isFullSize = true;
        this.cellInfo = cellInfo;
        this.readData(object);
        this.originalData = this.data;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.toggleSize();
                this.support.fireStopEditing(new CellEditorEvent(keyEvent));
                break;
            }
            case 27: {
                this.toggleSize(false);
                this.support.fireCancelEditing(new CellEditorEvent(keyEvent));
                break;
            }
            case 32: {
                this.toggleSize();
                break;
            }
            case 76: 
            case 79: {
                this.loadNewImage();
                break;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    void loadNewImage() {
        FileDialog fileDialog = new FileDialog(ImageCellEditor.getFrame(this));
        fileDialog.setMode(0);
        this.inDialog = true;
        fileDialog.show();
        this.requestFocus();
        this.inDialog = false;
        if (fileDialog.getFile() == null) {
            return;
        }
        String string = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
        this.dataBytes = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            int n = fileInputStream.available();
            if (n > 0) {
                this.dataBytes = new byte[n];
            }
            int n2 = fileInputStream.read(this.dataBytes);
            fileInputStream.close();
            if (n2 != n) {
                this.dataBytes = null;
            }
        }
        catch (Exception exception) {
            this.dataBytes = null;
            System.out.println(exception.toString());
        }
        if (this.dataBytes != null) {
            this.data = Toolkit.getDefaultToolkit().createImage(this.dataBytes);
            this.modified = true;
            this.readData(this.data);
            this.toggleSize(true);
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            if (mouseEvent.isPopupTrigger()) {
                this.contextPending = true;
            }
        } else {
            this.toggleSize(false);
            this.initialEntry = false;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handleMouseContext(mouseEvent);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        graphics.setColor(this.cellInfo.isEditable() ? this.cellInfo.getBackground().brighter() : this.cellInfo.getBackground());
        if (this.data == null) {
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        } else if (this.isFullSize) {
            graphics.drawImage(this.data, 2, 2, graphics.getColor(), this);
        } else {
            Rectangle rectangle2 = this.cellInfo.getDrawingArea();
            graphics.drawImage(this.data, (rectangle.width - rectangle2.width) / 2, (rectangle.height - rectangle2.height) / 2, rectangle2.width, rectangle2.height, graphics.getColor(), this);
        }
        Utilities.drawBorder(graphics, 8, 2, 0, 0, rectangle.width, rectangle.height, Color.black, Color.white);
    }

    void readData(Object object) {
        this.data = object != null && !(object instanceof Image) ? JCImageCreator.getImage((byte[])object, this) : (Image)object;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.removeCellEditorListener(cellEditorListener);
    }

    public void removeNotify() {
        this.getParent().removeMouseListener(this);
        super.removeNotify();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getPreferredSize(this.cellInfo, this.data);
        if (n3 < dimension.width + 4 || n4 < dimension.height + 4) {
            super.setBounds(n, n2, dimension.width + 4, dimension.height + 4);
        } else {
            super.setBounds(n, n2, n3, n4);
        }
    }

    public boolean stopCellEditing() {
        return true;
    }

    void toggleSize() {
        this.isFullSize ^= true;
        this.changeSize();
    }

    void toggleSize(boolean bl) {
        this.isFullSize = bl;
        this.changeSize();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    boolean waitForImage(Image image) {
        try {
            this.tracker.addImage(image, 0);
            this.tracker.waitForID(0);
        }
        catch (Exception exception) {
            return false;
        }
        return this.tracker.isErrorAny() ^ true;
    }
}

