/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCComponent;
import jclass.bwt.JCSeparator;
import jclass.bwt.JCSplitterWindow;
import jclass.util.JCEnvironment;

class SplitterWindowSeparator
extends JCSeparator
implements MouseListener,
MouseMotionListener {
    boolean dragging = false;
    JCSplitterWindow window;
    Component child1;
    Component child2;
    int dx;
    int dy;
    int pos;
    static final int SIZE = 4;
    static long last_time;
    private static int x_save;
    private static int y_save;
    private static boolean version102;

    static {
        x_save = -999;
        y_save = -999;
        version102 = JCEnvironment.getJavaVersion() <= 102;
    }

    SplitterWindowSeparator(JCSplitterWindow jCSplitterWindow) {
        super(jCSplitterWindow.dir == 0 ? 1 : 0, jCSplitterWindow.applet, jCSplitterWindow.getName());
        this.window = jCSplitterWindow;
        this.traversable = JCEnvironment.getJavaVersion() < 110;
        this.border_style = 9;
        this.border = 1;
        this.enableEvents(32L);
    }

    static void addMouseListeners(MouseListener mouseListener, Component component) {
        if (component != mouseListener) {
            component.addMouseListener(mouseListener);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.countComponents()) {
                SplitterWindowSeparator.addMouseListeners(mouseListener, container.getComponent(n));
                ++n;
            }
        }
    }

    static void addMouseMotionListeners(MouseMotionListener mouseMotionListener, Component component) {
        if (component != mouseMotionListener) {
            component.addMouseMotionListener(mouseMotionListener);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.countComponents()) {
                SplitterWindowSeparator.addMouseMotionListeners(mouseMotionListener, container.getComponent(n));
                ++n;
            }
        }
    }

    void drawLine(boolean bl, Event event) {
        this.drawLine(bl, event, this.window);
    }

    void drawLine(boolean bl, Event event, Container container) {
        if (!bl && container == this.window) {
            x_save = event.x + this.location().x;
            y_save = event.y + this.location().y;
        } else if (x_save == -999) {
            return;
        }
        int n = 0;
        while (n < container.countComponents()) {
            Component component = container.getComponents()[n];
            if (!BWTUtil.instanceOf(component, "Scrollbar")) {
                if (component instanceof Container) {
                    this.drawLine(bl, event, (Container)component);
                }
                if (!version102 || component instanceof Canvas) {
                    Point point = BWTUtil.translateToParent(this.window, component, 0, 0);
                    Graphics graphics = component.getGraphics();
                    if (graphics != null) {
                        int n2;
                        int n3;
                        int n4;
                        graphics.setXORMode(component.getBackground());
                        if (this.dir == 0) {
                            n4 = y_save - point.y;
                            n3 = component.size().width;
                            n2 = 0;
                            while (n2 < 4) {
                                graphics.drawLine(0, n4 + n2, n3, n4 + n2);
                                ++n2;
                            }
                        } else {
                            n4 = x_save - point.x;
                            n3 = component.size().height;
                            n2 = 0;
                            while (n2 < 4) {
                                graphics.drawLine(n4 + n2, 0, n4 + n2, n3);
                                ++n2;
                            }
                        }
                        graphics.dispose();
                    }
                }
            }
            ++n;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.getDrawingArea().inside(n, n2)) {
            return true;
        }
        this.pos = this.window.getComponent(this);
        if (this.pos <= 0 || this.pos == this.window.countComponents() - 1) {
            return false;
        }
        this.child1 = this.window.getComponents()[this.pos - 1];
        this.child2 = this.window.getComponents()[this.pos + 1];
        SplitterWindowSeparator.addMouseMotionListeners(this, this.child1);
        SplitterWindowSeparator.addMouseMotionListeners(this, this.child2);
        SplitterWindowSeparator.addMouseListeners(this, this.child1);
        SplitterWindowSeparator.addMouseListeners(this, this.child2);
        this.dragging = true;
        this.dy = 0;
        this.dx = 0;
        this.drawLine(false, event);
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        int n3;
        boolean bl;
        if (!this.dragging) {
            return false;
        }
        boolean bl2 = bl = JCEnvironment.getBrowser(this) != 1;
        if (bl && event.when - last_time < 50L) {
            return true;
        }
        last_time = event.when;
        int n4 = this.dir == 1 ? event.x : 0;
        int n5 = n3 = this.dir == 1 ? 0 : event.y;
        if (n4 < 0 && this.child1.size().width + n4 < this.window.min_child_size || n4 > 0 && this.child2.size().width - n4 < this.window.min_child_size || n3 < 0 && this.child1.size().height + n3 < this.window.min_child_size || n3 > 0 && this.child2.size().height - n3 < this.window.min_child_size) {
            return true;
        }
        this.dx = n4;
        this.dy = n3;
        this.drawLine(true, null);
        this.drawLine(false, event);
        return true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Event event = this.translate(mouseEvent);
        this.mouseDrag(event, event.x, event.y);
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return this.mouseMove(event, n, n2);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (!this.dragging) {
            this.setCursor(0);
        }
        return true;
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (!this.dragging && this.getDrawingArea().inside(n, n2)) {
            this.setCursor(this.dir == 1 ? 10 : 8);
        } else {
            this.setCursor(0);
        }
        return true;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Event event = this.translate(mouseEvent);
        this.mouseUp(event, event.x, event.y);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.setCursor(0);
        if (!this.dragging) {
            return false;
        }
        this.drawLine(true, null);
        if (this.dx != 0 || this.dy != 0) {
            this.window.resized = true;
            this.child1.resize(this.child1.size().width + this.dx, this.child1.size().height + this.dy);
            this.move(this.location().x + this.dx, this.location().y + this.dy);
            n = this.dx == 0 ? this.child2.location().x : this.location().x + this.size().width + 1;
            n2 = this.dy == 0 ? this.child2.location().y : this.location().y + this.size().height + 1;
            JCComponent.setBounds(this.child2, n, n2, this.child2.size().width - this.dx, this.child2.size().height - this.dy);
        }
        SplitterWindowSeparator.removeMouseMotionListeners(this, this.child1);
        SplitterWindowSeparator.removeMouseMotionListeners(this, this.child2);
        SplitterWindowSeparator.removeMouseListeners(this, this.child1);
        SplitterWindowSeparator.removeMouseListeners(this, this.child2);
        this.dragging = false;
        this.updateParent();
        return true;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.size().width, this.size().height);
        graphics.setColor(Color.white);
        if (this.dir == 1) {
            graphics.drawLine(0, 0, 0, this.size().height);
        } else {
            graphics.drawLine(0, 0, this.size().width, 0);
        }
        graphics.setColor(Color.black);
        if (this.dir == 1) {
            graphics.drawLine(this.size().width, 0, this.size().width, this.size().height);
        } else {
            graphics.drawLine(0, this.size().height, this.size().width, this.size().height);
        }
        graphics.setColor(this.getBackground());
    }

    protected int preferredHeight() {
        return this.dir == 0 ? 4 : 100;
    }

    protected int preferredWidth() {
        return this.dir == 1 ? 4 : 100;
    }

    static void removeMouseListeners(MouseListener mouseListener, Component component) {
        if (component != mouseListener) {
            component.removeMouseListener(mouseListener);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.countComponents()) {
                SplitterWindowSeparator.removeMouseListeners(mouseListener, container.getComponent(n));
                ++n;
            }
        }
    }

    static void removeMouseMotionListeners(MouseMotionListener mouseMotionListener, Component component) {
        if (component != mouseMotionListener) {
            component.removeMouseMotionListener(mouseMotionListener);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.countComponents()) {
                SplitterWindowSeparator.removeMouseMotionListeners(mouseMotionListener, container.getComponent(n));
                ++n;
            }
        }
    }

    void setSplitterWindow(JCSplitterWindow jCSplitterWindow) {
        this.dir = jCSplitterWindow.dir == 0 ? 1 : 0;
    }

    Event translate(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX(), mouseEvent.getY(), 0, mouseEvent.getModifiers());
        Point point = ((Component)mouseEvent.getSource()).getLocationOnScreen();
        Point point2 = this.getLocationOnScreen();
        event.translate(point.x - point2.x, point.y - point2.y);
        return event;
    }
}

