/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import jclass.base.TransientComponent;
import jclass.bwt.BWTUtil;
import jclass.bwt.CheckboxConverter;
import jclass.bwt.Indicator;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCItemSelectable;
import jclass.bwt.JCLabel;
import jclass.util.JCEnvironment;
import jclass.util.JCVector;

public class JCCheckbox
extends JCLabel
implements JCItemSelectable {
    public static final int INDICATOR_FILL = 0;
    public static final int INDICATOR_CHECK = 1;
    public static final int INDICATOR_CIRCLE = 2;
    public static final int INDICATOR_CROSS = 3;
    public static final int INDICATOR_DIAMOND = 4;
    public static final int INDICATOR_IMAGE = 5;
    public static final int OFF = 0;
    public static final int ON = 1;
    public static final int INDETERMINATE = 2;
    int indicator = 3;
    Image[] image_list;
    URL[] image_url_list;
    Color select_color = Color.white;
    Color unselect_color = Color.white;
    JCCheckboxGroup group;
    boolean armed = false;
    int state = 0;
    int num_states = 2;
    int old_state;
    int new_state;
    private static final String base = "checkbox";
    private static int nameCounter = 0;
    protected int label_offset = 5;
    protected int ind_height;
    protected int ind_width;
    protected int ind_x;
    protected int ind_y;
    protected boolean indicator_set = false;
    protected JCVector itemListeners = new JCVector(0);
    public static final int INDICATOR_SIZE = 13;

    public JCCheckbox() {
        this(null, null, null);
    }

    public JCCheckbox(Object object) {
        this(object, null, null);
    }

    public JCCheckbox(Object object, int n, JCCheckboxGroup jCCheckboxGroup) {
        this(object, null, null);
        this.group = jCCheckboxGroup;
        if (jCCheckboxGroup != null) {
            jCCheckboxGroup.add(this);
        }
        this.setState(n);
    }

    public JCCheckbox(Object object, Applet applet, String string) {
        super(object, applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.alignment = 3;
        this.traversable = true;
        this.highlight = 2;
        if (this.getClass().getName().equals("jclass.bwt.JCCheckbox")) {
            this.getParameters(applet);
        }
        this.enableEvents(32L);
    }

    public JCCheckbox(Object object, JCCheckboxGroup jCCheckboxGroup, int n) {
        this(object, null, null);
        this.group = jCCheckboxGroup;
        if (jCCheckboxGroup != null) {
            jCCheckboxGroup.add(this);
        }
        this.setUserData(new Integer(n));
    }

    public void addItemListener(JCItemListener jCItemListener) {
        this.itemListeners.addUnique(jCItemListener);
    }

    public void addNotify() {
        super.addNotify();
        this.setIndicatorSize();
    }

    public void armAction(Event event) {
        this.armed = true;
        this.old_state = this.state;
        this.new_state = this.state = (this.state + 1) % this.num_states;
        Graphics graphics = this.getGraphics();
        this.clipGCToAncestors(graphics);
        this.drawIndicator(graphics);
    }

    public void clickAction(Event event) {
        this.setState(this.new_state);
        if (event == null) {
            event = new Event(this, 0, null);
        }
        int n = this.state == 0 ? 2 : 1;
        JCItemEvent jCItemEvent = new JCItemEvent(this, 701, this.label, n);
        int n2 = 0;
        while (n2 < this.itemListeners.size()) {
            ((JCItemListener)this.itemListeners.elementAt(n2)).itemStateChanged(jCItemEvent);
            ++n2;
        }
    }

    protected void drawHighlight(Graphics graphics, boolean bl) {
        Color color;
        int n = this.size().width;
        int n2 = this.size().height;
        Color color2 = color = bl ? this.highlight_color : this.getBackground();
        if (color == null) {
            color = this.getForeground();
        }
        graphics.setColor(color);
        if (bl) {
            BWTUtil.drawDashedRect(graphics, 0, 0, n - 1, n2 - 1);
        } else {
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        }
    }

    protected void drawIndicator(Graphics graphics) {
        if (this.isShowing() && this.getPeer() != null) {
            Indicator.draw(this, graphics);
        }
    }

    public JCCheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    public int getIndicator() {
        return this.indicator;
    }

    public Image[] getIndicatorImageList() {
        return this.image_list;
    }

    public URL[] getIndicatorImageURLList() {
        return this.image_url_list;
    }

    public int getNumStates() {
        return this.num_states;
    }

    protected void getParameters() {
        super.getParameters();
        CheckboxConverter.getParams(this);
    }

    public Color getSelectColor() {
        return this.select_color;
    }

    public int[] getSelectedIndexes() {
        if (this.state != 0) {
            int[] nArray = new int[]{0};
            return nArray;
        }
        return null;
    }

    public Object[] getSelectedObjects() {
        if (this.state != 0) {
            Object[] objectArray = new Object[]{this.label};
            return objectArray;
        }
        return null;
    }

    public int getState() {
        return this.state;
    }

    public Color getUnselectColor() {
        return this.unselect_color;
    }

    public boolean keyDown(Event event, int n) {
        super.keyDown(event, n);
        if ((char)event.key == ' ') {
            this.armAction(event);
            this.clickAction(event);
            this.armed = false;
            this.getToolkit().sync();
            return true;
        }
        return false;
    }

    public synchronized void layout() {
        if (this.getPeer() == null) {
            return;
        }
        this.setIndicatorSize();
        int n = this.label_width;
        int n2 = this.label_height;
        this.label_width = n + this.ind_width + this.label_offset;
        this.label_height = Math.max(n2, this.ind_height);
        super.layout();
        this.ind_x = this.label_rect.x;
        this.ind_y = this.label_rect.y;
        if (this.ind_height < n2) {
            this.ind_y = this.label_rect.y + (n2 - this.ind_height) / 2;
        }
        this.label_rect.x += this.ind_width + this.label_offset;
        this.label_width = n;
        this.label_height = n2;
    }

    public static JCCheckboxGroup makeGroup(Object[] objectArray, int[] nArray, boolean bl) {
        if (objectArray == null) {
            return null;
        }
        if (nArray == null) {
            nArray = new int[objectArray.length];
        }
        JCCheckboxGroup jCCheckboxGroup = new JCCheckboxGroup();
        int n = 0;
        while (n < Math.min(objectArray.length, nArray.length)) {
            jCCheckboxGroup.add(new JCCheckbox(objectArray[n], jCCheckboxGroup, nArray[n]));
            ++n;
        }
        jCCheckboxGroup.setRadioBehavior(bl);
        return jCCheckboxGroup;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (event.when - TransientComponent.popdown_event_timestamp < 50L && JCEnvironment.getOS() != 1) {
            return true;
        }
        if (BWTUtil.getMouseButton(event) != 1) {
            return false;
        }
        if (this.armed) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        super.mouseDown(event, n, n2);
        this.armAction(event);
        return true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        if (this.armed) {
            this.state = this.new_state;
            this.repaint();
        }
        return this.armed;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this.armed) {
            this.state = this.old_state;
            this.repaint();
        }
        return this.armed;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.inside(n, n2)) {
            this.clickAction(event);
            this.armed = false;
        } else if (this.armed) {
            this.armed = false;
            this.repaint();
        }
        return true;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.needs_layout) {
            this.layout();
        }
        this.drawValue(graphics, this.label);
        this.drawIndicator(graphics);
    }

    protected int preferredHeight() {
        return Math.max(this.label_height, this.ind_height);
    }

    protected int preferredWidth() {
        return this.label_width + this.ind_width + this.label_offset;
    }

    public void removeItemListener(JCItemListener jCItemListener) {
        this.itemListeners.removeElement(jCItemListener);
    }

    public void setCheckboxGroup(JCCheckboxGroup jCCheckboxGroup) {
        if (this.group != null) {
            this.group.setCurrent(null);
        }
        this.group = jCCheckboxGroup;
        this.group.manage(this);
    }

    public synchronized void setIndicator(int n) {
        CheckboxConverter.checkIndicator(n);
        this.indicator = n;
        this.indicator_set = true;
        this.layout();
        this.repaint();
    }

    public synchronized void setIndicatorImageList(Image[] imageArray) {
        this.image_list = imageArray;
        this.repaint();
    }

    public synchronized void setIndicatorImageURLList(URL[] uRLArray) {
        this.image_url_list = uRLArray;
        if (uRLArray == null) {
            return;
        }
        this.image_list = new Image[uRLArray.length];
        int n = 0;
        while (n < uRLArray.length) {
            this.image_list[n] = this.getToolkit().getImage(uRLArray[n]);
            ++n;
        }
        this.repaint();
    }

    protected void setIndicatorSize() {
        this.ind_width = 0;
        this.ind_height = 0;
        if (this.indicator == 5 && this.image_list != null) {
            int n = 0;
            while (n < this.image_list.length) {
                if (this.image_list[n] != null) {
                    this.ind_width = Math.max(this.ind_width, this.image_list[n].getWidth(null));
                    this.ind_height = Math.max(this.ind_height, this.image_list[n].getHeight(null));
                }
                ++n;
            }
        }
        if (this.ind_width == 0) {
            this.ind_width = 13;
        }
        if (this.ind_height == 0) {
            this.ind_height = 13;
        }
    }

    public synchronized void setNumStates(int n) {
        this.num_states = n;
    }

    public synchronized void setSelectColor(Color color) {
        this.select_color = color;
        if (this.state == 1) {
            this.repaint();
        }
    }

    public void setState(int n) {
        if (this.group != null && n == 1) {
            this.group.setCurrent(this);
        }
        JCCheckbox jCCheckbox = this;
        synchronized (jCCheckbox) {
            if (this.group != null && this.group.radio_behavior && this.group.getCurrent() == this) {
                n = 1;
            }
            this.state = n;
            Graphics graphics = this.getGraphics();
            this.clipGCToAncestors(graphics);
            this.drawIndicator(graphics);
        }
    }

    public void setState(int n, boolean bl) {
        if (bl) {
            this.new_state = n;
            this.clickAction(null);
        } else {
            this.setState(n);
        }
    }

    public synchronized void setUnselectColor(Color color) {
        this.unselect_color = color;
        if (this.state == 0) {
            this.repaint();
        }
        this.repaint();
    }
}

