/*
 * Decompiled with CFR 0.152.
 */
package jclass.beans;

import java.awt.Dimension;
import java.beans.PropertyEditorSupport;
import jclass.util.JCUtilConverter;

public class DimensionEditor
extends PropertyEditorSupport {
    public String getAsText() {
        Dimension dimension = (Dimension)this.getValue();
        return "" + dimension.width + 'x' + dimension.height;
    }

    public String getJavaInitializationString() {
        Dimension dimension = (Dimension)this.getValue();
        if (dimension == null) {
            return "null";
        }
        return "new java.awt.Dimension(" + dimension.width + "," + dimension.height + ")";
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("invalid dimension: " + string);
        }
        Dimension dimension = JCUtilConverter.toDimension(string, null);
        if (dimension == null) {
            throw new IllegalArgumentException("invalid dimension: " + string);
        }
        this.setValue(dimension);
    }
}

