/*
 * Decompiled with CFR 0.152.
 */
package gramatica;

import gramatica.ListaSimbolos;
import gramatica.Simbolo;

public class Produccion
implements Cloneable {
    protected Simbolo parteIzquierda;
    protected ListaSimbolos parteDerecha;

    public Produccion(Simbolo parteIzda, ListaSimbolos parteDcha) {
        this.parteIzquierda = parteIzda.copiar();
        this.parteDerecha = parteDcha.copiar();
    }

    public Simbolo parteIzda() {
        return this.parteIzquierda.copiar();
    }

    public Simbolo elementoParteDcha(int indice) {
        return ((Simbolo)this.parteDerecha.elementoEn(indice)).copiar();
    }

    public Simbolo elementoParteDchaSC(int indice) {
        return (Simbolo)this.parteDerecha.elementoEn(indice);
    }

    public int tamanyoParteDcha() {
        return this.parteDerecha.tamanyoLista();
    }

    public ListaSimbolos parteDcha() {
        return this.parteDerecha.copiar();
    }

    public ListaSimbolos pDcha() {
        return this.parteDerecha;
    }

    public boolean parteDchaEsLambda() {
        return this.parteDerecha.tamanyoLista() == 0;
    }

    public void mostrar() {
        this.parteIzquierda.mostrar();
        System.out.print(" --> ");
        for (int i = 0; i < this.parteDerecha.tamanyoLista(); ++i) {
            ((Simbolo)this.parteDerecha.elementoEn(i)).mostrar();
            System.out.print("  ");
        }
        System.out.println();
    }

    public String toString() {
        int i;
        String resultado = new String("");
        resultado = resultado.concat(this.parteIzquierda.toString());
        resultado = resultado.concat(" --> ");
        for (i = 0; i < this.parteDerecha.tamanyoLista(); ++i) {
            resultado = resultado.concat(((Simbolo)this.parteDerecha.elementoEn(i)).toString());
            resultado = resultado.concat("  ");
        }
        if (i == 0) {
            resultado = resultado.concat("EPS");
        }
        return resultado;
    }

    public Produccion copiar() {
        return new Produccion(this.parteIzquierda, this.parteDerecha);
    }

    public boolean esIgualQue(Produccion produccion) {
        boolean resultado = true;
        if (this.parteIzquierda.esIgualQue(produccion.parteIzda())) {
            if (this.tamanyoParteDcha() == produccion.tamanyoParteDcha()) {
                if (this.tamanyoParteDcha() == 0) {
                    resultado = true;
                }
                for (int ind = 0; ind < this.tamanyoParteDcha(); ++ind) {
                    if (this.elementoParteDcha(ind).esIgualQue(produccion.elementoParteDcha(ind))) continue;
                    resultado = false;
                }
            } else {
                resultado = false;
            }
        } else {
            resultado = false;
        }
        return resultado;
    }
}

