/*
 * Decompiled with CFR 0.152.
 */
package grafos;

import grafos.Nodo;

public class ListaNodos
implements Cloneable {
    private Nodo[] nodos = new Nodo[1];
    private int ultimo = -1;
    private int primero = 0;
    private int numeroNodos = 0;

    public int numeroNodos() {
        return this.numeroNodos;
    }

    public int indiceMasAlto() {
        int indice = 0;
        for (int i = 0; i < this.ultimo; ++i) {
            if (this.nodos[i] == null) continue;
            indice = i;
        }
        return indice;
    }

    public int primero() {
        return this.primero;
    }

    public void anyadirNodoEn(Nodo nuevoNodo, int indice) {
        if (this.nodos[indice] != null) {
            ++this.numeroNodos;
        }
        if (indice >= this.ultimo) {
            Nodo[] nuevosNodos = new Nodo[indice + 30];
            System.arraycopy(this.nodos, 0, nuevosNodos, 0, this.ultimo + 1);
            for (int i = this.ultimo + 1; i <= indice + 29; ++i) {
                nuevosNodos[i] = null;
            }
            this.ultimo = indice + 29;
            this.nodos = nuevosNodos;
        }
        this.nodos[indice] = nuevoNodo;
        nuevoNodo.indice = indice;
        if (indice == this.primero) {
            this.actualizarPrimero(indice);
        }
    }

    public void anyadirNodo(Nodo nuevoNodo) {
        ++this.numeroNodos;
        if (this.primero < this.ultimo) {
            this.nodos[this.primero] = nuevoNodo;
            nuevoNodo.indice = this.primero;
            this.actualizarPrimero(this.primero);
        } else {
            this.anyadirNodoEn(nuevoNodo, this.primero);
        }
    }

    public void actualizarPrimero(int comienzo) {
        for (int i = comienzo; i <= this.ultimo; ++i) {
            if (this.nodos[i] != null) continue;
            this.primero = i;
            break;
        }
    }

    public void eliminarNodoEn(int indice) {
        if (this.nodos[indice] != null) {
            --this.numeroNodos;
        }
        if (indice <= this.ultimo) {
            if (this.primero > indice) {
                this.primero = indice;
            }
            this.nodos[indice] = null;
        }
    }

    public void eliminarNodo(Nodo nodo) {
        if (this.nodos[nodo.indice] != null) {
            --this.numeroNodos;
        }
        if (this.primero > nodo.indice) {
            this.primero = nodo.indice;
        }
        this.nodos[nodo.indice] = null;
    }

    public Nodo primerNodo() {
        for (int i = 0; i <= this.ultimo; ++i) {
            if (this.nodos[i] == null) continue;
            return this.nodos[i];
        }
        return null;
    }

    public Nodo siguienteNodo(Nodo nodoAnterior) {
        for (int i = nodoAnterior.indice + 1; i <= this.ultimo; ++i) {
            if (this.nodos[i] == null) continue;
            return this.nodos[i];
        }
        return null;
    }

    public int indicePrimerNodo() {
        for (int i = 0; i <= this.ultimo; ++i) {
            if (this.nodos[i] == null) continue;
            return i;
        }
        return -1;
    }

    public int indiceSiguienteNodo(int indiceAnterior) {
        for (int i = indiceAnterior + 1; i <= this.ultimo; ++i) {
            if (this.nodos[i] == null) continue;
            return i;
        }
        return -1;
    }

    public Nodo nodoDeIndice(int indice) {
        if (indice > this.ultimo || indice < 0) {
            return null;
        }
        return this.nodos[indice];
    }

    public Object clone() throws CloneNotSupportedException {
        ListaNodos copia = new ListaNodos();
        copia = (ListaNodos)super.clone();
        copia.nodos = new Nodo[this.ultimo + 1];
        for (int i = 0; i <= this.ultimo; ++i) {
            if (this.nodoDeIndice(i) == null) continue;
            copia.nodos[i] = (Nodo)this.nodos[i].clone();
        }
        return copia;
    }
}

