/*
 * Decompiled with CFR 0.152.
 */
package grafos;

import grafos.Conjunto;
import grafos.Eje;
import grafos.ListaNodos;
import grafos.Nodo;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;

public class Grafo {
    private ListaNodos listaNodos = new ListaNodos();
    private Hashtable tablaIds = new Hashtable();
    private int ultimoId = 0;
    private Hashtable ejes = new Hashtable();

    public int insertarNodo(Nodo nodo) {
        this.listaNodos.anyadirNodo(nodo);
        nodo.tieneId = true;
        nodo.id = this.ultimoId;
        this.tablaIds.put(new Integer(this.ultimoId), nodo);
        do {
            ++this.ultimoId;
        } while (this.tablaIds.containsKey(new Integer(this.ultimoId)));
        return nodo.indice;
    }

    public Nodo obtenerNodoDeIndice(int indice) {
        return this.listaNodos.nodoDeIndice(indice);
    }

    public Nodo obtenerNodoDeId(int id) {
        return (Nodo)this.tablaIds.get(new Integer(id));
    }

    public void eliminarNodo(int n) {
        Conjunto pSet = new Conjunto();
        Conjunto cSet = new Conjunto();
        Nodo nodoEliminar = this.listaNodos.nodoDeIndice(n);
        int hijo = nodoEliminar.primerHijo();
        while (hijo != -1) {
            this.eliminarEje(n, hijo);
            hijo = nodoEliminar.siguienteHijo();
        }
        Nodo nodo = this.listaNodos.primerNodo();
        while (nodo != null) {
            if (nodo.tieneHijo(n)) {
                this.eliminarEje(nodo.obtenerIndice(), n);
            }
            nodo = this.listaNodos.siguienteNodo(nodo);
        }
        this.listaNodos.eliminarNodoEn(n);
        Integer id = nodoEliminar.obtenerObjetoId();
        this.tablaIds.remove(id);
        if (id < this.ultimoId) {
            this.ultimoId = id;
        }
    }

    public void eliminarNodo(Nodo nin) {
        this.eliminarNodo(nin.obtenerIndice());
    }

    public void insertarEje(int n1, int n2, String texto) {
        Eje eje = new Eje(this.listaNodos.nodoDeIndice(n1), this.listaNodos.nodoDeIndice(n2), texto);
        this.insertarEje(eje);
    }

    public void insertarEje(Eje eje) {
        int n1 = eje.destino().obtenerIndice();
        int n2 = eje.origen().obtenerIndice();
        this.ejes.remove(new Point(n1, n2));
        if (n1 != n2) {
            this.ejes.remove(new Point(n2, n1));
        }
        eje.destino().ponerHijo(n2);
        eje.origen().ponerHijo(n1);
        this.ejes.put(new Point(n1, n2), eje);
        this.ejes.put(new Point(n2, n1), eje);
    }

    public Eje obtenerEje(int n1, int n2) {
        return (Eje)this.ejes.get(new Point(n1, n2));
    }

    public void eliminarEje(int n1, int n2) {
        Nodo nodoAux = this.listaNodos.nodoDeIndice(n1);
        nodoAux.quitarHijo(n2);
        this.ejes.remove(new Point(n1, n2));
        if (n1 != n2) {
            nodoAux = this.listaNodos.nodoDeIndice(n2);
            nodoAux.quitarHijo(n1);
            this.ejes.remove(new Point(n2, n1));
        }
    }

    public void eliminarEje(Eje eje) {
        this.eliminarEje(eje.destino().obtenerIndice(), eje.origen().obtenerIndice());
    }

    public Conjunto padres(int n) {
        Conjunto padres = new Conjunto();
        Nodo nodo = this.listaNodos.primerNodo();
        while (nodo != null) {
            if (nodo.tieneHijo(n)) {
                padres.incluyeElemento(nodo.indice);
            }
            nodo = this.listaNodos.siguienteNodo(nodo);
        }
        return padres;
    }

    public Conjunto hijos(int n) {
        return this.listaNodos.nodoDeIndice(n).obtenerHijos();
    }

    public int numeroDeNodos() {
        return this.listaNodos.numeroNodos();
    }

    public Nodo primerNodo() {
        return this.listaNodos.primerNodo();
    }

    public Nodo siguienteNodo(Nodo nodo) {
        return this.listaNodos.siguienteNodo(nodo);
    }

    public int obtenerIndiceDeNodo(Nodo nodo) {
        return nodo.indice;
    }

    public int indicePrimerNodo() {
        return this.listaNodos.indicePrimerNodo();
    }

    public int indiceSiguienteNodo(int indice) {
        return this.listaNodos.indiceSiguienteNodo(indice);
    }

    public int primero() {
        return this.listaNodos.primero();
    }

    public int indiceMasAlto() {
        return this.listaNodos.indiceMasAlto();
    }

    public void pack() {
        Nodo nodoAux;
        int n = this.numeroDeNodos();
        if (n == this.listaNodos.indiceMasAlto() + 1) {
            return;
        }
        int indiceMasAlto = this.listaNodos.indiceMasAlto();
        int[] map = new int[indiceMasAlto + 1];
        int indiceNodo = this.indiceSiguienteNodo(n - 1);
        while (indiceNodo != -1) {
            nodoAux = this.obtenerNodoDeIndice(indiceNodo);
            this.listaNodos.anyadirNodo(nodoAux);
            map[indiceNodo] = nodoAux.indice;
            this.listaNodos.eliminarNodoEn(indiceNodo);
            indiceNodo = this.indiceSiguienteNodo(indiceNodo);
        }
        nodoAux = this.primerNodo();
        while (nodoAux != null) {
            int hijo = nodoAux.buscarSiguienteHijo(n - 1);
            while (hijo != -1) {
                if (hijo >= n) {
                    nodoAux.ponerHijo(map[hijo]);
                    nodoAux.quitarHijo(hijo);
                }
                hijo = nodoAux.buscarSiguienteHijo(hijo + 1);
            }
            nodoAux = this.siguienteNodo(nodoAux);
        }
        Enumeration keys = this.ejes.keys();
        while (keys.hasMoreElements()) {
            Point key = (Point)keys.nextElement();
            if (key.x < n && key.y < n) continue;
            if (key.x > indiceMasAlto || key.y > indiceMasAlto) {
                this.ejes.remove(key);
                continue;
            }
            Eje element = (Eje)this.ejes.get(key);
            this.ejes.remove(key);
            if (key.x >= n) {
                key.x = map[key.x];
            }
            if (key.y >= n) {
                key.y = map[key.y];
            }
            this.ejes.put(key, element);
        }
    }

    public Enumeration obtenerEjes() {
        return this.ejes.elements();
    }

    public Nodo nodoDeIndice(int index) {
        return this.listaNodos.nodoDeIndice(index);
    }
}

