/*
 * Decompiled with CFR 0.152.
 */
package grafos;

import grafos.Cola;
import grafos.Coordenadas;
import grafos.Grafo;
import grafos.Nodo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Algoritmo {
    private Coordenadas rect;
    private double xmax;
    private double xmin;
    private double ymax;
    private double ymin;
    private int[] listaOrdenada;
    private int N;
    private int EDGES;
    private long[][] D;
    private double[][] K;
    private double Ko;
    private double[][] L;
    private double epsilon;
    private double[] delta;
    private int NUM_MAX_RECOLOCACIONES = 10;
    private int numeroVecesRecolocado = 0;
    private int[] NUMERO_VECES_MOVIDO;
    private int HY_SIZE = 10;
    private int HY_PERCENTAGE = 5;
    private double E;
    private double[] E_HY;
    private int COUNTER = 0;
    private Nodo mv = null;
    private double x_parcial;
    private double y_parcial;
    private double xx_parcial;
    private double xy_parcial;
    private double yx_parcial;
    private double yy_parcial;
    private boolean connected;

    public String distribuir(Grafo G) {
        int maximoVeces = 0;
        this.rect = new Coordenadas(-200.0, -213.5, 400.0, 427.0);
        this.Inicializar(G);
        while (Boolean.TRUE.booleanValue()) {
            this.ComprobarPosiciones(G);
            double maxDel = 0.0;
            Nodo v = G.primerNodo();
            while (v != null) {
                this.delta[this.enum((int)G.obtenerIndiceDeNodo((Nodo)v))] = Math.sqrt(this.buscarDelta2(G, v));
                if (this.delta[this.enum(G.obtenerIndiceDeNodo(v))] > maxDel) {
                    maxDel = this.delta[this.enum(G.obtenerIndiceDeNodo(v))];
                }
                if (this.NUMERO_VECES_MOVIDO[this.enum(G.obtenerIndiceDeNodo(v))] > maximoVeces) {
                    maximoVeces = this.NUMERO_VECES_MOVIDO[this.enum(G.obtenerIndiceDeNodo(v))];
                }
                v = G.siguienteNodo(v);
            }
            this.mv = G.primerNodo();
            int mvi = this.enum(G.obtenerIndiceDeNodo(this.mv));
            double maximoValor = 0.0;
            v = this.mv;
            while (v != null) {
                double valorTemporal = maximoVeces != 0 ? this.funcionTemporal(this.delta[this.enum(G.obtenerIndiceDeNodo(v))] / maxDel, 1 - this.NUMERO_VECES_MOVIDO[this.enum(G.obtenerIndiceDeNodo(v))] / maximoVeces) : this.delta[this.enum(G.obtenerIndiceDeNodo(v))] / maxDel;
                if (valorTemporal > maximoValor) {
                    this.mv = v;
                    mvi = this.enum(G.obtenerIndiceDeNodo(this.mv));
                    maximoValor = valorTemporal;
                }
                v = G.siguienteNodo(v);
            }
            if (this.delta[mvi] < this.epsilon) break;
            if (this.COUNTER > this.HY_SIZE) {
                double d;
                this.E = this.calcularE(G);
                if (this.E_HY[this.COUNTER % this.HY_SIZE] * (double)this.HY_PERCENTAGE / 100.0 > d) break;
            }
            this.E_HY[this.COUNTER % this.HY_SIZE] = this.E;
            this.numeroVecesRecolocado = 0;
            while (this.delta[mvi] > this.epsilon && this.numeroVecesRecolocado < this.NUM_MAX_RECOLOCACIONES) {
                this.CalcularNuevaPosicion(G);
                this.delta[mvi] = Math.sqrt(this.buscarDelta2(G, this.mv));
                ++this.numeroVecesRecolocado;
            }
            int n = mvi;
            this.NUMERO_VECES_MOVIDO[n] = this.NUMERO_VECES_MOVIDO[n] + 1;
        }
        return null;
    }

    private void Inicializar(Grafo G) {
        this.N = G.numeroDeNodos();
        this.calcularListaOrdenada(G);
        this.NUMERO_VECES_MOVIDO = new int[this.N];
        for (int i = 0; i < this.N; ++i) {
            this.NUMERO_VECES_MOVIDO[i] = 0;
        }
        this.EDGES = 0;
        Nodo v = G.primerNodo();
        while (v != null) {
            Nodo u = G.siguienteNodo(v);
            while (u != null) {
                if (v.tieneHijo(u)) {
                    ++this.EDGES;
                }
                u = G.siguienteNodo(u);
            }
            v = G.siguienteNodo(v);
        }
        this.epsilon = 0.5 * (double)(this.N + this.EDGES);
        this.calcularDistancias(G);
        this.buscarLyK(G);
        this.delta = new double[this.N];
        this.E_HY = new double[this.HY_SIZE];
        this.xmin = this.rect.x;
        this.xmax = this.xmin + this.rect.ancho;
        this.ymin = this.rect.y;
        this.ymax = this.ymin + this.rect.alto;
    }

    private void calcularDistancias(Grafo G) {
        int j;
        int i;
        Cola cola = new Cola();
        boolean[] hecho = new boolean[G.numeroDeNodos()];
        this.D = new long[G.numeroDeNodos()][G.numeroDeNodos()];
        for (i = 0; i < G.numeroDeNodos(); ++i) {
            for (j = i; j < G.numeroDeNodos(); ++j) {
                this.D[i][j] = 0L;
                this.D[j][i] = 0L;
            }
        }
        Nodo s = G.primerNodo();
        while (s != null) {
            int vi;
            for (i = 0; i < G.numeroDeNodos(); ++i) {
                hecho[i] = false;
            }
            int si = this.enum(G.obtenerIndiceDeNodo(s));
            hecho[si] = true;
            Nodo v = G.primerNodo();
            while (v != null) {
                if (s.tieneHijo(v)) {
                    cola.push(G.obtenerIndiceDeNodo(v));
                    cola.push(G.obtenerIndiceDeNodo(s));
                    vi = this.enum(G.obtenerIndiceDeNodo(v));
                    hecho[vi] = true;
                }
                v = G.siguienteNodo(v);
            }
            while (!cola.esVacio()) {
                v = G.obtenerNodoDeIndice(cola.pop());
                Nodo p = G.obtenerNodoDeIndice(cola.pop());
                int pi = this.enum(G.obtenerIndiceDeNodo(p));
                vi = this.enum(G.obtenerIndiceDeNodo(v));
                this.D[si][vi] = this.D[pi][si] + (long)1;
                this.D[vi][si] = this.D[si][vi];
                Nodo u = G.primerNodo();
                while (u != null) {
                    int ui;
                    if (v.tieneHijo(u) && !hecho[ui = this.enum(G.obtenerIndiceDeNodo(u))]) {
                        cola.push(G.obtenerIndiceDeNodo(u));
                        cola.push(G.obtenerIndiceDeNodo(v));
                        hecho[ui] = true;
                    }
                    u = G.siguienteNodo(u);
                }
            }
            s = G.siguienteNodo(s);
        }
        this.connected = true;
        for (i = 0; i < G.numeroDeNodos(); ++i) {
            for (j = i + 1; j < G.numeroDeNodos(); ++j) {
                if (this.D[i][j] != (long)0) continue;
                this.connected = false;
                this.D[i][j] = Long.MAX_VALUE;
                this.D[j][i] = Long.MAX_VALUE;
            }
        }
    }

    private void calcularListaOrdenada(Grafo G) {
        this.listaOrdenada = new int[G.numeroDeNodos()];
        int i = 0;
        Nodo v = G.primerNodo();
        while (v != null) {
            this.listaOrdenada[i] = G.obtenerIndiceDeNodo(v);
            ++i;
            v = G.siguienteNodo(v);
        }
    }

    private int enum(int indice) {
        int i = 0;
        while (this.listaOrdenada[i] != indice) {
            ++i;
        }
        return i;
    }

    private void buscarLyK(Grafo G) {
        int j;
        int i;
        this.Ko = 0.0;
        this.L = new double[G.numeroDeNodos()][G.numeroDeNodos()];
        this.K = new double[G.numeroDeNodos()][G.numeroDeNodos()];
        long diametro = this.D[0][0];
        for (i = 0; i < G.numeroDeNodos(); ++i) {
            for (j = i + 1; j < G.numeroDeNodos(); ++j) {
                if (diametro < this.D[i][j] && this.D[i][j] < Long.MAX_VALUE) {
                    diametro = this.D[i][j];
                }
                this.Ko += (double)this.D[i][j];
            }
        }
        this.Ko /= (double)G.numeroDeNodos();
        for (i = 0; i < G.numeroDeNodos(); ++i) {
            for (j = i + 1; j < G.numeroDeNodos(); ++j) {
                double Lo = Math.sqrt(this.rect.ancho * this.rect.alto / (double)4) / (double)diametro;
                this.L[i][j] = Lo * (double)this.D[i][j];
                this.L[j][i] = this.L[i][j];
                this.K[i][j] = this.D[i][j] < Long.MAX_VALUE ? this.Ko * this.Ko / (double)(this.D[i][j] * this.D[i][j]) : 0.0;
                this.K[j][i] = this.K[i][j];
            }
        }
    }

    private double buscarDelta2(Grafo G, Nodo v) {
        this.calcularParciales(G, v);
        return this.x_parcial * this.x_parcial + this.y_parcial * this.y_parcial;
    }

    private void calcularParciales(Grafo G, Nodo v) {
        int vi = this.enum(G.obtenerIndiceDeNodo(v));
        this.x_parcial = 0.0;
        this.y_parcial = 0.0;
        this.xx_parcial = 0.0;
        this.xy_parcial = 0.0;
        this.yx_parcial = 0.0;
        this.yy_parcial = 0.0;
        Nodo u = G.primerNodo();
        while (u != null) {
            if (v != u) {
                int ui = this.enum(G.obtenerIndiceDeNodo(u));
                double dx = v.obtenerPosicion().x - u.obtenerPosicion().x;
                double dy = v.obtenerPosicion().y - u.obtenerPosicion().y;
                double dd = Math.sqrt(dx * dx + dy * dy);
                this.x_parcial += this.K[vi][ui] * (dx - this.L[vi][ui] * dx / dd);
                this.y_parcial += this.K[vi][ui] * (dy - this.L[vi][ui] * dy / dd);
                this.xx_parcial += this.K[vi][ui] * (1.0 - this.L[vi][ui] * dy * dy / (dd * dd * dd));
                this.xy_parcial += this.K[vi][ui] * (this.L[vi][ui] * dx * dy / (dd * dd * dd));
                this.yx_parcial += this.K[vi][ui] * (this.L[vi][ui] * dy * dx / (dd * dd * dd));
                this.yy_parcial += this.K[vi][ui] * (1.0 - this.L[vi][ui] * dx * dx / (dd * dd * dd));
            }
            u = G.siguienteNodo(u);
        }
    }

    private double funcionTemporal(double del, double times) {
        return 0.5 * del + 0.5 * times;
    }

    private double calcularE(Grafo G) {
        double total = 0.0;
        Nodo v = G.primerNodo();
        while (v != null) {
            int vi = this.enum(G.obtenerIndiceDeNodo(v));
            Nodo u = G.siguienteNodo(v);
            while (u != null) {
                int ui = this.enum(G.obtenerIndiceDeNodo(u));
                double dx = v.obtenerPosicion().x - u.obtenerPosicion().x;
                double dy = v.obtenerPosicion().y - u.obtenerPosicion().y;
                double dd = Math.sqrt(dx * dx + dy * dy);
                double dif = dd - this.L[vi][ui];
                total += this.K[vi][ui] * dif * dif;
                u = G.siguienteNodo(u);
            }
            v = G.siguienteNodo(v);
        }
        return total / (double)2;
    }

    private void CalcularNuevaPosicion(Grafo G) {
        double xpos = this.mv.obtenerPosicion().x;
        double ypos = this.mv.obtenerPosicion().y;
        int mvi = this.enum(G.obtenerIndiceDeNodo(this.mv));
        this.calcularParciales(G, this.mv);
        double A = this.xx_parcial;
        double B = this.xy_parcial;
        double C = -this.x_parcial;
        double D = this.yx_parcial;
        double E = this.yy_parcial;
        double F = -this.y_parcial;
        double dy = (A * F - C * D) / (A * E - B * D);
        double dx = (C * E - B * F) / (A * E - B * D);
        this.mv.ponerPosicion(xpos + dx, ypos + dy);
    }

    private void ComprobarPosiciones(Grafo G) {
        boolean OK = false;
        while (!OK) {
            OK = true;
            Nodo v = G.primerNodo();
            while (v != null) {
                Nodo u = G.siguienteNodo(v);
                while (u != null) {
                    if (v.obtenerPosicion().x == u.obtenerPosicion().x && v.obtenerPosicion().y == u.obtenerPosicion().y) {
                        int vi = this.enum(G.obtenerIndiceDeNodo(v));
                        int ui = this.enum(G.obtenerIndiceDeNodo(u));
                        double rand = (1.4 * Math.random() - 1.0) * this.L[vi][ui];
                        u.ponerPosicion(u.obtenerPosicion().x + rand, u.obtenerPosicion().y);
                        rand = (1.4 * Math.random() - 1.0) * this.L[vi][ui];
                        u.ponerPosicion(u.obtenerPosicion().x, u.obtenerPosicion().y + rand);
                        OK = false;
                    }
                    u = G.siguienteNodo(u);
                }
                v = G.siguienteNodo(v);
            }
        }
    }
}

