/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SelectableItemPainter
implements Serializable,
ItemPaintSite,
ItemPainter {
    protected Color inactiveSelectedBg;
    protected Color inactiveSelectedFg;
    protected Color selectedBg;
    protected Color selectedFg = SystemColor.textHighlightText;
    protected boolean paintBackground = false;
    protected int state;
    protected transient ItemPaintSite site;
    protected transient ItemPainter painter;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof ItemPainter) {
            this.painter = (ItemPainter)object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.painter instanceof Serializable ? this.painter : null);
    }

    public Component getSiteComponent() {
        return this.site != null ? this.site.getSiteComponent() : null;
    }

    public Insets getItemMargins() {
        return this.site != null ? this.site.getItemMargins() : null;
    }

    public int getAlignment() {
        return this.site != null ? this.site.getAlignment() : 0;
    }

    public Font getFont() {
        return this.site != null ? this.site.getFont() : null;
    }

    public boolean isTransparent() {
        return (this.state & 4) != 0 ? false : (this.site != null ? this.site.isTransparent() : false);
    }

    public Color getForeground() {
        return (this.state & 4) != 0 ? ((this.state & 0x20) != 0 ? this.inactiveSelectedFg : this.selectedFg) : (this.site != null ? this.site.getForeground() : null);
    }

    public Color getBackground() {
        return (this.state & 4) != 0 ? ((this.state & 0x20) != 0 ? this.inactiveSelectedBg : this.selectedBg) : (this.site != null ? this.site.getBackground() : null);
    }

    public void paint(Object object, Graphics graphics, Rectangle rectangle, int n, ItemPaintSite itemPaintSite) {
        this.site = itemPaintSite;
        this.state = n;
        if (this.paintBackground) {
            Color color = graphics.getColor();
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
        }
        if (this.painter != null) {
            this.painter.paint(object, graphics, rectangle, n, this);
        }
    }

    public Dimension getPreferredSize(Object object, Graphics graphics, int n, ItemPaintSite itemPaintSite) {
        this.site = itemPaintSite;
        this.state = n;
        if (this.painter != null) {
            return this.painter.getPreferredSize(object, graphics, n, this);
        }
        return new Dimension();
    }

    public Color getInactiveSelectedForeground() {
        return this.inactiveSelectedFg;
    }

    public void setInactiveSelectedForeground(Color color) {
        this.inactiveSelectedFg = color;
    }

    public Color getInactiveSelectedBackground() {
        return this.inactiveSelectedBg;
    }

    public void setInactiveSelectedBackground(Color color) {
        this.inactiveSelectedBg = color;
    }

    public Color getSelectedForeground() {
        return this.selectedFg;
    }

    public void setSelectedForeground(Color color) {
        this.selectedFg = color;
    }

    public Color getSelectedBackground() {
        return this.selectedBg;
    }

    public void setSelectedBackground(Color color) {
        this.selectedBg = color;
    }

    public boolean isPaintBackground() {
        return this.paintBackground;
    }

    public void setPaintBackground(boolean bl) {
        this.paintBackground = bl;
    }

    public ItemPainter getPainter() {
        return this.painter;
    }

    public void setPainter(ItemPainter itemPainter) {
        this.painter = itemPainter;
    }

    public SelectableItemPainter(ItemPainter itemPainter, boolean bl) {
        this.selectedBg = SystemColor.textHighlight;
        this.inactiveSelectedFg = SystemColor.menuText;
        this.inactiveSelectedBg = SystemColor.menu;
        this.painter = itemPainter;
        this.paintBackground = bl;
    }

    public SelectableItemPainter(ItemPainter itemPainter) {
        this.selectedBg = SystemColor.textHighlight;
        this.inactiveSelectedFg = SystemColor.menuText;
        this.inactiveSelectedBg = SystemColor.menu;
        this.painter = itemPainter;
    }

    public SelectableItemPainter() {
        this.selectedBg = SystemColor.textHighlight;
        this.inactiveSelectedFg = SystemColor.menuText;
        this.inactiveSelectedBg = SystemColor.menu;
    }
}

