/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.LinkedTreeNode;
import com.borland.jbcl.view.TreeCore;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class NodeState
implements Serializable {
    boolean inUse = true;
    NodeState nextVisible;
    NodeState prevVisible;
    Rectangle itemRect;
    Rectangle boxRect = new Rectangle();
    int lineNumber;
    int level;
    boolean selected;
    boolean expanded;
    TreeCore core;
    transient GraphLocation node;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof GraphLocation) {
            this.node = (GraphLocation)object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.node instanceof Serializable ? this.node : null);
    }

    public String toString() {
        if (this.node == null) {
            return "null";
        }
        String string = this.prevVisible == null ? "null" : this.prevVisible.node.toString();
        String string2 = this.nextVisible == null ? "null" : this.nextVisible.node.toString();
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("#").concat(String.valueOf(this.lineNumber))).concat(String.valueOf(" "))).concat(String.valueOf(this.itemRect))).concat(String.valueOf(" "))).concat(String.valueOf(this.node.toString()))).concat(String.valueOf("  prev:"))).concat(String.valueOf(string))).concat(String.valueOf(", next:"))).concat(String.valueOf(string2))).concat(String.valueOf(this.expanded ? " exp" : ""))).concat(String.valueOf(this.selected ? " sel" : ""));
    }

    int hitTest(int n, int n2) {
        if (this.itemRect.contains(n, n2)) {
            return 1;
        }
        if (this.boxRect.contains(n, n2)) {
            if (this.node.hasChildren() != 0) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    boolean isDescendentOf(GraphLocation graphLocation) {
        for (GraphLocation graphLocation2 = this.node; graphLocation2 != null; graphLocation2 = graphLocation2.getParent()) {
            if (graphLocation2 != graphLocation) continue;
            return true;
        }
        return false;
    }

    void update(int n) {
        this.level = n;
        this.inUse = true;
    }

    GraphLocation getNextSibling() {
        if (this.node instanceof LinkedTreeNode) {
            return ((LinkedTreeNode)this.node).getNextSibling();
        }
        GraphLocation graphLocation = this.node.getParent();
        if (graphLocation != null) {
            GraphLocation[] graphLocationArray = graphLocation.getChildren();
            for (int i = 0; i < graphLocationArray.length; ++i) {
                if (graphLocationArray[i] != this.node || i >= graphLocationArray.length - 1) continue;
                return graphLocationArray[i + 1];
            }
        }
        return null;
    }

    NodeState(TreeCore treeCore, GraphLocation graphLocation, int n, boolean bl) {
        this.itemRect = new Rectangle();
        this.core = treeCore;
        this.node = graphLocation;
        this.level = n;
        this.expanded = graphLocation.hasChildren() != 0 ? bl : false;
        this.boxRect.width = treeCore.getBoxSize().width;
        this.boxRect.height = treeCore.getBoxSize().height;
        this.inUse = true;
    }
}

