/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonModelMulticaster;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.view.SingletonModelView;
import java.awt.Dimension;
import java.awt.Label;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class LabelView
extends Label
implements Serializable,
SingletonModelListener,
SingletonModelView {
    private transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();
    private boolean postOnFocusLost = true;
    private boolean readOnly;
    private transient WritableSingletonModel writeModel;
    private transient SingletonModel model;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof SingletonModel) {
            this.model = (SingletonModel)object;
        }
        if (this.model instanceof SingletonModel) {
            this.writeModel = (WritableSingletonModel)this.model;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < 2) {
            dimension.width = 100;
        }
        return dimension;
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        this.updateText();
    }

    protected void postText() {
        if (this.writeModel != null && this.writeModel.canSet(true)) {
            String string = super.getText();
            this.writeModel.set(string);
        }
    }

    protected void updateText() {
        if (this.model != null) {
            Object object = this.model.get();
            super.setText(object != null ? object.toString() : "");
        }
    }

    public void setText(String string) {
        if (!this.isReadOnly() && this.writeModel.canSet(true)) {
            this.writeModel.set(string);
        }
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.remove(singletonModelListener);
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.add(singletonModelListener);
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void setModel(SingletonModel singletonModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = singletonModel;
        WritableSingletonModel writableSingletonModel = this.writeModel = this.model instanceof WritableSingletonModel ? (WritableSingletonModel)singletonModel : null;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
            this.updateText();
        }
    }

    public SingletonModel getModel() {
        return this.model;
    }
}

