/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.dx.text.ItemFormatter;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.view.TextItemEditor;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.swing.JScrollPane;

public class ExpandingTextItemEditor
extends TextItemEditor
implements Serializable {
    private Rectangle startRect;
    private int hMargin = 5;

    private Rectangle getHostBounds() {
        Container container = this.getParent();
        Container container2 = container.getParent();
        if (container2 instanceof ScrollPane) {
            Point point = ((ScrollPane)container2).getScrollPosition();
            Dimension dimension = ((ScrollPane)container2).getViewportSize();
            return new Rectangle(point.x, point.y, dimension.width, dimension.height);
        }
        if (container2 instanceof JScrollPane) {
            return new Rectangle(((JScrollPane)container2).getViewport().getViewRect());
        }
        Rectangle rectangle = container.getBounds();
        if (rectangle == null) {
            return new Rectangle();
        }
        rectangle.x = 0;
        rectangle.y = 0;
        return rectangle;
    }

    private void resizeComponent() {
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.width != dimension.width && dimension.width > this.startRect.width) {
            Dimension dimension3 = new Dimension(0, dimension2.height);
            Rectangle rectangle = this.getHostBounds();
            dimension3.width = dimension.width + this.hMargin < rectangle.width + rectangle.x - this.getLocation().x ? dimension.width + this.hMargin : rectangle.width + rectangle.x - this.getLocation().x;
            this.setSize(dimension3);
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.getID() == 401) {
            this.resizeComponent();
        }
    }

    public void changeBounds(Rectangle rectangle) {
        this.setLocation(rectangle.x, rectangle.y);
        this.resizeComponent();
    }

    public void startEdit(Object object, Rectangle rectangle, ItemEditSite itemEditSite) {
        rectangle.width += this.hMargin;
        this.startRect = new Rectangle(rectangle);
        super.startEdit(object, rectangle, itemEditSite);
        this.resizeComponent();
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        int n3 = this.getCaretPosition();
        this.setCaretPosition(0);
        this.setCaretPosition(n3);
        this.setSelectionStart(n);
        this.setSelectionEnd(n2);
    }

    public void setHMargin(int n) {
        this.hMargin = n;
    }

    public int getHMargin() {
        return this.hMargin;
    }

    public ExpandingTextItemEditor() {
    }

    public ExpandingTextItemEditor(int n) {
        super(n);
    }

    public ExpandingTextItemEditor(int n, ItemFormatter itemFormatter) {
        super(n, itemFormatter);
    }
}

