/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonModelMulticaster;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.view.SingletonModelView;
import java.awt.Checkbox;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CheckboxView
extends Checkbox
implements Serializable,
SingletonModelView,
SingletonModelListener {
    private boolean readOnly;
    private transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();
    private transient WritableSingletonModel writeModel;
    private transient SingletonModel model;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof SingletonModel) {
            this.model = (SingletonModel)object;
        }
        if (this.model instanceof WritableSingletonModel) {
            this.writeModel = (WritableSingletonModel)this.model;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    public void set(Object object) {
        if (!this.isReadOnly()) {
            this.writeModel.set(object);
        }
    }

    public boolean canSet() {
        return this.isReadOnly() ? false : this.writeModel.canSet(true);
    }

    public Object get() {
        return this.model.get();
    }

    public void setChecked(boolean bl) {
        boolean bl2;
        if (!this.isReadOnly() && (bl2 = this.isChecked()) != bl) {
            Object object = this.model.get();
            if (object instanceof Boolean) {
                this.writeModel.set(new Boolean(bl));
            } else if (object instanceof Number) {
                this.writeModel.set(new Integer(bl ? 1 : 0));
            } else if (object instanceof String) {
                this.writeModel.set(new Boolean(bl).toString());
            } else {
                this.writeModel.set(new Boolean(bl));
            }
        }
    }

    public void setState(boolean bl) {
        if (!this.isReadOnly()) {
            super.setState(bl);
            this.setChecked(bl);
        }
    }

    public boolean isChecked() {
        Object object = this.model.get();
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        return false;
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        super.processItemEvent(itemEvent);
        this.setChecked(this.getState());
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        boolean bl = this.isChecked();
        if (bl != this.getState()) {
            super.setState(bl);
        }
    }

    public void setReadOnly(boolean bl) {
        this.setEnabled(!bl);
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.remove(singletonModelListener);
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.add(singletonModelListener);
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void setModel(SingletonModel singletonModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = singletonModel;
        WritableSingletonModel writableSingletonModel = this.writeModel = singletonModel instanceof WritableSingletonModel ? (WritableSingletonModel)singletonModel : null;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
            this.modelContentChanged(null);
        }
        this.enableEvents(512L);
    }

    public SingletonModel getModel() {
        return this.model;
    }
}

