/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.util;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class KeyMulticaster
implements KeyListener {
    private transient KeyListener[] listeners;

    public final synchronized void remove(KeyListener keyListener) {
        int n = this.find(keyListener);
        if (n > -1) {
            if (this.listeners.length == 1) {
                this.listeners = null;
            } else {
                KeyListener[] keyListenerArray = new KeyListener[this.listeners.length - 1];
                System.arraycopy(this.listeners, 0, keyListenerArray, 0, n);
                if (n < keyListenerArray.length) {
                    System.arraycopy(this.listeners, n + 1, keyListenerArray, n, keyListenerArray.length - n);
                }
                this.listeners = keyListenerArray;
            }
        }
    }

    public final synchronized void add(KeyListener keyListener) {
        if (this.find(keyListener) < 0) {
            KeyListener[] keyListenerArray;
            if (this.listeners == null) {
                keyListenerArray = new KeyListener[1];
            } else {
                keyListenerArray = new KeyListener[this.listeners.length + 1];
                System.arraycopy(this.listeners, 0, keyListenerArray, 0, this.listeners.length);
            }
            keyListenerArray[keyListenerArray.length - 1] = keyListener;
            this.listeners = keyListenerArray;
        }
    }

    public int find(KeyListener keyListener) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != keyListener) continue;
                return i;
            }
        }
        return -1;
    }

    public final void dispatch(KeyEvent keyEvent) {
        KeyListener[] keyListenerArray = this.listeners;
        if (keyListenerArray != null) {
            int n = keyListenerArray.length;
            block5: for (int i = 0; i < n; ++i) {
                switch (keyEvent.getID()) {
                    case 400: {
                        keyListenerArray[i].keyTyped(keyEvent);
                        continue block5;
                    }
                    case 401: {
                        keyListenerArray[i].keyPressed(keyEvent);
                        continue block5;
                    }
                    case 402: {
                        keyListenerArray[i].keyReleased(keyEvent);
                    }
                }
            }
        }
    }

    public final boolean hasListeners() {
        return this.listeners != null;
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.listeners != null) {
            this.dispatch(keyEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.listeners != null) {
            this.dispatch(keyEvent);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.listeners != null) {
            this.dispatch(keyEvent);
        }
    }
}

