/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class FocusMulticaster
implements FocusListener {
    private transient FocusListener[] listeners;

    public final synchronized void remove(FocusListener focusListener) {
        int n = this.find(focusListener);
        if (n > -1) {
            if (this.listeners.length == 1) {
                this.listeners = null;
            } else {
                FocusListener[] focusListenerArray = new FocusListener[this.listeners.length - 1];
                System.arraycopy(this.listeners, 0, focusListenerArray, 0, n);
                if (n < focusListenerArray.length) {
                    System.arraycopy(this.listeners, n + 1, focusListenerArray, n, focusListenerArray.length - n);
                }
                this.listeners = focusListenerArray;
            }
        }
    }

    public final synchronized void add(FocusListener focusListener) {
        if (this.find(focusListener) < 0) {
            FocusListener[] focusListenerArray;
            if (this.listeners == null) {
                focusListenerArray = new FocusListener[1];
            } else {
                focusListenerArray = new FocusListener[this.listeners.length + 1];
                System.arraycopy(this.listeners, 0, focusListenerArray, 0, this.listeners.length);
            }
            focusListenerArray[focusListenerArray.length - 1] = focusListener;
            this.listeners = focusListenerArray;
        }
    }

    public int find(FocusListener focusListener) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != focusListener) continue;
                return i;
            }
        }
        return -1;
    }

    public final void dispatch(FocusEvent focusEvent) {
        FocusListener[] focusListenerArray = this.listeners;
        if (focusListenerArray != null) {
            int n = focusListenerArray.length;
            block4: for (int i = 0; i < n; ++i) {
                switch (focusEvent.getID()) {
                    case 1004: {
                        focusListenerArray[i].focusGained(focusEvent);
                        continue block4;
                    }
                    case 1005: {
                        focusListenerArray[i].focusLost(focusEvent);
                    }
                }
            }
        }
    }

    public final boolean hasListeners() {
        return this.listeners != null;
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.listeners != null) {
            this.dispatch(focusEvent);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.listeners != null) {
            this.dispatch(focusEvent);
        }
    }
}

