/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.util;

import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class AdjustmentMulticaster
implements AdjustmentListener {
    private transient AdjustmentListener[] listeners;

    public final synchronized void remove(AdjustmentListener adjustmentListener) {
        int n = this.find(adjustmentListener);
        if (n > -1) {
            if (this.listeners.length == 1) {
                this.listeners = null;
            } else {
                AdjustmentListener[] adjustmentListenerArray = new AdjustmentListener[this.listeners.length - 1];
                System.arraycopy(this.listeners, 0, adjustmentListenerArray, 0, n);
                if (n < adjustmentListenerArray.length) {
                    System.arraycopy(this.listeners, n + 1, adjustmentListenerArray, n, adjustmentListenerArray.length - n);
                }
                this.listeners = adjustmentListenerArray;
            }
        }
    }

    public final synchronized void add(AdjustmentListener adjustmentListener) {
        if (this.find(adjustmentListener) < 0) {
            AdjustmentListener[] adjustmentListenerArray;
            if (this.listeners == null) {
                adjustmentListenerArray = new AdjustmentListener[1];
            } else {
                adjustmentListenerArray = new AdjustmentListener[this.listeners.length + 1];
                System.arraycopy(this.listeners, 0, adjustmentListenerArray, 0, this.listeners.length);
            }
            adjustmentListenerArray[adjustmentListenerArray.length - 1] = adjustmentListener;
            this.listeners = adjustmentListenerArray;
        }
    }

    public int find(AdjustmentListener adjustmentListener) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != adjustmentListener) continue;
                return i;
            }
        }
        return -1;
    }

    public final void dispatch(AdjustmentEvent adjustmentEvent) {
        AdjustmentListener[] adjustmentListenerArray = this.listeners;
        if (adjustmentListenerArray != null) {
            int n = adjustmentListenerArray.length;
            for (int i = 0; i < n; ++i) {
                adjustmentListenerArray[i].adjustmentValueChanged(adjustmentEvent);
            }
        }
    }

    public final boolean hasListeners() {
        return this.listeners != null;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.listeners != null) {
            this.dispatch(adjustmentEvent);
        }
    }
}

