/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.sql.monitor;

import java.awt.TextArea;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.DriverManager;

class TextAreaStream
extends PrintStream {
    int length = 0;
    int maxLength = 8096;
    boolean enabled = false;
    TextArea textArea;

    public void println(String string) {
        if (this.enabled) {
            int n = string.length() + 1;
            if (this.length + n > this.maxLength) {
                this.textArea.replaceRange("", 0, n);
                this.length = this.maxLength;
            } else {
                this.length += n;
            }
            this.textArea.append(String.valueOf(string).concat(String.valueOf("\n")));
        }
    }

    void resetLength() {
        this.length = 0;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (bl) {
            DriverManager.setLogStream(this);
        } else {
            DriverManager.setLogStream(null);
        }
    }

    public TextAreaStream(TextArea textArea) {
        super(new ByteArrayOutputStream());
        this.textArea = textArea;
    }
}

