/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.sql.monitor;

import com.borland.jbcl.sql.monitor.Res;
import com.borland.jbcl.sql.monitor.TextAreaStream;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class MonitorPanel
extends Panel
implements ItemListener,
ActionListener {
    protected TextAreaStream textAreaStream;
    protected BorderLayout southPanelLayout;
    protected Panel southPanel;
    protected Panel outerButtonPanel;
    protected GridLayout gridLayout;
    protected Panel buttonPanel;
    protected Checkbox enableOutputCheckbox;
    protected Button saveButton;
    protected Button clearButton;
    protected TextArea textArea;
    protected BorderLayout borderLayout1 = new BorderLayout();
    public final int hlpSourceDialog = 1;
    public final int hlpMonitorPanel = 0;

    private void saveToFile() {
        Container container = this;
        while (!(container instanceof Frame)) {
            container = container.getParent();
        }
        if (container == null) {
            container = new Frame();
        }
        FileDialog fileDialog = new FileDialog((Frame)container, Res.getString(3), 1);
        Button button = this.saveButton;
        Point point = button.getLocationOnScreen();
        point.y += button.getSize().height;
        ((Component)fileDialog).setLocation(point);
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getDirectory() != null && fileDialog.getFile() != null) {
            try {
                File file = new File(String.valueOf(fileDialog.getDirectory()).concat(String.valueOf(fileDialog.getFile())));
                if (file != null) {
                    PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file), 1024));
                    if (this.textArea.getSelectionEnd() - this.textArea.getSelectionStart() == 0) {
                        printWriter.println(this.textArea.getText());
                    } else {
                        printWriter.println(this.textArea.getSelectedText());
                    }
                    printWriter.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.saveButton) {
            this.saveToFile();
        } else if (actionEvent.getSource() == this.clearButton) {
            if (this.textArea.getSelectionEnd() - this.textArea.getSelectionStart() == 0) {
                this.textArea.setText("");
            } else {
                this.textArea.replaceRange("", this.textArea.getSelectionStart(), this.textArea.getSelectionEnd());
            }
            this.textAreaStream.resetLength();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.enableOutputCheckbox) {
            this.textAreaStream.setEnabled(this.enableOutputCheckbox.getState());
        }
    }

    public int getMaxLogSize() {
        return this.textAreaStream.getMaxLength();
    }

    public void setMaxLogSize(int n) {
        this.textAreaStream.setMaxLength(n);
    }

    public boolean isOutputEnabled() {
        return this.textAreaStream.isEnabled();
    }

    public void setOutputEnabled(boolean bl) {
        this.textAreaStream.setEnabled(bl);
    }

    public void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setBackground(SystemColor.control);
        this.setForeground(SystemColor.controlText);
        this.gridLayout.setHgap(5);
        this.buttonPanel.setLayout(this.gridLayout);
        this.buttonPanel.add(this.saveButton);
        this.buttonPanel.add(this.clearButton);
        this.outerButtonPanel.add(this.buttonPanel);
        this.saveButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.southPanel.setLayout(this.southPanelLayout);
        this.southPanel.add((Component)this.outerButtonPanel, "South");
        this.southPanel.add((Component)this.enableOutputCheckbox, "Center");
        this.enableOutputCheckbox.setState(true);
        this.enableOutputCheckbox.addItemListener(this);
        this.textAreaStream.setEnabled(true);
        this.textArea.setEditable(false);
        this.add((Component)this.textArea, "Center");
        this.add((Component)this.southPanel, "South");
    }

    public MonitorPanel() {
        this.textArea = new TextArea(20, 80);
        this.clearButton = new Button(Res.getString(2));
        this.saveButton = new Button(Res.getString(1));
        this.enableOutputCheckbox = new Checkbox(Res.getString(0));
        this.buttonPanel = new Panel();
        this.gridLayout = new GridLayout(1, 2);
        this.outerButtonPanel = new Panel();
        this.southPanel = new Panel();
        this.southPanelLayout = new BorderLayout();
        this.textAreaStream = new TextAreaStream(this.textArea);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

