/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphViewManager;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.MatrixViewManager;
import com.borland.jbcl.model.SingletonViewManager;
import com.borland.jbcl.model.VectorViewManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class TypedViewManager
implements Serializable,
GraphViewManager,
MatrixViewManager,
VectorViewManager,
SingletonViewManager {
    transient Hashtable editors;
    transient Hashtable painters = new Hashtable();
    transient ItemEditor defaultEditor;
    transient ItemPainter defaultPainter;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
        Object v = hashtable.get("dp");
        if (v instanceof ItemPainter) {
            this.defaultPainter = (ItemPainter)v;
        }
        if ((v = hashtable.get("de")) instanceof ItemEditor) {
            this.defaultEditor = (ItemEditor)v;
        }
        this.painters = (Hashtable)objectInputStream.readObject();
        this.editors = (Hashtable)objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        objectOutputStream.defaultWriteObject();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(8);
        if (this.defaultPainter instanceof Serializable) {
            hashtable.put("dp", this.defaultPainter);
        }
        if (this.defaultEditor instanceof Serializable) {
            hashtable.put("de", this.defaultEditor);
        }
        Enumeration enumeration = this.painters.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (this.painters.get(object) instanceof Serializable) continue;
            this.painters.remove(object);
        }
        object = this.editors.keys();
        while (object.hasMoreElements()) {
            Object e = object.nextElement();
            if (this.editors.get(e) instanceof Serializable) continue;
            this.editors.remove(e);
        }
        objectOutputStream.writeObject(hashtable);
        objectOutputStream.writeObject(this.painters);
        objectOutputStream.writeObject(this.editors);
    }

    public ItemEditor getEditor(GraphLocation graphLocation, Object object, int n) {
        return this.getEditor(object, n);
    }

    public ItemPainter getPainter(GraphLocation graphLocation, Object object, int n) {
        return this.getPainter(object, n);
    }

    public ItemEditor getEditor(int n, int n2, Object object, int n3) {
        return this.getEditor(object, n3);
    }

    public ItemPainter getPainter(int n, int n2, Object object, int n3) {
        return this.getPainter(object, n3);
    }

    public ItemEditor getEditor(int n, Object object, int n2) {
        return this.getEditor(object, n2);
    }

    public ItemPainter getPainter(int n, Object object, int n2) {
        return this.getPainter(object, n2);
    }

    public ItemEditor getEditor(Object object, int n) {
        try {
            ItemEditor itemEditor = (ItemEditor)this.editors.get(object.getClass());
            if (itemEditor != null) {
                ItemEditor itemEditor2 = itemEditor;
                return itemEditor2;
            }
            Object object2 = this.editors.keys();
            while (object2.hasMoreElements()) {
                Class clazz = (Class)object2.nextElement();
                if (!clazz.isInstance(object)) continue;
                ItemEditor itemEditor3 = (ItemEditor)this.editors.get(clazz);
                return itemEditor3;
            }
            object2 = this.defaultEditor;
            return object2;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    public ItemPainter getPainter(Object object, int n) {
        try {
            ItemPainter itemPainter = (ItemPainter)this.painters.get(object.getClass());
            if (itemPainter != null) {
                ItemPainter itemPainter2 = itemPainter;
                return itemPainter2;
            }
            Object object2 = this.painters.keys();
            while (object2.hasMoreElements()) {
                Class clazz = (Class)object2.nextElement();
                if (!clazz.isInstance(object)) continue;
                ItemPainter itemPainter3 = (ItemPainter)this.painters.get(clazz);
                return itemPainter3;
            }
            object2 = this.defaultPainter;
            return object2;
        }
        catch (Exception exception) {
            System.err.println(exception);
            ItemPainter itemPainter = null;
            return itemPainter;
        }
    }

    public boolean add(Class clazz, ItemPainter itemPainter, ItemEditor itemEditor) {
        if (itemPainter != null) {
            if (clazz == null) {
                this.defaultPainter = itemPainter;
            } else {
                this.painters.put(clazz, itemPainter);
            }
        }
        if (itemEditor != null) {
            if (clazz == null) {
                this.defaultEditor = itemEditor;
            } else {
                this.editors.put(clazz, itemEditor);
            }
        }
        return true;
    }

    public TypedViewManager() {
        this.editors = new Hashtable();
    }
}

