/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;

public class MatrixSelectionMulticaster
implements MatrixSelectionListener {
    private transient MatrixSelectionListener[] listeners;

    public final synchronized void remove(MatrixSelectionListener matrixSelectionListener) {
        int n = this.find(matrixSelectionListener);
        if (n > -1) {
            if (this.listeners.length == 1) {
                this.listeners = null;
            } else {
                MatrixSelectionListener[] matrixSelectionListenerArray = new MatrixSelectionListener[this.listeners.length - 1];
                System.arraycopy(this.listeners, 0, matrixSelectionListenerArray, 0, n);
                if (n < matrixSelectionListenerArray.length) {
                    System.arraycopy(this.listeners, n + 1, matrixSelectionListenerArray, n, matrixSelectionListenerArray.length - n);
                }
                this.listeners = matrixSelectionListenerArray;
            }
        }
    }

    public final synchronized void add(MatrixSelectionListener matrixSelectionListener) {
        if (this.find(matrixSelectionListener) < 0) {
            MatrixSelectionListener[] matrixSelectionListenerArray;
            if (this.listeners == null) {
                matrixSelectionListenerArray = new MatrixSelectionListener[1];
            } else {
                matrixSelectionListenerArray = new MatrixSelectionListener[this.listeners.length + 1];
                System.arraycopy(this.listeners, 0, matrixSelectionListenerArray, 0, this.listeners.length);
            }
            matrixSelectionListenerArray[matrixSelectionListenerArray.length - 1] = matrixSelectionListener;
            this.listeners = matrixSelectionListenerArray;
        }
    }

    public int find(MatrixSelectionListener matrixSelectionListener) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != matrixSelectionListener) continue;
                return i;
            }
        }
        return -1;
    }

    public final void dispatch(MatrixSelectionEvent matrixSelectionEvent) {
        MatrixSelectionListener[] matrixSelectionListenerArray = this.listeners;
        if (matrixSelectionListenerArray != null) {
            int n = matrixSelectionListenerArray.length;
            block5: for (int i = 0; i < n; ++i) {
                switch (matrixSelectionEvent.getID()) {
                    case 4096: {
                        matrixSelectionListenerArray[i].selectionItemChanged(matrixSelectionEvent);
                        continue block5;
                    }
                    case 8192: {
                        matrixSelectionListenerArray[i].selectionRangeChanged(matrixSelectionEvent);
                        continue block5;
                    }
                    case 12288: {
                        matrixSelectionListenerArray[i].selectionChanged(matrixSelectionEvent);
                    }
                }
            }
        }
    }

    public final boolean hasListeners() {
        return this.listeners != null;
    }

    public void selectionChanged(MatrixSelectionEvent matrixSelectionEvent) {
        if (this.listeners != null) {
            this.dispatch(matrixSelectionEvent);
        }
    }

    public void selectionRangeChanged(MatrixSelectionEvent matrixSelectionEvent) {
        if (this.listeners != null) {
            this.dispatch(matrixSelectionEvent);
        }
    }

    public void selectionItemChanged(MatrixSelectionEvent matrixSelectionEvent) {
        if (this.listeners != null) {
            this.dispatch(matrixSelectionEvent);
        }
    }
}

