/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixModel;
import com.borland.jbcl.model.MatrixModelListener;
import com.borland.jbcl.model.ModelEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class MatrixModelEvent
extends ModelEvent
implements Serializable {
    private int change;
    private MatrixLocation location;
    private transient MatrixModel model;
    public static final int COLUMN_REMOVED = 66;
    public static final int COLUMN_ADDED = 50;
    public static final int ROW_REMOVED = 34;
    public static final int ROW_ADDED = 18;
    public static final int COLUMN_CHANGED = 65;
    public static final int ROW_CHANGED = 49;
    public static final int ITEM_TOUCHED = 33;
    public static final int ITEM_CHANGED = 17;
    public static final int STRUCTURE_CHANGED = 2;
    public static final int CONTENT_CHANGED = 1;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof MatrixModel) {
            this.model = (MatrixModel)object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    protected String paramString() {
        String string;
        switch (this.change) {
            case 1: {
                string = "CONTENT_CHANGED";
                break;
            }
            case 2: {
                string = "STRUCTURE_CHANGED";
                break;
            }
            case 17: {
                string = "ITEM_CHANGED";
                break;
            }
            case 33: {
                string = "ITEM_TOUCHED";
                break;
            }
            case 49: {
                string = "ROW_CHANGED";
                break;
            }
            case 65: {
                string = "COLUMN_CHANGED";
                break;
            }
            case 18: {
                string = "ROW_ADDED";
                break;
            }
            case 34: {
                string = "ROW_REMOVED";
                break;
            }
            case 50: {
                string = "COLUMN_ADDED";
                break;
            }
            case 66: {
                string = "COLUMN_REMOVED";
                break;
            }
            default: {
                string = "<INVALID>";
            }
        }
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(super.paramString()).concat(String.valueOf(",model="))).concat(String.valueOf(this.model))).concat(String.valueOf(",change="))).concat(String.valueOf(string))).concat(String.valueOf(",location="))).concat(String.valueOf(this.location));
    }

    public void dispatch(EventListener eventListener) {
        switch (this.getID()) {
            case 1: {
                ((MatrixModelListener)eventListener).modelContentChanged(this);
                break;
            }
            case 2: {
                ((MatrixModelListener)eventListener).modelStructureChanged(this);
                break;
            }
        }
    }

    public MatrixLocation getLocation() {
        return this.location;
    }

    public int getChange() {
        return this.change;
    }

    public MatrixModel getModel() {
        return this.model;
    }

    public MatrixModelEvent(MatrixModel matrixModel, int n, MatrixLocation matrixLocation) {
        this(matrixModel, n);
        this.location = matrixLocation;
    }

    public MatrixModelEvent(MatrixModel matrixModel, int n) {
        super(matrixModel, n);
        this.model = matrixModel;
        this.change = n;
    }
}

