/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.LinkedTreeIterator;
import com.borland.jbcl.model.Res;
import com.objectspace.jgl.ForwardIterator;
import java.io.Serializable;

public class LinkedTreeNode
implements Serializable,
GraphLocation {
    protected int childCount;
    protected LinkedTreeNode firstChild;
    protected LinkedTreeNode nextSibling;
    protected LinkedTreeNode parent;

    public void check() {
        LinkedTreeNode linkedTreeNode = this.firstChild;
        while (linkedTreeNode != null) {
            if (linkedTreeNode.parent != this) {
                throw new IllegalStateException(Res.format(21, new Object[]{linkedTreeNode, this}));
            }
            if (linkedTreeNode.nextSibling == this.firstChild) {
                throw new IllegalStateException(Res.format(16, new Object[]{this, linkedTreeNode}));
            }
            linkedTreeNode = linkedTreeNode.nextSibling;
        }
    }

    public void print(int n) {
        for (int i = 0; i < 2 * n; ++i) {
            System.err.print(" ");
        }
        System.err.println(String.valueOf(String.valueOf(this).concat(String.valueOf(" L"))).concat(String.valueOf(n)));
        if (this.firstChild != null) {
            this.firstChild.print(n + 1);
        }
        if (this.nextSibling != null) {
            this.nextSibling.print(n);
        }
    }

    public void print() {
        this.print(0);
    }

    protected void setParent(LinkedTreeNode linkedTreeNode) {
        this.parent = linkedTreeNode;
    }

    public LinkedTreeNode removeNode(LinkedTreeNode linkedTreeNode) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        } else if (this == linkedTreeNode) {
            linkedTreeNode = this.nextSibling;
        } else {
            LinkedTreeNode linkedTreeNode2 = linkedTreeNode;
            while (linkedTreeNode2.nextSibling != this) {
                linkedTreeNode2 = linkedTreeNode2.nextSibling;
            }
            linkedTreeNode2.nextSibling = this.nextSibling;
        }
        this.nextSibling = null;
        return linkedTreeNode;
    }

    public void removeChild(LinkedTreeNode linkedTreeNode) {
        if (this.firstChild == linkedTreeNode) {
            this.firstChild = linkedTreeNode.nextSibling;
        } else if (this.firstChild != null) {
            LinkedTreeNode linkedTreeNode2 = this.firstChild;
            while (true) {
                if (linkedTreeNode2.nextSibling == linkedTreeNode) {
                    linkedTreeNode2.nextSibling = linkedTreeNode.nextSibling;
                    break;
                }
                if (linkedTreeNode2.nextSibling == null) {
                    throw new IllegalArgumentException(Res.format(20, new Object[]{linkedTreeNode, this}));
                }
                linkedTreeNode2 = linkedTreeNode2.nextSibling;
            }
        }
        linkedTreeNode.setParent(null);
        linkedTreeNode.nextSibling = null;
        --this.childCount;
    }

    public void insertSibling(LinkedTreeNode linkedTreeNode) {
        LinkedTreeNode linkedTreeNode2 = linkedTreeNode;
        while (true) {
            if (linkedTreeNode2.parent != null) {
                throw new IllegalArgumentException(Res.format(18, new Object[]{linkedTreeNode2, linkedTreeNode2.parent}));
            }
            if (linkedTreeNode2.nextSibling == this) {
                throw new IllegalStateException(Res.format(19, new Object[]{this, linkedTreeNode}));
            }
            linkedTreeNode2.setParent(this.parent);
            if (linkedTreeNode2.nextSibling == null) break;
            ++this.childCount;
            linkedTreeNode2 = linkedTreeNode2.nextSibling;
        }
        linkedTreeNode2.nextSibling = this.nextSibling;
        this.nextSibling = linkedTreeNode;
    }

    protected void doAddChild(LinkedTreeNode linkedTreeNode, LinkedTreeNode linkedTreeNode2) {
        LinkedTreeNode linkedTreeNode3 = linkedTreeNode;
        while (true) {
            if (linkedTreeNode3.parent == null) {
                linkedTreeNode3.setParent(this);
                ++this.childCount;
            } else if (linkedTreeNode3.parent != this) {
                throw new IllegalArgumentException(Res.format(15, new Object[]{String.valueOf(linkedTreeNode3), String.valueOf(this), String.valueOf(linkedTreeNode3.parent)}));
            }
            if (linkedTreeNode3.nextSibling == null) break;
            linkedTreeNode3 = linkedTreeNode3.nextSibling;
        }
        if (this.firstChild != null && this.firstChild != linkedTreeNode2) {
            LinkedTreeNode linkedTreeNode4 = this.firstChild;
            while (true) {
                if (linkedTreeNode4.nextSibling == this.firstChild) {
                    throw new IllegalStateException(Res.format(16, new Object[]{this, linkedTreeNode4}));
                }
                if (linkedTreeNode4.nextSibling == linkedTreeNode) {
                    throw new IllegalStateException(Res.format(17, new Object[]{this, linkedTreeNode}));
                }
                if (linkedTreeNode4.nextSibling == null || linkedTreeNode4.nextSibling == linkedTreeNode2) {
                    linkedTreeNode3.nextSibling = linkedTreeNode4.nextSibling;
                    linkedTreeNode4.nextSibling = linkedTreeNode;
                    return;
                }
                linkedTreeNode4 = linkedTreeNode4.nextSibling;
            }
        }
        linkedTreeNode3.nextSibling = this.firstChild;
        this.firstChild = linkedTreeNode;
    }

    public void insertChild(LinkedTreeNode linkedTreeNode, LinkedTreeNode linkedTreeNode2) {
        this.doAddChild(linkedTreeNode, linkedTreeNode2);
    }

    public void insertChild(LinkedTreeNode linkedTreeNode) {
        this.doAddChild(linkedTreeNode, this.firstChild);
    }

    public void appendChild(LinkedTreeNode linkedTreeNode) {
        this.doAddChild(linkedTreeNode, null);
    }

    public LinkedTreeNode getNextSibling() {
        return this.nextSibling;
    }

    public ForwardIterator getChildIterator() {
        return new LinkedTreeIterator(this.firstChild);
    }

    public LinkedTreeNode getFirstChild() {
        return this.firstChild;
    }

    public GraphLocation[] getChildren() {
        GraphLocation[] graphLocationArray = new GraphLocation[this.childCount];
        int n = 0;
        ForwardIterator forwardIterator = this.getChildIterator();
        while (!forwardIterator.atEnd()) {
            if (n >= graphLocationArray.length) {
                this.childCount = n + 1;
                GraphLocation[] graphLocationArray2 = new GraphLocation[this.childCount];
                System.arraycopy(graphLocationArray, 0, graphLocationArray2, 0, this.childCount - 1);
                graphLocationArray = graphLocationArray2;
            }
            graphLocationArray[n++] = (GraphLocation)forwardIterator.get();
            forwardIterator.advance();
        }
        return graphLocationArray;
    }

    public int hasChildren() {
        return this.firstChild != null ? 1 : 0;
    }

    public GraphLocation getParent() {
        return this.parent;
    }

    public LinkedTreeNode(LinkedTreeNode linkedTreeNode) {
        this.parent = linkedTreeNode;
    }

    public LinkedTreeNode() {
    }
}

