/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphModelEvent;
import com.borland.jbcl.model.GraphModelListener;
import com.borland.jbcl.model.LinkedTreeNode;
import com.borland.jbcl.model.WritableGraphModel;
import com.objectspace.jgl.Array;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import java.io.Serializable;
import java.util.EventListener;

public class LinkedTreeContainer
implements Serializable,
WritableGraphModel {
    protected boolean events = true;
    protected transient EventMulticaster listeners = new EventMulticaster();
    protected LinkedTreeNode root;

    public void processModelEvent(GraphModelEvent graphModelEvent) {
        if (this.events && this.listeners.hasListeners()) {
            this.listeners.dispatch((DispatchableEvent)graphModelEvent);
        }
    }

    protected void fillNodes(LinkedTreeNode linkedTreeNode, Array array) {
        while (linkedTreeNode != null) {
            array.add((Object)linkedTreeNode);
            if (linkedTreeNode.firstChild != null) {
                this.fillNodes(linkedTreeNode.firstChild, array);
            }
            linkedTreeNode = linkedTreeNode.nextSibling;
        }
    }

    public InputIterator elements() {
        Array array = new Array();
        this.fillNodes(this.root, array);
        return array.begin();
    }

    public void enableModelEvents(boolean bl) {
        if (this.events != bl) {
            this.events = bl;
            if (bl) {
                this.processModelEvent(new GraphModelEvent(this, 2));
            }
        }
    }

    public void removeAll() {
        this.root = null;
        this.processModelEvent(new GraphModelEvent(this, 2));
    }

    public void remove(GraphLocation graphLocation) {
        LinkedTreeNode linkedTreeNode = (LinkedTreeNode)graphLocation;
        if (linkedTreeNode.parent != null) {
            linkedTreeNode.parent.removeChild(linkedTreeNode);
            this.processModelEvent(new GraphModelEvent(this, 34, graphLocation));
        } else if (linkedTreeNode == this.root) {
            this.root = null;
            this.processModelEvent(new GraphModelEvent(this, 2));
        }
    }

    public void removeChildren(GraphLocation graphLocation) {
        ForwardIterator forwardIterator = ((LinkedTreeNode)graphLocation).getChildIterator();
        while (!forwardIterator.atEnd()) {
            LinkedTreeNode linkedTreeNode = (LinkedTreeNode)forwardIterator.get();
            forwardIterator.advance();
            linkedTreeNode.parent.removeChild(linkedTreeNode);
        }
        this.processModelEvent(new GraphModelEvent(this, 50, graphLocation));
    }

    public GraphLocation addChild(GraphLocation graphLocation, GraphLocation graphLocation2, Object object) {
        ((LinkedTreeNode)graphLocation).insertChild((LinkedTreeNode)object, (LinkedTreeNode)graphLocation2);
        this.processModelEvent(new GraphModelEvent(this, 18, (GraphLocation)object));
        return (GraphLocation)object;
    }

    public GraphLocation addChild(GraphLocation graphLocation, Object object) {
        ((LinkedTreeNode)graphLocation).appendChild((LinkedTreeNode)object);
        this.processModelEvent(new GraphModelEvent(this, 18, (GraphLocation)object));
        return (GraphLocation)object;
    }

    public boolean isVariableSize() {
        return true;
    }

    public void touched(GraphLocation graphLocation) {
        this.processModelEvent(new GraphModelEvent(this, 33, graphLocation));
    }

    public void set(GraphLocation graphLocation, Object object) {
        if (graphLocation != object) {
            LinkedTreeNode linkedTreeNode = (LinkedTreeNode)graphLocation;
            linkedTreeNode.parent.insertChild((LinkedTreeNode)object, linkedTreeNode);
            linkedTreeNode.parent.removeChild(linkedTreeNode);
            this.processModelEvent(new GraphModelEvent(this, 50, graphLocation));
        } else {
            this.processModelEvent(new GraphModelEvent(this, 17, graphLocation));
        }
    }

    public boolean canSet(GraphLocation graphLocation) {
        return true;
    }

    public GraphLocation setRoot(Object object) {
        this.root = (LinkedTreeNode)object;
        this.processModelEvent(new GraphModelEvent(this, 2));
        return this.root;
    }

    public void removeModelListener(GraphModelListener graphModelListener) {
        this.listeners.remove((EventListener)graphModelListener);
    }

    public void addModelListener(GraphModelListener graphModelListener) {
        this.listeners.add((EventListener)graphModelListener);
    }

    public GraphLocation find(Object object) {
        if (object instanceof GraphLocation) {
            return (GraphLocation)object;
        }
        return null;
    }

    public Object get(GraphLocation graphLocation) {
        return graphLocation;
    }

    public GraphLocation getRoot() {
        return this.root;
    }

    public LinkedTreeContainer(LinkedTreeNode linkedTreeNode) {
        this.root = linkedTreeNode;
    }

    public LinkedTreeContainer() {
    }
}

