/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphModel;
import com.borland.jbcl.model.Res;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class GraphModelSearch
implements Serializable {
    protected boolean fullSearch = true;
    protected boolean depthFirstSearch = false;
    protected transient GraphModel model;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof GraphModel) {
            this.model = (GraphModel)object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    protected GraphLocation scanNodes(GraphLocation[] graphLocationArray, Object object) {
        this.checkModel();
        for (int i = 0; i < graphLocationArray.length; ++i) {
            if (!this.checkMatch(this.model.get(graphLocationArray[i]), object)) continue;
            return graphLocationArray[i];
        }
        return null;
    }

    protected boolean checkMatch(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    protected void checkModel() {
        if (this.model == null) {
            throw new IllegalStateException(Res.getString(26));
        }
    }

    public GraphLocation exactPathSearch(GraphLocation graphLocation, Object[] objectArray) {
        this.checkModel();
        if (objectArray.length < 1 || !this.checkMatch(this.model.get(graphLocation), objectArray[0])) {
            return null;
        }
        GraphLocation graphLocation2 = graphLocation;
        for (int i = 1; i < objectArray.length; ++i) {
            int n = graphLocation2.hasChildren();
            if (n == 0 || !this.fullSearch && n == -1) {
                return null;
            }
            GraphLocation[] graphLocationArray = graphLocation2.getChildren();
            GraphLocation graphLocation3 = this.scanNodes(graphLocationArray, objectArray[i]);
            if (graphLocation3 == null) {
                return null;
            }
            graphLocation2 = graphLocation3;
        }
        return graphLocation2;
    }

    public GraphLocation exactPathSearch(Object[] objectArray) {
        this.checkModel();
        if (objectArray != null && objectArray.length > 0) {
            return this.exactPathSearch(this.model.getRoot(), objectArray);
        }
        return null;
    }

    public GraphLocation partialPathSearch(GraphLocation graphLocation, Object[] objectArray) {
        this.checkModel();
        GraphLocation graphLocation2 = graphLocation;
        for (int i = 0; i < objectArray.length; ++i) {
            GraphLocation graphLocation3 = this.search(graphLocation2, objectArray[i]);
            if (graphLocation3 == null) {
                return graphLocation2;
            }
            graphLocation2 = graphLocation3;
        }
        return graphLocation2;
    }

    public GraphLocation partialPathSearch(Object[] objectArray) {
        this.checkModel();
        if (objectArray != null && objectArray.length > 0) {
            return this.partialPathSearch(this.model.getRoot(), objectArray);
        }
        return null;
    }

    public GraphLocation pathSearch(GraphLocation graphLocation, Object[] objectArray) {
        this.checkModel();
        GraphLocation graphLocation2 = graphLocation;
        for (int i = 0; i < objectArray.length; ++i) {
            GraphLocation graphLocation3 = this.search(graphLocation2, objectArray[i]);
            if (graphLocation3 == null) {
                return null;
            }
            graphLocation2 = graphLocation3;
        }
        return graphLocation2;
    }

    public GraphLocation pathSearch(Object[] objectArray) {
        this.checkModel();
        if (objectArray != null && objectArray.length > 0) {
            return this.pathSearch(this.model.getRoot(), objectArray);
        }
        return null;
    }

    public GraphLocation search(GraphLocation graphLocation, Object object) {
        GraphLocation graphLocation2;
        this.checkModel();
        if (this.checkMatch(this.model.get(graphLocation), object)) {
            return graphLocation;
        }
        int n = graphLocation.hasChildren();
        if (n == 0 || !this.fullSearch && n == -1) {
            return null;
        }
        GraphLocation[] graphLocationArray = graphLocation.getChildren();
        GraphLocation graphLocation3 = graphLocation2 = this.depthFirstSearch ? null : this.scanNodes(graphLocationArray, object);
        if (graphLocation2 != null) {
            return graphLocation2;
        }
        for (int i = 0; i < graphLocationArray.length; ++i) {
            graphLocation2 = this.search(graphLocationArray[i], object);
            if (graphLocation2 == null) continue;
            return graphLocation2;
        }
        return null;
    }

    public GraphLocation search(Object object) {
        this.checkModel();
        if (object instanceof GraphLocation) {
            return (GraphLocation)object;
        }
        return this.search(this.model.getRoot(), object);
    }

    public boolean isFullSearch() {
        return this.fullSearch;
    }

    public void setFullSearch(boolean bl) {
        this.fullSearch = bl;
    }

    public boolean isDepthFirstSearch() {
        return this.depthFirstSearch;
    }

    public void setDepthFirstSearch(boolean bl) {
        this.depthFirstSearch = bl;
    }

    public GraphModel getModel() {
        return this.model;
    }

    public void setModel(GraphModel graphModel) {
        this.model = graphModel;
    }

    public GraphModelSearch(GraphModel graphModel, boolean bl, boolean bl2) {
        this(graphModel, bl);
        this.fullSearch = bl2;
    }

    public GraphModelSearch(GraphModel graphModel, boolean bl) {
        this(graphModel);
        this.depthFirstSearch = bl;
    }

    public GraphModelSearch(GraphModel graphModel) {
        this.model = graphModel;
    }

    public GraphModelSearch() {
    }
}

