/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.WritableMatrixSelection;
import java.io.Serializable;
import java.util.EventListener;

public class ColumnMatrixSelection
implements Serializable,
WritableMatrixSelection {
    private boolean events = true;
    private transient EventMulticaster selectionListeners = new EventMulticaster();
    private int rows;
    private int cellColumn = -1;

    protected void processSelectionEvent(MatrixSelectionEvent matrixSelectionEvent) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch((DispatchableEvent)matrixSelectionEvent);
        }
    }

    public void enableSelectionEvents(boolean bl) {
        this.events = bl;
        if (this.events) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeAll() {
        if (this.cellColumn != -1) {
            this.cellColumn = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12289));
        }
    }

    public void removeRange(int n, int n2, int n3, int n4) {
        if (this.cellColumn != -1 && this.cellColumn >= n2 && this.cellColumn <= n4) {
            this.cellColumn = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeRange(MatrixLocation matrixLocation, MatrixLocation matrixLocation2) {
        this.removeRange(matrixLocation.row, matrixLocation.column, matrixLocation2.row, matrixLocation2.column);
    }

    public void remove(MatrixLocation[] matrixLocationArray) {
        if (this.cellColumn != -1) {
            for (int i = 0; i < matrixLocationArray.length; ++i) {
                if (matrixLocationArray[i].column != this.cellColumn) continue;
                this.cellColumn = -1;
                this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
                return;
            }
        }
    }

    public void remove(int n, int n2) {
        if (this.cellColumn != -1 && n2 == this.cellColumn) {
            this.cellColumn = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation matrixLocation) {
        if (this.cellColumn != -1 && matrixLocation.column == this.cellColumn) {
            this.cellColumn = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(int n, int n2, int n3, int n4) {
        if (this.cellColumn != n4) {
            this.cellColumn = n4;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(MatrixLocation matrixLocation, MatrixLocation matrixLocation2) {
        if (matrixLocation2.column != this.cellColumn) {
            this.cellColumn = matrixLocation2.column;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation[] matrixLocationArray) {
        if (matrixLocationArray.length > 0 && matrixLocationArray[0].column != this.cellColumn) {
            this.cellColumn = matrixLocationArray[0].column;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(int n, int n2) {
        if (n2 != this.cellColumn) {
            this.cellColumn = n2;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation matrixLocation) {
        if (matrixLocation.column != this.cellColumn) {
            this.cellColumn = matrixLocation.column;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void set(MatrixLocation[] matrixLocationArray) {
        this.add(matrixLocationArray);
    }

    public void removeSelectionListener(MatrixSelectionListener matrixSelectionListener) {
        this.selectionListeners.remove((EventListener)matrixSelectionListener);
    }

    public void addSelectionListener(MatrixSelectionListener matrixSelectionListener) {
        this.selectionListeners.add((EventListener)matrixSelectionListener);
    }

    public MatrixLocation[] getAll() {
        MatrixLocation[] matrixLocationArray = new MatrixLocation[this.cellColumn != -1 ? this.rows : 0];
        if (this.cellColumn != -1) {
            for (int i = 0; i < this.rows; ++i) {
                matrixLocationArray[i] = new MatrixLocation(i, this.cellColumn);
            }
        }
        return matrixLocationArray;
    }

    public int getCount() {
        return this.cellColumn != -1 ? this.rows : 0;
    }

    public boolean contains(int n, int n2) {
        return this.cellColumn != -1 ? n2 == this.cellColumn : false;
    }

    public boolean contains(MatrixLocation matrixLocation) {
        return this.cellColumn != -1 ? matrixLocation.column == this.cellColumn : false;
    }

    public void setMaxRows(int n) {
        this.rows = n;
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    public int getMaxRows() {
        return this.rows;
    }

    public ColumnMatrixSelection(int n, int n2) {
        this.rows = n;
        this.cellColumn = n2;
    }

    public ColumnMatrixSelection(int n) {
        this.rows = n;
    }

    public ColumnMatrixSelection() {
    }
}

