/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.Res;
import com.borland.jbcl.control.TreeItems;
import com.borland.jbcl.model.BasicGraphSelection;
import com.borland.jbcl.model.BasicTreeContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphModel;
import com.borland.jbcl.model.WritableGraphModel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.ExpandingTextItemEditor;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.SelectableItemPainter;
import com.borland.jbcl.view.TextItemPainter;
import com.borland.jbcl.view.TreeView;
import java.awt.Component;
import java.awt.Image;
import java.io.Serializable;

public class TreeControl
extends TreeView
implements Serializable,
GraphModel,
BlackBox {
    protected String textureName;
    private String[] items;

    public void enableModelEvents(boolean bl) {
        WritableGraphModel writableGraphModel = this.getWriteModel();
        if (writableGraphModel != null) {
            writableGraphModel.enableModelEvents(bl);
        }
    }

    public void removeAllItems() {
        WritableGraphModel writableGraphModel = this.getWriteModel();
        if (writableGraphModel != null) {
            writableGraphModel.removeAll();
        }
    }

    public void removeAll() {
        super.removeAll();
    }

    public void remove(GraphLocation graphLocation) {
        WritableGraphModel writableGraphModel = this.getWriteModel();
        if (writableGraphModel != null) {
            writableGraphModel.remove(graphLocation);
        }
    }

    public void removeChildren(GraphLocation graphLocation) {
        WritableGraphModel writableGraphModel = this.getWriteModel();
        if (writableGraphModel != null) {
            writableGraphModel.removeChildren(graphLocation);
        }
    }

    public GraphLocation addChild(GraphLocation graphLocation, GraphLocation graphLocation2, Object object) {
        WritableGraphModel writableGraphModel = this.getWriteModel();
        return writableGraphModel != null ? writableGraphModel.addChild(graphLocation, graphLocation2, object) : null;
    }

    public GraphLocation addChild(GraphLocation graphLocation, Object object) {
        WritableGraphModel writableGraphModel = this.getWriteModel();
        return writableGraphModel != null ? writableGraphModel.addChild(graphLocation, object) : null;
    }

    public boolean isVariableSize() {
        WritableGraphModel writableGraphModel = this.getWriteModel();
        return writableGraphModel != null ? writableGraphModel.isVariableSize() : false;
    }

    public void touched(GraphLocation graphLocation) {
        WritableGraphModel writableGraphModel = this.getWriteModel();
        if (writableGraphModel != null) {
            writableGraphModel.touched(graphLocation);
        }
    }

    public void set(GraphLocation graphLocation, Object object) {
        WritableGraphModel writableGraphModel = this.getWriteModel();
        if (writableGraphModel != null) {
            writableGraphModel.set(graphLocation, object);
        }
    }

    public boolean canSet(GraphLocation graphLocation) {
        WritableGraphModel writableGraphModel = this.getWriteModel();
        return writableGraphModel != null ? writableGraphModel.canSet(graphLocation) : false;
    }

    public GraphLocation setRoot(Object object) {
        WritableGraphModel writableGraphModel = this.getWriteModel();
        return writableGraphModel != null ? writableGraphModel.setRoot(object) : null;
    }

    public GraphLocation find(Object object) {
        GraphModel graphModel = this.getModel();
        return graphModel != null ? graphModel.find(object) : null;
    }

    public Object get(GraphLocation graphLocation) {
        GraphModel graphModel = this.getModel();
        return graphModel != null ? graphModel.get(graphLocation) : null;
    }

    public GraphLocation getRoot() {
        GraphModel graphModel = this.getModel();
        return graphModel != null ? graphModel.getRoot() : null;
    }

    private void setupViewers() {
        FocusableItemPainter focusableItemPainter = new FocusableItemPainter(new SelectableItemPainter(new TextItemPainter()));
        ExpandingTextItemEditor expandingTextItemEditor = new ExpandingTextItemEditor();
        this.setViewManager(new BasicViewManager(focusableItemPainter, expandingTextItemEditor));
    }

    public void setModel(GraphModel graphModel) {
        if (graphModel == this) {
            throw new IllegalArgumentException(Res.getString(76));
        }
        super.setModel(graphModel);
    }

    public String getTextureName() {
        return this.textureName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String string) {
        if (string != null && !string.equals("")) {
            Image image = ImageLoader.load(string, (Component)this);
            if (image == null) throw new IllegalArgumentException(string);
            ImageLoader.waitForImage(this, image);
            this.textureName = string;
            this.setTexture(image);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] stringArray) {
        this.items = stringArray;
        TreeItems treeItems = new TreeItems(stringArray);
        this.setModel(treeItems.getModel());
        this.setupViewers();
    }

    public TreeControl() {
        this.setModel(new BasicTreeContainer());
        this.setupViewers();
        this.setSelection(new BasicGraphSelection());
    }
}

