/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.util.BlackBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JComponent;

public class ShapeControl
extends JComponent
implements BlackBox,
Serializable {
    private boolean fill = true;
    private boolean drawEdge = true;
    private Color edgeColor = Color.black;
    private int type = 0;
    public static final int NEG_SLOPE_LINE = 9;
    public static final int POS_SLOPE_LINE = 8;
    public static final int VERT_LINE = 7;
    public static final int HORZ_LINE = 6;
    public static final int CIRCLE = 5;
    public static final int ELLIPSE = 4;
    public static final int ROUND_SQUARE = 3;
    public static final int SQUARE = 2;
    public static final int ROUND_RECT = 1;
    public static final int RECTANGLE = 0;

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getSize().width;
        int n5 = this.getSize().height;
        int n6 = n = n4 < n5 ? n4 : n5;
        if (this.type == 2 || this.type == 3 || this.type == 5) {
            n2 += (n4 - n) / 2;
            n3 += (n5 - n) / 2;
            n4 = n;
            n5 = n;
        }
        switch (this.type) {
            case 0: 
            case 2: {
                if (this.fill) {
                    graphics.setColor(this.getForeground());
                    graphics.fillRect(n2, n3, n4, n5);
                }
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
                break;
            }
            case 1: 
            case 3: {
                if (this.fill) {
                    graphics.setColor(this.getForeground());
                    graphics.fillRoundRect(n2, n3, n4, n5, n / 4, n / 4);
                }
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawRoundRect(n2, n3, n4 - 1, n5 - 1, n / 4, n / 4);
                break;
            }
            case 4: 
            case 5: {
                if (this.fill) {
                    graphics.setColor(this.getForeground());
                    graphics.fillOval(n2, n3, n4, n5);
                }
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawOval(n2, n3, n4 - 1, n5 - 1);
                break;
            }
            case 6: {
                graphics.setColor(this.getForeground());
                graphics.drawLine(n2, n3, n2 + n4, n3);
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawLine(n2, n3 + 1, n2 + n4, n3 + 1);
                break;
            }
            case 7: {
                graphics.setColor(this.getForeground());
                graphics.drawLine(n2, n3, n2, n3 + n5);
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawLine(n2 + 1, n3, n2 + 1, n3 + n5);
                break;
            }
            case 8: {
                if (this.drawEdge) {
                    graphics.setColor(this.edgeColor);
                    graphics.drawLine(n2, n3 + 1 + n5, n2 + n4, n3 + 1);
                }
                graphics.setColor(this.getForeground());
                graphics.drawLine(n2, n3 + n5, n2 + n4, n3);
                break;
            }
            case 9: {
                if (this.drawEdge) {
                    graphics.setColor(this.edgeColor);
                    graphics.drawLine(n2, n3 + 1, n2 + n4, n3 + n5 + 1);
                }
                graphics.setColor(this.getForeground());
                graphics.drawLine(n2, n3, n2 + n4, n3 + n5);
            }
        }
    }

    public boolean isDrawEdge() {
        return this.drawEdge;
    }

    public void setDrawEdge(boolean bl) {
        this.drawEdge = bl;
        this.repaint(100L);
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color color) {
        this.edgeColor = color;
        this.repaint(100L);
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean bl) {
        this.fill = bl;
        this.repaint(100L);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (this.type != n) {
            this.type = n;
            this.repaint(100L);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint(100L);
    }

    public ShapeControl(int n) {
        this();
        this.setType(n);
    }

    public ShapeControl() {
        this.setSize(100, 100);
        super.setForeground(Color.white);
    }
}

