/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.GridControl;
import com.borland.jbcl.control.ISearchControl;
import com.borland.jbcl.control.Res;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;

class LookupDialog
extends Dialog
implements Serializable,
ActionListener,
KeyListener,
MouseListener {
    Frame frame;
    Dimension screenSize = null;
    boolean displayOKCancel = false;
    boolean alwaysCenter = false;
    boolean allowSearch = false;
    boolean useValue = false;
    GridControl lookupGrid;
    Button cancelButton;
    Button okButton;
    Panel buttonFlowPanel;
    Panel buttonGridPanel;
    FlowLayout flowLayout;
    ISearchControl iSearchControl;
    BorderLayout borderLayout;
    GridLayout gridLayout = new GridLayout();

    public boolean isDisplayOKCancel() {
        return this.displayOKCancel;
    }

    public void setDisplayOKCancel(boolean bl) {
        this.displayOKCancel = bl;
        this.buttonFlowPanel.setVisible(bl);
    }

    public boolean isAlwaysCenter() {
        return this.alwaysCenter;
    }

    public void setAlwaysCenter(boolean bl) {
        this.alwaysCenter = bl;
    }

    public boolean isAllowSearch() {
        return this.allowSearch;
    }

    public void setAllowSearch(boolean bl) {
        this.allowSearch = bl;
        this.iSearchControl.setVisible(bl);
    }

    public boolean useValue() {
        return this.useValue;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 27) {
            this.useValue = false;
            if (keyEvent.getKeyCode() == 10) {
                this.useValue = true;
            }
            ((Component)this).setVisible(false);
            this.frame.toFront();
            this.dispose();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2) {
            this.useValue = true;
            ((Component)this).setVisible(false);
            this.frame.toFront();
            this.dispose();
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.useValue = false;
            ((Component)this).setVisible(false);
            this.frame.toFront();
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    private void centerDialog() {
        Dimension dimension = this.getPreferredSize();
        if (dimension.height >= this.screenSize.height) {
            dimension.height = this.screenSize.height / 2;
        }
        if (dimension.width >= this.screenSize.width) {
            dimension.width = this.screenSize.width / 2;
        }
        ((Component)this).setSize(dimension.width, dimension.height);
        ((Component)this).setLocation((this.screenSize.width - dimension.width) / 2, (this.screenSize.height - dimension.height) / 2);
    }

    public void show() {
        if (this.alwaysCenter) {
            this.centerDialog();
        }
        this.iSearchControl.setVisible(this.allowSearch);
        this.buttonFlowPanel.setVisible(this.displayOKCancel);
        super.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.useValue = true;
        } else if (object == this.cancelButton) {
            this.useValue = false;
        }
        this.dispose();
    }

    public void jbInit() throws Exception {
        this.setLayout(this.borderLayout);
        this.okButton.setLabel(Res.getString(0));
        this.okButton.addActionListener(this);
        this.cancelButton.setLabel(Res.getString(5));
        this.cancelButton.addActionListener(this);
        this.gridLayout.setHgap(5);
        this.buttonGridPanel.setLayout(this.gridLayout);
        this.buttonGridPanel.add((Component)this.okButton, null);
        this.buttonGridPanel.add((Component)this.cancelButton, null);
        this.buttonFlowPanel.setLayout(this.flowLayout);
        this.buttonFlowPanel.add(this.buttonGridPanel);
        this.iSearchControl.setDataSet(this.lookupGrid.getDataSet());
        this.iSearchControl.addKeyListener(this);
        this.lookupGrid.addMouseListener(this);
        this.lookupGrid.addKeyListener(this);
        this.add((Component)this.iSearchControl, "North");
        this.add((Component)this.buttonFlowPanel, "South");
        this.add((Component)this.lookupGrid, "Center");
    }

    public LookupDialog(Frame frame, GridControl gridControl, boolean bl, boolean bl2, boolean bl3) {
        super(frame, "", true);
        this.borderLayout = new BorderLayout();
        this.flowLayout = new FlowLayout();
        this.buttonGridPanel = new Panel();
        this.buttonFlowPanel = new Panel();
        this.okButton = new Button();
        this.cancelButton = new Button();
        try {
            this.frame = frame;
            this.lookupGrid = gridControl;
            this.allowSearch = bl;
            this.alwaysCenter = bl2;
            this.displayOKCancel = bl3;
            this.iSearchControl = new ISearchControl(gridControl);
            this.jbInit();
            this.enableEvents(64L);
            this.pack();
            this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.centerDialog();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LookupDialog(Frame frame, GridControl gridControl, boolean bl, boolean bl2) {
        this(frame, gridControl, true, false, false);
    }

    public LookupDialog(Frame frame, GridControl gridControl, boolean bl) {
        this(frame, gridControl, true, false);
    }

    public LookupDialog(Frame frame, GridControl gridControl) {
        this(frame, gridControl, true);
    }
}

