/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.Variant;
import com.borland.jbcl.control.FieldControl;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.ImageItemEditor;
import com.borland.jbcl.view.ImageItemPainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;

public class ImageControl
extends FieldControl
implements Serializable,
BlackBox {
    private Variant value = new Variant();
    private String boundName;
    private URL url;
    private String imageName;

    protected void updateSelection() {
        if (this.getDataSet() != null && this.getColumnName() != null) {
            try {
                this.getDataSet().getVariant(this.getColumnName(), this.value);
                try {
                    Image image = ImageLoader.loadFromBlob(this.value, this, true);
                    this.setupImage(image, "");
                }
                catch (IOException iOException) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.repaint(100L);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 3) != 0) {
            this.invalidate();
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        Graphics graphics;
        if (this.isVisible() && (graphics = this.getGraphics()) != null) {
            Rectangle rectangle = this.getInnerRect();
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        super.modelContentChanged(singletonModelEvent);
    }

    protected void setupImage(Image image, String string) throws IOException {
        Graphics graphics;
        if (this.isReadOnly()) {
            throw new IllegalStateException(Res.getString(70));
        }
        this.prepareImage(image, this);
        if ((this.checkImage(image, this) & 0x40) != 0) {
            throw new IOException(Res.format(22, new String[]{string}));
        }
        this.imageName = string;
        if (this.isVisible() && (graphics = this.getGraphics()) != null) {
            Rectangle rectangle = this.getInnerRect();
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.getWriteModel() != null) {
            this.getWriteModel().set(image);
        }
    }

    public URL getImageURL() {
        return this.url;
    }

    public void setImageURL(URL uRL) throws IOException {
        this.url = uRL;
        this.setupImage(ImageLoader.load(uRL, (Component)this), uRL.toString());
    }

    public Image getImage() {
        Object object = this.getModel().get();
        return object instanceof Image ? (Image)object : null;
    }

    public void setImage(Image image) throws IOException {
        this.setupImage(image, "");
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String string) throws IOException {
        if (string != null && !string.equals("")) {
            this.setupImage(ImageLoader.load(string, (Component)this), string);
        } else {
            if (this.isReadOnly()) {
                throw new IllegalStateException(Res.getString(70));
            }
            this.imageName = null;
            this.getWriteModel().set(null);
        }
    }

    public void setModel(SingletonModel singletonModel) {
        if (singletonModel == this) {
            throw new IllegalArgumentException(Res.getString(76));
        }
        super.setModel(singletonModel);
    }

    protected void defaultLayout() {
        this.setModel(new BasicSingletonContainer());
        this.setViewManager(new BasicViewManager(new FocusableItemPainter(new ImageItemPainter(this, this.getAlignment())), new ImageItemEditor()));
    }

    public ImageControl() {
        this.setAlignment(68);
        this.setPreferredHeight(100);
        this.setEditInPlace(false);
        this.defaultLayout();
    }
}

