/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetAware;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.jb.util.VetoException;
import com.borland.jbcl.control.DatasetColumnView;
import com.borland.jbcl.control.GridControl_ColumnView;
import com.borland.jbcl.control.GridControl_DSRowHeaderManager;
import com.borland.jbcl.control.GridControl_FocusAdapter;
import com.borland.jbcl.control.GridControl_PopupSupport;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicMatrixContainer;
import com.borland.jbcl.model.BasicMatrixSelection;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.ColumnMatrixSelection;
import com.borland.jbcl.model.CrossMatrixSelection;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.MatrixDataSetManager;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixModel;
import com.borland.jbcl.model.MatrixSubfocusEvent;
import com.borland.jbcl.model.MatrixSubfocusListener;
import com.borland.jbcl.model.MultiColumnMatrixSelection;
import com.borland.jbcl.model.MultiRowMatrixSelection;
import com.borland.jbcl.model.RowMatrixSelection;
import com.borland.jbcl.model.SingleMatrixSelection;
import com.borland.jbcl.model.WritableMatrixModel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.ColumnView;
import com.borland.jbcl.view.DefaultColumnHeaderManager;
import com.borland.jbcl.view.DefaultRowHeaderManager;
import com.borland.jbcl.view.FixedSizeVector;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.GridView;
import com.borland.jbcl.view.SelectableItemPainter;
import com.borland.jbcl.view.SizeVector;
import com.borland.jbcl.view.TextItemEditor;
import com.borland.jbcl.view.TextItemPainter;
import com.borland.jbcl.view.VariableSizeVector;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Insets;
import java.beans.Beans;
import java.io.Serializable;

public class GridControl
extends GridView
implements Serializable,
BlackBox,
DataSetAware,
WritableMatrixModel,
AccessListener,
DataChangeListener,
NavigationListener,
MatrixSubfocusListener {
    private GridControl_PopupSupport pop;
    protected String textureName;
    private String[][] items = new String[1][1];
    private boolean autoInsert = true;
    private boolean addNotifyCalled = false;
    private boolean multiSelect = false;
    private boolean selectColumn = false;
    private boolean selectRow = false;
    private boolean userSetNavigate = true;
    private boolean navigateDataSet = false;
    private boolean sortOnClick = true;
    private boolean generatedColumns = false;
    private DataSet dataSet;
    private ColumnView[] oldViews;
    private MatrixLocation oldSubfocus;
    private StorageDataSet oldSDS;
    private transient SizeVector oldCSizes;
    private transient SizeVector oldRSizes;
    private transient boolean dsNavigating = false;

    public void enableModelEvents(boolean bl) {
        WritableMatrixModel writableMatrixModel = this.getWriteModel();
        if (writableMatrixModel != null) {
            writableMatrixModel.enableModelEvents(bl);
        }
    }

    public void removeAllColumns() {
        WritableMatrixModel writableMatrixModel = this.getWriteModel();
        if (writableMatrixModel != null) {
            writableMatrixModel.removeAllColumns();
        }
    }

    public void removeColumn(int n) {
        WritableMatrixModel writableMatrixModel = this.getWriteModel();
        if (writableMatrixModel != null) {
            writableMatrixModel.removeColumn(n);
        }
    }

    public void addColumn(int n) {
        WritableMatrixModel writableMatrixModel = this.getWriteModel();
        if (writableMatrixModel != null) {
            writableMatrixModel.addColumn(n);
        }
    }

    public void addColumn() {
        WritableMatrixModel writableMatrixModel = this.getWriteModel();
        if (writableMatrixModel != null) {
            writableMatrixModel.addColumn();
        }
    }

    public boolean isVariableColumns() {
        WritableMatrixModel writableMatrixModel = this.getWriteModel();
        return writableMatrixModel != null ? writableMatrixModel.isVariableColumns() : false;
    }

    public void removeAllRows() {
        WritableMatrixModel writableMatrixModel = this.getWriteModel();
        if (writableMatrixModel != null) {
            writableMatrixModel.removeAllRows();
        }
    }

    public void removeRow(int n) {
        WritableMatrixModel writableMatrixModel = this.getWriteModel();
        if (writableMatrixModel != null) {
            writableMatrixModel.removeRow(n);
        }
    }

    public void addRow(int n) {
        WritableMatrixModel writableMatrixModel = this.getWriteModel();
        if (writableMatrixModel != null) {
            writableMatrixModel.addRow(n);
        }
    }

    public void addRow() {
        WritableMatrixModel writableMatrixModel = this.getWriteModel();
        if (writableMatrixModel != null) {
            writableMatrixModel.addRow();
        }
    }

    public boolean isVariableRows() {
        WritableMatrixModel writableMatrixModel = this.getWriteModel();
        return writableMatrixModel != null ? writableMatrixModel.isVariableRows() : false;
    }

    public void touched(int n, int n2) {
        WritableMatrixModel writableMatrixModel = this.getWriteModel();
        if (writableMatrixModel != null) {
            writableMatrixModel.touched(n, n2);
        }
    }

    public void set(int n, int n2, Object object) {
        WritableMatrixModel writableMatrixModel = this.getWriteModel();
        if (writableMatrixModel != null) {
            writableMatrixModel.set(n, n2, object);
        }
    }

    public boolean canSet(int n, int n2, boolean bl) {
        WritableMatrixModel writableMatrixModel = this.getWriteModel();
        return writableMatrixModel != null ? writableMatrixModel.canSet(n, n2, bl) : false;
    }

    public int getColumnCount() {
        MatrixModel matrixModel = this.getModel();
        return matrixModel != null ? matrixModel.getColumnCount() : 0;
    }

    public int getRowCount() {
        MatrixModel matrixModel = this.getModel();
        return matrixModel != null ? matrixModel.getRowCount() : 0;
    }

    public MatrixLocation find(Object object) {
        MatrixModel matrixModel = this.getModel();
        return matrixModel != null ? matrixModel.find(object) : null;
    }

    public Object get(int n, int n2) {
        MatrixModel matrixModel = this.getModel();
        return matrixModel != null ? matrixModel.get(n, n2) : null;
    }

    private ColumnView widthCheck(ColumnView columnView) {
        GridControl_ColumnView gridControl_ColumnView = new GridControl_ColumnView(columnView);
        if (gridControl_ColumnView.getWidth() == 0 || !gridControl_ColumnView.getFlag(7)) {
            if (this.dataSet != null) {
                try {
                    FontMetrics fontMetrics;
                    Column column = this.dataSet.getColumn(gridControl_ColumnView.getName());
                    Font font = gridControl_ColumnView.getFont();
                    if (font == null) {
                        font = this.getFont();
                    }
                    if ((fontMetrics = this.getGraphics().getFontMetrics(font)) != null) {
                        int n = Math.max(fontMetrics.stringWidth("e") * column.getWidth(), fontMetrics.stringWidth(gridControl_ColumnView.getCaption() != null ? gridControl_ColumnView.getCaption() : "") + 10);
                        if (n > 0) {
                            gridControl_ColumnView.setWidth(n < 500 ? n : 500);
                        } else {
                            gridControl_ColumnView.setWidth(this.getDefaultColumnWidth());
                        }
                        gridControl_ColumnView.setFlag(7, false);
                    }
                }
                catch (Exception exception) {
                    gridControl_ColumnView.setWidth(this.getDefaultColumnWidth());
                    gridControl_ColumnView.setFlag(7, false);
                }
            } else {
                gridControl_ColumnView.setWidth(this.getDefaultColumnWidth());
                gridControl_ColumnView.setFlag(7, false);
            }
        }
        return gridControl_ColumnView;
    }

    private ColumnView[] widthCheck(ColumnView[] columnViewArray) {
        for (int i = 0; i < columnViewArray.length; ++i) {
            ColumnView columnView = columnViewArray[i];
            GridControl_ColumnView gridControl_ColumnView = new GridControl_ColumnView(columnView);
            if (gridControl_ColumnView.getWidth() != 0 && gridControl_ColumnView.getFlag(7)) continue;
            if (this.dataSet != null) {
                try {
                    FontMetrics fontMetrics;
                    Column column = this.dataSet.getColumn(gridControl_ColumnView.getName());
                    Font font = gridControl_ColumnView.getFont();
                    if (font == null) {
                        font = this.getFont();
                    }
                    if ((fontMetrics = this.getGraphics().getFontMetrics(font)) == null) continue;
                    int n = Math.max(fontMetrics.stringWidth("e") * column.getWidth(), fontMetrics.stringWidth(gridControl_ColumnView.getCaption() != null ? gridControl_ColumnView.getCaption() : "") + 10);
                    if (n > 0) {
                        gridControl_ColumnView.setWidth(n < 500 ? n : 500);
                    } else {
                        gridControl_ColumnView.setWidth(this.getDefaultColumnWidth());
                    }
                    gridControl_ColumnView.setFlag(7, false);
                    columnViewArray[i] = gridControl_ColumnView;
                }
                catch (Exception exception) {
                    gridControl_ColumnView.setWidth(this.getDefaultColumnWidth());
                    gridControl_ColumnView.setFlag(7, false);
                }
                continue;
            }
            gridControl_ColumnView.setWidth(this.getDefaultColumnWidth());
            gridControl_ColumnView.setFlag(7, false);
        }
        return columnViewArray;
    }

    private ColumnView[] purgeViews(ColumnView[] columnViewArray) {
        int n = columnViewArray.length;
        for (int i = 0; i < columnViewArray.length; ++i) {
            if (columnViewArray[i] != null) continue;
            --n;
        }
        ColumnView[] columnViewArray2 = new ColumnView[n];
        int n2 = 0;
        for (int i = 0; i < columnViewArray.length; ++i) {
            if (columnViewArray[i] == null) continue;
            columnViewArray2[n2] = columnViewArray[i];
            ++n2;
        }
        return this.widthCheck(columnViewArray2);
    }

    protected void buildColumnViews(DataSet dataSet) {
        ColumnView[] columnViewArray = null;
        int[] nArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n = dataSet.getColumnCount();
        columnViewArray = new ColumnView[n];
        nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            try {
                Column column = dataSet.getColumn(i);
                if (column == null || !dataSet.columnIsVisible(column.getColumnName())) continue;
                int n4 = this.findOldView(column.getColumnName());
                if (n4 >= 0) {
                    columnViewArray[n3] = new DatasetColumnView(column, this.oldViews[n4]);
                    if (Beans.isDesignTime()) {
                        nArray[n3] = this.widthCheck(columnViewArray[n3]).getWidth();
                    }
                    ++n3;
                    ++n2;
                    continue;
                }
                columnViewArray[n3++] = new DatasetColumnView(column);
                continue;
            }
            catch (DataSetException dataSetException) {
                // empty catch block
            }
        }
        columnViewArray = this.purgeViews(columnViewArray);
        n = columnViewArray.length;
        super.setColumnViews(columnViewArray);
        for (n3 = 0; n3 < n; ++n3) {
            if (nArray[n3] != 0) continue;
            nArray[n3] = columnViewArray[n3].getWidth();
        }
        VariableSizeVector variableSizeVector = new VariableSizeVector(nArray);
        this.setColumnSizes(variableSizeVector);
        int n5 = n2 - n;
        if (this.oldRSizes != null && n5 >= -1 && n5 <= 1) {
            this.setRowSizes(this.oldRSizes);
        } else {
            FixedSizeVector fixedSizeVector = new FixedSizeVector(20);
            this.setRowSizes(fixedSizeVector);
        }
    }

    private int findOldView(String string) {
        if (this.oldViews != null) {
            for (int i = 0; i < this.oldViews.length; ++i) {
                if (!this.oldViews[i].getName().equals(string)) continue;
                return i;
            }
        }
        return -1;
    }

    private synchronized void bindDataSet() {
        boolean bl = this.isBatchMode();
        if (this.dataSet != null && this.dataSet.getStorageDataSet() != null) {
            this.buildColumnViews(this.dataSet);
            this.setBatchMode(true);
            this.navigateDataSet = true;
            ColumnView[] columnViewArray = this.getColumnViews();
            Column[] columnArray = new Column[columnViewArray.length];
            for (int i = 0; i < columnViewArray.length; ++i) {
                columnArray[i] = this.dataSet.hasColumn(columnViewArray[i].getName());
            }
            if (this.columnHeader != null) {
                DefaultColumnHeaderManager defaultColumnHeaderManager = new DefaultColumnHeaderManager(this);
                this.columnHeader.setModel(defaultColumnHeaderManager);
                this.columnHeader.setViewManager(defaultColumnHeaderManager);
                this.columnHeader.repaint(100L);
            }
            if (this.rowHeader != null) {
                GridControl_DSRowHeaderManager gridControl_DSRowHeaderManager = new GridControl_DSRowHeaderManager(this.dataSet);
                this.rowHeader.setModel(gridControl_DSRowHeaderManager);
                this.rowHeader.setViewManager(gridControl_DSRowHeaderManager);
                this.rowHeader.repaint(100L);
            }
            this.getModel();
            MatrixDataSetManager matrixDataSetManager = new MatrixDataSetManager(this.dataSet, columnArray, this);
            this.setModel(matrixDataSetManager);
            this.setViewManager(matrixDataSetManager);
        }
        this.setNavigateWithDataSet(true);
        this.setAutoAppend(true);
        this.resetSelection();
        this.setSubfocus(this.dataSet.getRow(), this.getSubfocus().column);
        this.setBatchMode(bl);
        if (this.isShowing() && !bl) {
            this.validate();
        }
    }

    protected void columnHeaderClicked(int n) {
        if (this.isSortOnHeaderClick() && this.dataSet != null) {
            if (!this.isBatchMode()) {
                this.toggleColumnSort(n);
            }
        } else {
            super.columnHeaderClicked(n);
        }
    }

    public void toggleColumnSort(int n) {
        String string;
        Column column;
        if (this.dataSet == null) {
            return;
        }
        if (this.dataSet.isEditing()) {
            try {
                this.dataSet.post();
            }
            catch (DataSetException dataSetException) {
                return;
            }
        }
        if ((column = this.dataSet.hasColumn(string = this.getColumnView(n).getName())) == null || !column.isSortable()) {
            return;
        }
        try {
            this.dataSet.toggleViewOrder(string);
        }
        catch (Exception exception) {
            DataSetModel.handleException(exception);
        }
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 2: {
                if (accessEvent.getReason() == 8 || accessEvent.getReason() == 9) {
                    this.setBatchMode(true);
                    this.oldSubfocus = new MatrixLocation(this.getSubfocus());
                }
                if (this.getModel() instanceof MatrixDataSetManager) {
                    this.oldRSizes = this.getRowSizes();
                    this.oldCSizes = this.getColumnSizes();
                    this.oldViews = this.getColumnViews();
                }
                this.safeEndEdit(false);
                this.buildStringGrid(null);
                break;
            }
            case 1: {
                DataSet dataSet = (DataSet)accessEvent.getSource();
                try {
                    this.openDataSet(dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                if (accessEvent.getReason() == 2) {
                    if (this.navigateDataSet && this.userSetNavigate) {
                        if (this.oldSubfocus != null) {
                            this.setSubfocus(this.dataSet.getRow(), this.oldSubfocus.column);
                        } else {
                            this.setSubfocus(this.dataSet.getRow(), 0);
                        }
                    }
                    if (this.oldViews != null) {
                        this.setColumnViews(this.oldViews);
                    }
                }
                if (accessEvent.getReason() == 1 && (this.getColumnViews() == null || this.getColumnViews().length == 0)) {
                    this.bindDataSet();
                }
                this.setBatchMode(false);
                this.oldRSizes = null;
                this.oldCSizes = null;
                this.oldViews = null;
                break;
            }
            default: {
                this.setBatchMode(false);
            }
        }
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        this.endEdit();
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
    }

    public void navigated(NavigationEvent navigationEvent) {
        try {
            if (!this.dsNavigating && this.userSetNavigate && this.navigateDataSet && this.getSubfocus().row != this.dataSet.getRow() && this.dataSet.getRowCount() > this.dataSet.getRow()) {
                this.setSubfocus(this.dataSet.getRow(), this.getSubfocus().column);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void subfocusChanged(MatrixSubfocusEvent matrixSubfocusEvent) {
    }

    public void subfocusChanging(MatrixSubfocusEvent matrixSubfocusEvent) throws VetoException {
        if (this.dataSet != null && this.dataSet.isOpen() && this.userSetNavigate && this.navigateDataSet) {
            try {
                try {
                    this.dataSet.setLastColumnVisited(this.getColumnView(matrixSubfocusEvent.getLocation().column).getName());
                    if (this.dataSet.getRow() != matrixSubfocusEvent.getLocation().row) {
                        this.dsNavigating = true;
                        if (!this.dataSet.goToRow(matrixSubfocusEvent.getLocation().row)) {
                            this.dsNavigating = false;
                            throw new VetoException();
                        }
                    }
                    Object var4_2 = null;
                    this.dsNavigating = false;
                }
                catch (DataSetException dataSetException) {
                    DataSetModel.handleException(this.dataSet, this, (Exception)((Object)dataSetException));
                    this.dsNavigating = false;
                    throw new VetoException();
                }
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.dsNavigating = false;
                throw throwable;
            }
        }
    }

    private void buildStringGrid(String[][] stringArray) {
        ColumnView[] columnViewArray = this.getColumnViews();
        String[] stringArray2 = this.getColumnCaptions();
        if (stringArray == null || stringArray.length < 1 || stringArray[0].length < 1) {
            columnViewArray = null;
            stringArray2 = new String[1];
            stringArray = new String[1][1];
        }
        this.navigateDataSet = false;
        ColumnView[] columnViewArray2 = new ColumnView[stringArray[0].length];
        VariableSizeVector variableSizeVector = new VariableSizeVector();
        for (int i = 0; i < columnViewArray2.length; ++i) {
            String string = String.valueOf("StringGridColumn").concat(String.valueOf(i));
            if (columnViewArray != null && columnViewArray.length > i && columnViewArray[i].getName() == string) {
                columnViewArray2[i] = columnViewArray[i];
            } else {
                columnViewArray2[i] = new ColumnView();
                columnViewArray2[i].setName(string);
                if (stringArray2.length > i) {
                    columnViewArray2[i].setCaption(stringArray2[i]);
                }
                columnViewArray2[i].setAlignment(33);
                columnViewArray2[i].setWidth(this.getDefaultColumnWidth());
                columnViewArray2[i].setItemMargins(new Insets(0, 2, 0, 2));
                columnViewArray2[i].resetUserFlags();
            }
            variableSizeVector.setSize(i, columnViewArray2[i].getWidth());
        }
        this.setColumnSizes(variableSizeVector);
        this.setModel(new BasicMatrixContainer(stringArray));
        this.setViewManager(new BasicViewManager(new FocusableItemPainter(new SelectableItemPainter(new TextItemPainter(33))), new TextItemEditor(33)));
        super.setColumnViews(columnViewArray2);
        if (this.columnHeader != null) {
            DefaultColumnHeaderManager defaultColumnHeaderManager = new DefaultColumnHeaderManager(this);
            this.columnHeader.setModel(defaultColumnHeaderManager);
            this.columnHeader.setViewManager(defaultColumnHeaderManager);
            this.columnHeader.repaint(100L);
        }
        if (this.rowHeader != null) {
            DefaultRowHeaderManager defaultRowHeaderManager = new DefaultRowHeaderManager(this);
            this.rowHeader.setModel(defaultRowHeaderManager);
            this.rowHeader.setViewManager(defaultRowHeaderManager);
            this.rowHeader.repaint(100L);
        }
        FixedSizeVector fixedSizeVector = new FixedSizeVector(20);
        this.setRowSizes(fixedSizeVector);
        this.setNavigateWithDataSet(false);
        this.setAutoAppend(false);
        this.resetSelection();
        this.generatedColumns = true;
        if (this.isShowing() && !this.isBatchMode()) {
            this.validate();
        }
    }

    public boolean isShowPopup() {
        return this.pop.isAlive();
    }

    public void setShowPopup(boolean bl) {
        this.pop.setAlive(bl);
    }

    public boolean isNavigateWithDataSet() {
        return this.userSetNavigate;
    }

    public void setNavigateWithDataSet(boolean bl) {
        this.userSetNavigate = bl;
        if (this.userSetNavigate && this.navigateDataSet && this.dataSet != null && this.dataSet.isOpen()) {
            this.setSubfocus(this.dataSet.getRow(), this.getSubfocus().column);
        }
    }

    public boolean isSortOnHeaderClick() {
        if (this.getModel() instanceof MatrixDataSetManager) {
            return this.sortOnClick;
        }
        return false;
    }

    public void setSortOnHeaderClick(boolean bl) {
        this.sortOnClick = bl;
    }

    public boolean isAutoInsert() {
        return this.autoInsert;
    }

    public void setAutoInsert(boolean bl) {
        this.autoInsert = bl;
    }

    private void resetSelection() {
        if (this.multiSelect && this.selectRow && this.selectColumn) {
            this.setSelection(new CrossMatrixSelection(this.getRowCount(), this.getColumnCount(), this.getSubfocus()));
        } else if (this.multiSelect && this.selectRow) {
            this.setSelection(new MultiRowMatrixSelection(this.getColumnCount(), this.getSelection().getAll()));
        } else if (this.multiSelect && this.selectColumn) {
            this.setSelection(new MultiColumnMatrixSelection(this.getRowCount(), this.getSelection().getAll()));
        } else if (this.multiSelect) {
            this.setSelection(new BasicMatrixSelection(this.getSelection().getAll()));
        } else if (this.selectRow && this.selectColumn) {
            this.setSelection(new CrossMatrixSelection(this.getRowCount(), this.getColumnCount(), this.getSubfocus()));
        } else if (this.selectRow) {
            this.setSelection(new RowMatrixSelection(this.getColumnCount(), this.getSubfocus().row));
        } else if (this.selectColumn) {
            this.setSelection(new ColumnMatrixSelection(this.getRowCount(), this.getSubfocus().column));
        } else {
            this.setSelection(new SingleMatrixSelection(this.getSubfocus()));
        }
        this.repaint(100L);
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean bl) {
        if (this.multiSelect != bl) {
            this.multiSelect = bl;
            this.resetSelection();
        }
    }

    public boolean isSelectColumn() {
        return this.selectColumn;
    }

    public void setSelectColumn(boolean bl) {
        if (this.selectColumn != bl) {
            this.selectColumn = bl;
            this.resetSelection();
        }
    }

    public boolean isSelectRow() {
        return this.selectRow;
    }

    public void setSelectRow(boolean bl) {
        if (this.selectRow != bl) {
            this.selectRow = bl;
            this.resetSelection();
        }
    }

    private void openDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.buildStringGrid(null);
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException dataSetException) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)dataSetException));
                this.buildStringGrid(null);
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener((AccessListener)this);
            this.dataSet.removeNavigationListener((NavigationListener)this);
            this.dataSet.removeDataChangeListener((DataChangeListener)this);
        }
        this.openDataSet(dataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener((AccessListener)this);
            this.dataSet.addNavigationListener((NavigationListener)this);
            this.dataSet.addDataChangeListener((DataChangeListener)this);
        }
    }

    public String[] getColumnCaptions() {
        ColumnView[] columnViewArray = this.getColumnViews();
        if (columnViewArray == null || columnViewArray.length == 0) {
            return new String[0];
        }
        String[] stringArray = new String[columnViewArray.length];
        for (int i = 0; i < columnViewArray.length; ++i) {
            stringArray[i] = columnViewArray[i].getCaption();
        }
        return stringArray;
    }

    public void setColumnCaptions(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        ColumnView[] columnViewArray = this.getColumnViews();
        if (columnViewArray != null && columnViewArray.length == stringArray.length) {
            this.setBatchMode(true);
            for (int i = 0; i < stringArray.length; ++i) {
                columnViewArray[i].setCaption(stringArray[i]);
            }
            this.setBatchMode(false);
        } else {
            columnViewArray = new ColumnView[stringArray.length];
            VariableSizeVector variableSizeVector = new VariableSizeVector();
            for (int i = 0; i < columnViewArray.length; ++i) {
                columnViewArray[i] = new ColumnView();
                columnViewArray[i].setName(stringArray[i]);
                columnViewArray[i].setAlignment(33);
                columnViewArray[i].setWidth(this.getDefaultColumnWidth());
                columnViewArray[i].setItemMargins(new Insets(0, 2, 0, 2));
                columnViewArray[i].resetUserFlags();
                columnViewArray[i].setCaption(stringArray[i]);
                variableSizeVector.setSize(i, columnViewArray[i].getWidth());
            }
            this.setBatchMode(true);
            this.setColumnSizes(variableSizeVector);
            Object[][] objectArray = new String[1][columnViewArray.length];
            this.setModel(new BasicMatrixContainer(objectArray));
            super.setColumnViews(columnViewArray);
            this.generatedColumns = true;
            this.setBatchMode(false);
            this.validate();
        }
    }

    public void setColumnViews(ColumnView[] columnViewArray) {
        this.generatedColumns = false;
        super.setColumnViews(columnViewArray);
        if (this.columnHeader != null) {
            DefaultColumnHeaderManager defaultColumnHeaderManager = new DefaultColumnHeaderManager(this);
            this.columnHeader.setModel(defaultColumnHeaderManager);
            this.columnHeader.setViewManager(defaultColumnHeaderManager);
        }
        this.resetSelection();
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String string) {
        if (string != null && !string.equals("")) {
            Image image = ImageLoader.load(string, (Component)this);
            if (image == null) throw new IllegalArgumentException(string);
            ImageLoader.waitForImage(this, image);
            this.textureName = string;
            this.setTexture(image);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public synchronized String[][] getItems() {
        MatrixModel matrixModel = this.getModel();
        if (matrixModel == null || matrixModel instanceof MatrixDataSetManager) {
            return new String[0][0];
        }
        int n = matrixModel.getRowCount();
        int n2 = matrixModel.getColumnCount();
        String[][] stringArray = new String[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Object object = matrixModel.get(i, j);
                stringArray[i][j] = object != null ? object.toString() : "";
            }
        }
        return stringArray;
    }

    public synchronized void setItems(String[][] stringArray) {
        if (this.dataSet != null) {
            throw new IllegalStateException(Res.getString(75));
        }
        this.buildStringGrid(stringArray);
    }

    public void setModel(MatrixModel matrixModel) {
        if (matrixModel == this) {
            throw new IllegalArgumentException(Res.getString(76));
        }
        super.setModel(matrixModel);
    }

    public GridControl() {
        this.pop = new GridControl_PopupSupport(this);
        this.buildStringGrid(null);
        this.resetSelection();
        this.addFocusListener(new GridControl_FocusAdapter(this));
        this.addSubfocusListener(this);
        this.addMouseListener(this.pop);
        this.addKeyListener(this.pop);
    }
}

